PW.FormActions.create('storage-data-set-date-time-array-action', {
		
	enable: function() {
		if (this.target.type == "FORM"){
			this.setFormalParameter();
		}
	},
	
	defaultActions : {
		variable: function() {
			this.setFormalParameter();
		},
		button: function() {
			this.setFormalParameter();
		},
		variableSet: function() {
			this.setFormalParameter();
		},
		dtButton: function() {
			this.setFormalParameter();
		},
	},
	
	setFormalParameter: function() {
		var formalParameterText = VariableService.getValue("StorageData");
		var paramName = this.get("paramName");
		var paramValue = this.get("paramValue");
		if (!StorageData.isStringValidJsonObject(formalParameterText)) {
			formalParameterText = "{}";
		}
		var formalParameterObject = JSON.parse(formalParameterText);
		var dateTimeArray = this.createDateTimeArrayAsText(paramValue);
		formalParameterObject[paramName] = dateTimeArray;
		ServerLogger.debug("A parameter with key: '" + paramName + "' and value: [" +
				dateTimeArray.join(', ') + "] has been added or changed in StorageData");
		VariableService.setValue("StorageData", JSON.stringify(formalParameterObject, null, 2));
	},
	
	createDateTimeArrayAsText: function(dates) {
		var dateTimeArray = [];
		PW.each(dates, function(date) {
			dateTimeArray.push(StorageData.createDateTimeAsText(date));
		});
		return dateTimeArray;
	}
});
