PW.FormActions.create('exchange-rate-table-action', {
	defaultActions: {
		variableSet: function (variableSet, added, updated) {
			if (added.length > 0) {
				this.setRowValues(added);
			}
			if (updated.length > 0) {
				this.updateRows(updated, this.get("currency"));
				this.updateRows(updated, this.get("date"));
			}
		},
		dtButton: function(button) {
			this.setExchangeRateColumn(button);
		},
		button: function() {
			this.setExchangeRateColumn();
		}
	},

	setExchangeRateColumn: function(button) {
		let table;
		if (button) {
			let tableId = button.getVariableSet().getId();
			table = VariableSetService.get(tableId);
		} else {
			table = VariableSetService.get(this.get("dynamicTableId"));
		}
		for (let index = 0; index < VariableSetService.getRowsCount(table); index++) {
			this.processRowCondition(index);
		}
	},

	setRowValues: function(rows) {
		PW.each(rows, function(row) {
			this.processRowCondition(row.index);
		}, this);
	},

	processRowCondition: function(rowIndex) {
		this.setContextVariable("currentRow", rowIndex);
		if (this.get("condition")) {
			if (this.get("condition").call()) {
				this.setExchangeRateRowValue(rowIndex)
			}
		} else {
			this.setExchangeRateRowValue(rowIndex)
		}
	},

	updateRows: function (updatedData, updatingColumn) {
		if (updatedData == null || updatedData == undefined
			|| updatedData.length == 0) {
			this.setRowValues(updatedData);
		} else {
			let result = [];
			for (let j = 0; j < updatedData.length; j++) {
				if (this.checkIfAppropriateColumnIsUpdated(updatedData[j], updatingColumn)) {
					result.push(updatedData[j]);
				}
			}
			this.setRowValues(result);
		}
	},

	setExchangeRateRowValue: function(index) {
		const parameters = this.getParameters(index);
		const resultColumn = this.get("exchangerate");
		const tableNoVar = this.get('tableNo');
		const tableNameVar = this.get('tableName');
		const effectiveDateVar = this.get("effectiveDate");

		if (parameters) {
			jQuery.ajax({
				url: 'plugin/com.suncode-cuf-components/exchangerate/notimezone/pln',
				type: "GET",
				data: parameters,
				success: function(data) {
					resultColumn.setItemValue(data.mid, index);
					if (tableNoVar) {
						tableNoVar.setItemValue(data.no, index)
					}
					if (tableNameVar) {
						tableNameVar.setItemValue(data.table, index)
					}
					if (effectiveDateVar) {
						effectiveDateVar.setItemValue(data.effectiveDate, index);
					}
				},
				error: function() {
					MessageService.showFailure(CUFCommon.t("error.nbp.msg"));
				}
			});
		}
	},

	getParameters: function (index) {
		const currency = this.get("currency").getValue()[index];
		const date = this.get("date").getValue()[index];
		const dateOffset = this.get("dateOffset");

		if (currency === null || date === null) {
			return;
		}

		const formattedDate = Ext4.Date.format(Ext4.Date.add(date, Ext4.Date.DAY, dateOffset), "Y-m-d");
		return {
			currency: currency,
			date: formattedDate,
			activityId: ActivityInfoService.getActivityId()
		};
	},

	checkIfAppropriateColumnIsUpdated: function (updatedData, updatingColumn) {
		return updatedData.changes.some(value => value === updatingColumn.getId());
	}

});
