/**
 * Clear table implementation
 */

PW.FormActions.create('clear-table', {
  
	init: function(){
        if ( this.get("tableId") ){
        	this.table = VariableSetService.getVariableSet(this.get("tableId"));
        }
    },
	
    variableSetInit : function (table){
        this.table = table;
    },
    
    dtButtonInit: function (button) {
        this.table = button.variableSet;
    },
    
    defaultActions: {
        button: function(){
        	this.table.clear();
        },
        dtButton: function(){
        	this.table.clear();
        },
		variable: function(){
			this.table.clear();
		}
    },
    
    enable : function(){
    	var me = this;
    	if( this.target.type == 'FORM' ){
    		PW.each(me.get("tableClearVariables"), function (variable){
        	    variable.on("change", me.table.clear, me.table);
        	});
		}
    	
    	if ( this.target.type != "BUTTON" && this.target.type != "DT_BUTTON" ){
    		this.table.clear();
    	}
    },
    
    disable : function(){
    	var me = this;
    	if( this.target.type == 'FORM' ){
    		PW.each(me.get("tableClearVariables"), function (variable){
        	    variable.off("change", me.table.clear, me.table);
        	});
		}
    }
});