PW.Functions.register("groupBy", "string", ["string[]", "variable[]", "string", "string", "variable[]"],
	function (aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns) {
		return groupBy(aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns);
	});

PW.Functions.register("TableStore.groupBy", "string", ["string[]", "variable[]", "string[]", "string", "string", "variable[]"],
	function (aggregateFunctions, rawColumns, fieldId, concatSeparator, decimalPlaces, groupByColumns) {
		return groupBy(aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns, fieldId);
	});

function groupBy(aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns,fieldId) {
	var columnFunctionSet = columnAggregateFunction(rawColumns, aggregateFunctions);
	var aggregatedRows = getAggregateGroupedRows(rawColumns, groupByColumns, concatSeparator, decimalPlaces, columnFunctionSet);


	var keyMapping = fieldId?buildKeyMapping(rawColumns, fieldId):null;
	var result = createTableStore(aggregatedRows, rawColumns,keyMapping);

	return result;
}

function getAggregateGroupedRows(rawColumns, groupByColumns, concatSeparator, decimalPlaces, columnFunctionSet) {
	var rawAndGroupByColumns = rawColumns.concat(groupByColumns);
	var rows = toRows(rawAndGroupByColumns);
	var groupingColumnIds = groupByColumns.map(function (column) {
		return column.getId();
	});
	var columnIds = rawColumns.map(function (column) {
		return column.getId();
	});
	var groupedRows = groupRows(rows, groupingColumnIds);
	var aggregatedRows = aggregateGroupedRows(columnIds, groupedRows, concatSeparator, decimalPlaces, columnFunctionSet);
	return aggregatedRows;
}

function buildKeyMapping(rawColumns, fieldIds) {
	var keyMapping = new Map();
	rawColumns.forEach(function (column, index) {
		if (!column) {
			return
		}
		var newFiledId = column.getId();
		if (fieldIds.length > index && fieldIds[index]) {
			newFiledId = fieldIds[index]
		}
		keyMapping.set(column.getId(), newFiledId);
	});
	return keyMapping;
}

function columnAggregateFunction(rawColumns, aggregateFunctions) {
	var resultMap = {};
	for (var colNumber = 0; colNumber < rawColumns.length; colNumber++) {
			resultMap[rawColumns[colNumber].getId()] = aggregateFunctions[colNumber];
	}
	return resultMap;
}
function toRows(rawColumns) {
	var rows = [];
	var rowsCount = rawColumns[0].getValue().length;

	for (var i = 0; i < rowsCount; i++) {
		var columns = rawColumns.map(function(rawColumn) {
			return {
				columnId: rawColumn.getId(),
				value: rawColumn.getValue()[i]
			};
		});
		rows.push(columns);
	}
	return rows;
}
function groupRows(rows, groupingColumnIds) {
	var groupedRows = [];
	var groupIds = [];

	for (var i = 0; i < rows.length; i++) {
		var row = rows[i];
		var groupId = groupingColumnIds.map(function(groupingColumnId) {
			return row.filter(function(column) {
				return column.columnId == groupingColumnId;
			}
			)[0].value;
		}).join('_');
		if (groupIds.indexOf(groupId) == -1) {
			groupIds.push(groupId);
			groupedRows.push({
				groupId: groupId,
				listOfColumns: [row]
			});
		} else {
			groupedRows.filter(function(row) {
				return row.groupId == groupId;
			})[0].listOfColumns.push(row);
		}
	}
	return groupedRows;
}
function aggregateGroupedRows(columnIds, groupedRows, concatSeparator, decimalPlaces, columnFunctionMap) {
	return groupedRows.map(function(row) {
		var listOfColumns = row.listOfColumns;
		var groupedColumns = columnIds.map(function(columnId) {
			var valuesToAggregate = listOfColumns.map(function(columns) {
				return columns.filter(function(col) {
					return col.columnId === columnId;
				})[0].value;
			});
			var aggregateFunctions = columnFunctionMap[columnId];
			var resultValue = callAggregateFun(valuesToAggregate, concatSeparator, decimalPlaces, aggregateFunctions, columnId);
			return {
				columnId: columnId,
				value: resultValue
			};
		});
		return groupedColumns.map(function(columns) {
			return {
				columns: columns
			}
		});
	});
}
function callAggregateFun(valuesToAggregate, concatSeparator, decimalPlaces, aggregateFunction, columnId) {
	switch (aggregateFunction) {
		case "CONCAT":
			return concat(valuesToAggregate, concatSeparator);
		case "SUM":
			return sum(valuesToAggregate);
		case "MIN":
			return min(valuesToAggregate);
		case "MAX":
			return max(valuesToAggregate);
		case "AVG":
			//Wywoływane w pętli, dla przyspieszenia ogranioczone do AVG.
			//Api VariableService nie pobiera danych po tablicy columnIds, więc i tak musi być wykonywane w pętli
			//Można zmienić w przyszłości
			var columnType = VariableService.getVariable(columnId).type.name;
			return avg(valuesToAggregate, decimalPlaces, columnType);
		case "COUNT":
			return count(valuesToAggregate);
		case "GROUPINGVAL":
			return valuesToAggregate[0];
	}
}
function concat(valuesToAggregate, concatSeparator) {
	return (valuesToAggregate) ? valuesToAggregate.join(concatSeparator) : "";
}
function sum(valuesToAggregate) {
	var result = new Decimal(0);
	if (!valuesToAggregate) {
		return result
	}
	for (var i = 0; i < valuesToAggregate.length; i++) {
		if (valuesToAggregate[i]) {
			result = result.plus(valuesToAggregate[i]);
		}
	}
	return result.toNumber();
}
function min(valuesToAggregate) {
	var value = valuesToAggregate.find(function (el) { return el });

	if (value instanceof Date) {
		var filtered = valuesToAggregate.filter(function (el) { return el })
		if (filtered.length == 0) { return null }
		return formatDate(Math.min.apply(null, filtered));
	}
	return (value) ? Math.min.apply(null, valuesToAggregate) : null;
}
function max(valuesToAggregate) {
	var value = valuesToAggregate.find(function (el) { return el });

	if (value instanceof Date) {
		var filtered = valuesToAggregate.filter(function (el) { return el })
		if (filtered.length == 0) { return null }
		return formatDate(Math.max.apply(null, filtered));
	}
	return (value) ? Math.max.apply(null, valuesToAggregate) : null;
}
function avg(valuesToAggregate, decimalPlaces, columnType) {
	var result = new Decimal(0);
	if (!valuesToAggregate) {
		return result
	}
	for (var i = 0; i < valuesToAggregate.length; i++) {
		if (valuesToAggregate[i]) {
			result = result.plus(valuesToAggregate[i]);
		}
	}
	if (columnType == "integer[]") {
		return Math.round(result / valuesToAggregate.length);
	}
	return (result / valuesToAggregate.length).toFixed(decimalPlaces);
}
function count(valuesToAggregate) {
	if (!valuesToAggregate) {
		return null
	}
	var value = valuesToAggregate.find(function (el) { return el });
	if (!value || value instanceof Date) {
		return null
	}
	if (value.constructor == String) {
		return valuesToAggregate.length + "";
	}
	return (valuesToAggregate) ? valuesToAggregate.length : null;
}
function formatDate(date) {
	var d = new Date(date),
		month = '' + (d.getMonth() + 1),
		day = '' + d.getDate(),
		year = d.getFullYear();
	if (month.length < 2)
		month = '0' + month;
	if (day.length < 2)
		day = '0' + day;
	return [year, month, day].join('-');
}
function createTableStore(aggregatedRows, rawColumns,keyMapping) {
	var tableStore = JSON.parse(keyMapping?TableStore.createWithNewKeyMapping(rawColumns,keyMapping):TableStore.create(rawColumns));
	tableStore.data = new Array();
	tableStore = JSON.stringify(tableStore);

	aggregatedRows.forEach(function(row) {
		var colIds = [];
		var colValues = [];
		for (var col = 0; col < row.length; col++) {
			var varId=row[col].columns.columnId;
			colIds.push(keyMapping?keyMapping.get(varId):varId);
			colValues.push(row[col].columns.value);
		}
		tableStore = TableStore.addRecord(tableStore, colIds, colValues);
	});
	return tableStore;
}