PW.Functions.register("PDFUtils.PDF2TXT", "string", ["integer"], function (fileId) {
    let result = "";

    if (!fileId || fileId <= 0) {
        console.error("PDFUtils.PDF2TXT: File ID is required and must be positive");
        return "";
    }

    jQuery.ajax({
        url: "plugin/com.suncode-cuf-components/functions/pdf/pdf-to-text",
        method: "POST",
        data: JSON.stringify(fileId),
        contentType: "application/json",
        async: false,
        success: function (data) {
            result = data;
        },
        error: function (xhr, status, error) {
            console.error("Error calling PDFUtils.PDF2TXT:", error);
            result = "";
        }
    });

    return result;
});

PW.Functions.register("PDFUtils.isTextPDF", "boolean", ["integer"], function (fileId) {
    let result = false;

    if (!fileId || fileId <= 0) {
        console.error("PDFUtils.isTextPDF: File ID is required and must be positive");
        return false;
    }

    jQuery.ajax({
        url: "plugin/com.suncode-cuf-components/functions/pdf/is-text-pdf",
        method: "POST",
        data: JSON.stringify(fileId),
        contentType: "application/json",
        async: false,
        success: function (data) {
            result = data;
        },
        error: function (xhr, status, error) {
            console.error("Error calling PDFUtils.isTextPDF:", error);
            result = false;
        }
    });

    return result;
});
