/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils.handlers;

import com.suncode.cuf.common.utils.handlers.Handler;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ErrorHandlersExecution {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlersExecution.class);
    private Handler[] handlers;
    private Exception e;

    public ErrorHandlersExecution(Exception e, Handler ... handlers) {
        this.handlers = handlers;
        this.e = e;
    }

    public void handle() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        tt.setPropagationBehavior(3);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                for (Handler errorHandler : ErrorHandlersExecution.this.handlers) {
                    try {
                        errorHandler.handle();
                    }
                    catch (Exception ex) {
                        log.error(ErrorHandlersExecution.this.e.getMessage(), (Throwable)ErrorHandlersExecution.this.e);
                        throw ex;
                    }
                }
            }
        });
        throw new RuntimeException(this.e);
    }

    public static String rootMessage(Exception e) {
        Throwable rootException = ErrorHandlersExecution.rootCause(e);
        return StringUtils.isBlank((CharSequence)rootException.getMessage()) ? "Unknown exception!" : rootException.getMessage();
    }

    private static Throwable rootCause(Throwable exception) {
        Throwable rootException = exception;
        while (rootException.getCause() != null) {
            rootException = rootException.getCause();
        }
        return rootException;
    }
}

