/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Argument;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypedValue;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.SimpleFilter;
import com.suncode.pwfl.workflow.process.IndexType;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.format.FormatConstants;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.context.i18n.LocaleContextHolder;

public class DataConverter {
    public static ListMultimap<String, Object> convertMapListToMultimap(List<Map<String, Object>> listOfMaps) {
        ArrayListMultimap resultsTransformed = ArrayListMultimap.create();
        for (Map<String, Object> row : listOfMaps) {
            for (String key : row.keySet()) {
                resultsTransformed.put((Object)key, row.get(key));
            }
        }
        return resultsTransformed;
    }

    public static List<Map<String, String>> convertLMSOToLMSS(List<Map<String, Object>> originalList) {
        ArrayList<Map<String, String>> resultantList = new ArrayList<Map<String, String>>();
        for (Map<String, Object> map : originalList) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value != null) {
                    Format format;
                    if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                        format = DataConverter.getDecimalFormat();
                        newMap.put(key, format.format(value));
                        continue;
                    }
                    if (value instanceof Integer || value instanceof Long) {
                        format = DataConverter.getIntegerFormat();
                        newMap.put(key, format.format(value));
                        continue;
                    }
                    newMap.put(key, value.toString());
                    continue;
                }
                newMap.put(key, null);
            }
            resultantList.add(newMap);
        }
        return resultantList;
    }

    private static Format getIntegerFormat() {
        DecimalFormat format = DataConverter.getDecimalFormat();
        format.applyPattern("#,##0");
        return format;
    }

    private static DecimalFormat getDecimalFormat() {
        String decimalSeparator = String.valueOf(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DECIMAL_SEPARATOR).charAt(0));
        String thousandSeparator = String.valueOf(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.ACTIVITYFORM_THOUSANDSEPARATOR).charAt(0));
        Locale locale = LocaleContextHolder.getLocale();
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charAt(0));
        decimalFormatSymbols.setGroupingSeparator(thousandSeparator.charAt(0));
        StringBuilder decimalFormat = new StringBuilder();
        decimalFormat.append("#,##0");
        decimalFormat.append(".");
        for (int i = 0; i < FormatConstants.UNLIMITED_DECIMAL_PRECISION; ++i) {
            decimalFormat.append("#");
        }
        return new DecimalFormat(decimalFormat.toString(), decimalFormatSymbols);
    }

    public static Object[] stringsToObjects(String[] toConvert, String[] types) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Object[] parameters = new Object[toConvert.length];
        try {
            for (int j = 0; j < toConvert.length; ++j) {
                parameters[j] = DataConverter.stringToObject(toConvert[j], types[j]);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new ArrayIndexOutOfBoundsException("Liczba parametr\u00f3w nie zgadza si\u0119 z liczb\u0105 ich typ\u00f3w!");
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        return parameters;
    }

    public static Object stringToObject(String toConvert, String type) throws IllegalArgumentException {
        if (type.equals("string")) {
            return toConvert;
        }
        if (type.equals("integer")) {
            return Integer.valueOf(toConvert);
        }
        if (type.equals("float")) {
            return Double.valueOf(toConvert);
        }
        if (type.equals("date")) {
            LocalDate ld = LocalDate.parse((String)toConvert, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            return new Date(ld.toDateTimeAtStartOfDay().getMillis());
        }
        if (type.equals("datetime")) {
            LocalDateTime ldt = LocalDateTime.parse((String)toConvert, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
            return new Date(ldt.toDateTime().getMillis());
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(toConvert);
        }
        throw new IllegalArgumentException("Z\u0142y typ parametru: " + type);
    }

    public static Object dbObjectToPWFLObject(Object toConvert, Type<?> type) throws IllegalArgumentException {
        if (type == Types.BOOLEAN) {
            return (Boolean)toConvert;
        }
        if (type == Types.INTEGER) {
            return ((Number)toConvert).longValue();
        }
        if (type == Types.FLOAT) {
            return ((Number)toConvert).doubleValue();
        }
        if (type == Types.DATE) {
            Date date = null;
            if (toConvert instanceof Timestamp) {
                Timestamp stamp = (Timestamp)toConvert;
                date = new Date(stamp.getTime());
            } else {
                date = (Date)toConvert;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return new LocalDate((Object)df.format(date));
        }
        if (type == Types.DATETIME) {
            Date dateTime = null;
            if (toConvert instanceof Timestamp) {
                Timestamp stamp = (Timestamp)toConvert;
                dateTime = new Date(stamp.getTime());
            } else {
                dateTime = (Date)toConvert;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return LocalDateTime.parse((String)df.format(dateTime), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (type == Types.STRING) {
            return (String)toConvert;
        }
        throw new IllegalArgumentException("Z\u0142y typ parametru: " + String.valueOf(type));
    }

    public static Object[] dbArrayToPWFLArray(Object[] toConvert, Type<?> type) throws IllegalArgumentException {
        return Arrays.stream(toConvert).map(dbValue -> dbValue == null ? null : DataConverter.dbObjectToPWFLObject(dbValue, DataConverter.getSingleType(type))).toArray(size -> {
            if (type == Types.STRING_ARRAY) {
                return new String[size];
            }
            if (type == Types.INTEGER_ARRAY) {
                return new Long[size];
            }
            if (type == Types.FLOAT_ARRAY) {
                return new Double[size];
            }
            if (type == Types.DATE_ARRAY) {
                return new LocalDate[size];
            }
            throw new IllegalArgumentException("Type not recognized!");
        });
    }

    public static List<Map<String, Object>> addConstantColumnsToMapList(List<Map<String, Object>> data, Object[] constants, String[] colIdsForConstants) {
        for (Map<String, Object> row : data) {
            for (int i = 0; i < constants.length; ++i) {
                row.put(colIdsForConstants[i], constants[i]);
            }
        }
        return data;
    }

    public static Object stringToObject(String value, Type<?> type) throws IllegalArgumentException {
        if (type == Types.STRING) {
            return value;
        }
        if (type == Types.BOOLEAN) {
            return StringUtils.isBlank((String)value) ? false : value.toLowerCase().equals("true") || value.equals("1");
        }
        if (type == Types.FLOAT) {
            return StringUtils.isBlank((String)value) ? 0.0 : Double.parseDouble(value);
        }
        if (type == Types.INTEGER) {
            return StringUtils.isBlank((String)value) ? 0L : Long.parseLong(value);
        }
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (type == Types.DATE) {
            return StringUtils.isBlank((String)value) ? null : new LocalDate((Object)value);
        }
        if (type == Types.DATETIME) {
            return StringUtils.isBlank((String)value) ? null : LocalDateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (type == Types.FLOAT_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            Double[] valuesArray = new Double[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = StringUtils.isBlank((String)stringValuesArray[i]) ? 0.0 : Double.parseDouble(stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.INTEGER_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            Long[] valuesArray = new Long[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = StringUtils.isBlank((String)stringValuesArray[i]) ? 0L : Long.parseLong(stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.DATE_ARRAY) {
            String[] stringValuesArray = DataConverter.getStringArray(value);
            LocalDate[] valuesArray = new LocalDate[stringValuesArray.length];
            for (int i = 0; i < stringValuesArray.length; ++i) {
                valuesArray[i] = StringUtils.isBlank((String)stringValuesArray[i]) || stringValuesArray[i].equals("null") ? null : new LocalDate((Object)stringValuesArray[i]);
            }
            return valuesArray;
        }
        if (type == Types.STRING_ARRAY) {
            return DataConverter.getStringArray(value);
        }
        throw new IllegalArgumentException("Unknown type to convert: " + type.name());
    }

    private static String[] getStringArray(String value) {
        return value.equals("") ? new String[]{} : value.split(";", -1);
    }

    public static Object convertObjectFromIndexType(Object toConvert, Type<?> type) {
        return type == Types.INTEGER ? (Long)toConvert : DataConverter.dbObjectToPWFLObject(toConvert, type);
    }

    public static Type<?> stringToType(String typeAsString) {
        if (typeAsString.equals("string")) {
            return Types.STRING;
        }
        if (typeAsString.equals("integer")) {
            return Types.INTEGER;
        }
        if (typeAsString.equals("float")) {
            return Types.FLOAT;
        }
        if (typeAsString.equals("double")) {
            return Types.FLOAT;
        }
        if (typeAsString.equals("date")) {
            return Types.DATE;
        }
        if (typeAsString.equals("datetime")) {
            return Types.DATETIME;
        }
        if (typeAsString.equals("boolean")) {
            return Types.BOOLEAN;
        }
        if (typeAsString.equals("string[]")) {
            return Types.STRING_ARRAY;
        }
        if (typeAsString.equals("integer[]")) {
            return Types.INTEGER_ARRAY;
        }
        if (typeAsString.equals("float[]")) {
            return Types.FLOAT_ARRAY;
        }
        if (typeAsString.equals("double[]")) {
            return Types.FLOAT_ARRAY;
        }
        if (typeAsString.equals("date[]")) {
            return Types.DATE_ARRAY;
        }
        if (typeAsString.equals("datetime[]")) {
            return Types.DATETIME_ARRAY;
        }
        if (typeAsString.equals("boolean[]")) {
            return Types.BOOLEAN_ARRAY;
        }
        if (typeAsString.equals("variable")) {
            return Types.VARIABLE;
        }
        if (typeAsString.equals("variable[]")) {
            return Types.VARIABLE_ARRAY;
        }
        throw new IllegalArgumentException("Z\u0142y typ parametru: " + typeAsString);
    }

    public static Type<?>[] convertStringsToTypes(String[] typesAsStrings) {
        return (Type[])Arrays.stream(typesAsStrings).map(typeAsString -> DataConverter.stringToType(typeAsString)).toArray(Type[]::new);
    }

    public static Type<?>[] getTypesFromVariables(Variable[] variablesParams) {
        ArrayList types = new ArrayList();
        for (Variable variable : variablesParams) {
            types.add(DataConverter.getSingleType(variable.getType()));
        }
        return types.toArray(new Type[types.size()]);
    }

    public static Type<?> getSingleType(Type<?> type) {
        if (type == Types.STRING_ARRAY || type == Types.STRING) {
            return Types.STRING;
        }
        if (type == Types.INTEGER_ARRAY || type == Types.INTEGER) {
            return Types.INTEGER;
        }
        if (type == Types.FLOAT_ARRAY || type == Types.FLOAT) {
            return Types.FLOAT;
        }
        if (type == Types.DATE_ARRAY || type == Types.DATE) {
            return Types.DATE;
        }
        if (type == Types.DATETIME_ARRAY || type == Types.DATETIME) {
            return Types.DATETIME;
        }
        if (type == Types.BOOLEAN_ARRAY || type == Types.BOOLEAN) {
            return Types.BOOLEAN;
        }
        throw new IllegalArgumentException("Uknown variable type: " + String.valueOf(type));
    }

    public static String getStringValueFromArgumentValue(TypedValue<?> typedValue) {
        Variable variable;
        if (typedValue.isInstanceOf((Type)Types.FUNCTION)) {
            FunctionCall function = (FunctionCall)typedValue.get();
            if (function.getReturnType() == Types.STRING_ARRAY) {
                CharSequence[] arrayValue = (String[])function.call();
                return String.join((CharSequence)";", arrayValue);
            }
        } else if (typedValue.isInstanceOf((Type)Types.VARIABLE) && (variable = (Variable)typedValue.get()).getType() == Types.STRING_ARRAY) {
            CharSequence[] arrayValue = (String[])variable.getValue();
            return String.join((CharSequence)";", arrayValue);
        }
        return (String)typedValue.getEvaluatedValue();
    }

    public static Map<String, Object> stringsToContextTypeValues(List<ProcessIndex> variables, String[] variablesToSet, String[] valuesToSet) throws ParseException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < variablesToSet.length; ++i) {
            String variableToSet = variablesToSet[i];
            IndexType type = variables.stream().filter(v -> v.getId().equals(variableToSet)).map(ProcessIndex::getType).findAny().orElse(null);
            String value = type == null ? valuesToSet[i] : DataConverter.stringToContextTypeValue(valuesToSet[i], type);
            values.put(variableToSet, value);
        }
        return values;
    }

    private static Object stringToContextTypeValue(String stringValue, IndexType type) throws ParseException {
        switch (type) {
            case BOOLEAN: {
                return stringValue.toLowerCase().equals("true");
            }
            case DATE: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat.parse(stringValue);
            }
            case DOUBLE: {
                return StringUtils.isBlank((String)stringValue) ? 0.0 : Double.parseDouble(stringValue);
            }
            case INTEGER: {
                return StringUtils.isBlank((String)stringValue) ? 0L : Long.parseLong(stringValue);
            }
            case STRING: {
                return stringValue;
            }
        }
        throw new IllegalArgumentException("Unknown index type!");
    }

    public static Object[] argumentToObjectArray(Argument valuesArgument, Boolean[] isColumnARow, Type<?>[] types) {
        TypedValue[] typedValues = (TypedValue[])valuesArgument.getRaw();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < typedValues.length; ++i) {
            String stringValue = isColumnARow[i] == false ? DataConverter.getStringValueFromArgumentValue(typedValues[i]) : DataConverter.getSingleStringValue(typedValues[i].getEvaluatedValue());
            values.add(DataConverter.stringToObject(stringValue, types[i]));
        }
        return values.toArray(new Object[values.size()]);
    }

    public static String[] argumentToStringArray(Argument valuesArgument) {
        TypedValue[] typedValues = (TypedValue[])valuesArgument.getRaw();
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < typedValues.length; ++i) {
            String stringValue = DataConverter.getStringValueFromArgumentValue(typedValues[i]);
            values.add(stringValue);
        }
        return values.toArray(new String[values.size()]);
    }

    private static String getSingleStringValue(Object value) {
        return value.getClass().isArray() ? ((String[])value)[0] : (String)value;
    }

    public static Object stringToPmidxValue(String value, Type<?> type) {
        if (value == null || value.equals("") && (type == Types.DATE || type == Types.DATETIME)) {
            return null;
        }
        if (type == Types.INTEGER) {
            return Long.parseLong(value);
        }
        if (type == Types.FLOAT) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public static List<SimpleIndexFilter> convertToSimpleIndexFilters(List<SimpleFilter> filters) {
        ArrayList<SimpleIndexFilter> simpleIndexFilters = new ArrayList<SimpleIndexFilter>();
        filters.stream().forEach(filter -> {
            if (filter.getOperator() == FilterOperator.BETWEEN) {
                ArrayList value = (ArrayList)filter.getValue();
                Class<?> type = DataConverter.getFilterType(value.get(0), value.get(1));
                Object firstValue = DataConverter.getFirstFilterValue(value.get(0), type);
                Object secondValue = DataConverter.getSecondFilterValue(value.get(1), type);
                simpleIndexFilters.add(new SimpleIndexFilter(filter.getProperty(), (Object)new Object[]{firstValue, secondValue}, filter.getOperator()));
            } else if (filter.getOperator() == FilterOperator.LIKE) {
                simpleIndexFilters.add(new SimpleIndexFilter(filter.getProperty(), filter.getValue(), FilterOperator.ILIKE));
            }
        });
        return simpleIndexFilters;
    }

    private static Class<?> getFilterType(Object object, Object object2) {
        if (object instanceof java.util.Date || object2 instanceof java.util.Date) {
            return java.util.Date.class;
        }
        if (object instanceof Integer || object2 instanceof Integer) {
            return Integer.class;
        }
        if (object instanceof Double || object2 instanceof Double) {
            return Double.class;
        }
        throw new IllegalArgumentException("Unknown filter type!");
    }

    private static Object getSecondFilterValue(Object value, Class<?> type) {
        if (type == java.util.Date.class) {
            return value == null ? DataConverter.getMaxDate() : value;
        }
        if (type == Integer.class) {
            return value == null ? Integer.valueOf(Integer.MAX_VALUE) : value;
        }
        if (type == Double.class) {
            return value == null ? Double.valueOf(Double.MAX_VALUE) : value;
        }
        throw new IllegalArgumentException("Unknown filter second value!");
    }

    private static java.util.Date getMaxDate() {
        String date = "31-12-3999";
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("B\u0142ad parsowania maksymalnej daty!");
        }
    }

    private static Object getFirstFilterValue(Object value, Class<?> type) {
        if (type == java.util.Date.class) {
            return value == null ? new java.util.Date(0L) : value;
        }
        if (type == Integer.class) {
            return value == null ? Integer.valueOf(Integer.MIN_VALUE) : value;
        }
        if (type == Double.class) {
            return value == null ? Double.valueOf(Double.MIN_VALUE) : value;
        }
        throw new IllegalArgumentException("Unknown filter first value!");
    }
}

