/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user;

import com.suncode.cuf.common.user.UserDataService;
import com.suncode.cuf.common.user.UserFilterType;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.workflow.form.datachooser.declaration.MappingDeclaration;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

public class UserCriteriaCreator {
    private UserDataService uds;
    private TranslatorService translatorService;
    private String usersFilterType;
    private String[] users;
    private String groupsFilterType;
    private String[] groups;
    private String ousFilterType;
    private String[] ous;
    private String rolesFilterType;
    private String[] roles;
    private String query;
    private Map<String, String> filtres;
    private List<MappingDeclaration> mappings;
    private String[] customFilterFields;
    private Boolean isCutomFilter;

    public DetachedCriteria getUserCriteria() {
        DetachedCriteria userDc = DetachedCriteria.forClass(User.class, (String)"User");
        userDc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.setUsersFilter(userDc, this.usersFilterType, this.users);
        this.setGroupsFilter(userDc, this.groupsFilterType, this.groups);
        this.setOusFilter(userDc, this.ousFilterType, this.ous);
        this.setRolesFilter(userDc, this.rolesFilterType, this.roles);
        this.setDataChooserFiltering(userDc);
        this.setDataChooserWindowFiltering(userDc);
        return userDc;
    }

    private void setUsersFilter(DetachedCriteria userDc, String usersFilterType, String[] users) {
        switch (usersFilterType) {
            case "all": {
                break;
            }
            case "users-excluded": {
                userDc.add(Restrictions.not((Criterion)Restrictions.in((String)"userName", (Object[])users)));
                break;
            }
            case "custom": {
                userDc.add(Restrictions.in((String)"userName", (Object[])users));
                break;
            }
            default: {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "unknown-users-filter-type"));
            }
        }
    }

    private void setGroupsFilter(DetachedCriteria userDc, String groupsFilterType, String[] groups) {
        switch (groupsFilterType) {
            case "off": {
                break;
            }
            case "all": {
                Stream.of(groups).forEach(group -> {
                    DetachedCriteria subquery = DetachedCriteria.forClass(UserGroup.class, (String)"group");
                    subquery.add((Criterion)Restrictions.eq((String)"name", (Object)group));
                    subquery.setProjection((Projection)Projections.property((String)"name"));
                    subquery.createAlias("users", "user");
                    subquery.add((Criterion)Restrictions.eqProperty((String)"user.objectId", (String)"User.objectId"));
                    userDc.add(Subqueries.exists((DetachedCriteria)subquery));
                });
                break;
            }
            case "any": {
                userDc.createAlias("groups", "groups");
                userDc.add(Restrictions.in((String)"groups.name", (Object[])groups));
                break;
            }
            case "none": {
                Stream.of(groups).forEach(group -> {
                    DetachedCriteria subquery = DetachedCriteria.forClass(UserGroup.class, (String)"group");
                    subquery.add((Criterion)Restrictions.eq((String)"name", (Object)group));
                    subquery.setProjection((Projection)Projections.property((String)"name"));
                    subquery.createAlias("users", "user");
                    subquery.add((Criterion)Restrictions.eqProperty((String)"user.objectId", (String)"User.objectId"));
                    userDc.add(Subqueries.notExists((DetachedCriteria)subquery));
                });
                break;
            }
            default: {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "unknown-groups-filter-type"));
            }
        }
    }

    private void setOusFilter(DetachedCriteria userDc, String ousFilterType, String[] ous) {
        userDc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        switch (ousFilterType) {
            case "off": {
                break;
            }
            case "all": {
                Stream.of(ous).forEach(ou -> {
                    DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
                    subquery.createAlias("position.organizationalUnit", "ou");
                    subquery.add((Criterion)Restrictions.eq((String)"ou.symbol", (Object)ou));
                    subquery.setProjection((Projection)Projections.property((String)"ou.symbol"));
                    subquery.add((Criterion)Restrictions.eqProperty((String)"user.objectId", (String)"User.objectId"));
                    userDc.add(Subqueries.exists((DetachedCriteria)subquery));
                });
                break;
            }
            case "any": {
                userDc.createAlias("positions", "position");
                userDc.createAlias("position.organizationalUnit", "ou");
                userDc.add(Restrictions.in((String)"ou.symbol", (Object[])ous));
                break;
            }
            case "none": {
                Stream.of(ous).forEach(ou -> {
                    DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
                    subquery.createAlias("position.organizationalUnit", "ou");
                    subquery.add((Criterion)Restrictions.eq((String)"ou.symbol", (Object)ou));
                    subquery.setProjection((Projection)Projections.property((String)"ou.symbol"));
                    subquery.add((Criterion)Restrictions.eqProperty((String)"user.objectId", (String)"User.objectId"));
                    userDc.add(Subqueries.notExists((DetachedCriteria)subquery));
                });
                break;
            }
            default: {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "unknown-ous-filter-type"));
            }
        }
    }

    private void setRolesFilter(DetachedCriteria userDc, String rolesFilterType, String[] roles) {
        if (rolesFilterType.equals("off")) {
            return;
        }
        List<RoleFilter> roleFilters = this.uds.decodeRoleFilters(roles);
        switch (rolesFilterType) {
            case "all": {
                roleFilters.stream().forEach(roleFilter -> {
                    DetachedCriteria subquery = this.createPositionANDSubQuery((RoleFilter)roleFilter);
                    userDc.add(Subqueries.exists((DetachedCriteria)subquery));
                });
                break;
            }
            case "any": {
                userDc.createCriteria("positions");
                userDc.createAlias("positions.roles", "roles");
                Disjunction or = Restrictions.disjunction();
                for (RoleFilter roleFilter2 : roleFilters) {
                    Conjunction and = Restrictions.conjunction();
                    if (CollectionUtils.isNotEmpty((Collection)roleFilter2.getRoleIds())) {
                        and.add(Restrictions.in((String)"roles.roleId", (Collection)roleFilter2.getRoleIds()));
                    }
                    if (StringUtils.isNotBlank((String)roleFilter2.getPackageId())) {
                        and.add((Criterion)Restrictions.eq((String)"roles.packageId", (Object)roleFilter2.getPackageId()));
                    }
                    if (StringUtils.isNotBlank((String)roleFilter2.getProcessDefId()) && !roleFilter2.getProcessDefId().equals("null")) {
                        and.add((Criterion)Restrictions.eq((String)"roles.processDefId", (Object)roleFilter2.getProcessDefId()));
                    } else {
                        and.add(Restrictions.isNull((String)"roles.processDefId"));
                    }
                    or.add((Criterion)and);
                }
                userDc.add((Criterion)or);
                break;
            }
            case "none": {
                roleFilters.stream().forEach(roleFilter -> {
                    DetachedCriteria subquery = this.createPositionANDSubQuery((RoleFilter)roleFilter);
                    userDc.add(Subqueries.notExists((DetachedCriteria)subquery));
                });
                break;
            }
            default: {
                throw new IllegalArgumentException(this.translatorService.translate("dc.userchooser.errors.", "unknown-roles-filter-type"));
            }
        }
    }

    private DetachedCriteria createPositionANDSubQuery(RoleFilter roleFilter) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.createAlias("position.roles", "role");
        subquery.add((Criterion)Restrictions.eq((String)"role.packageId", (Object)roleFilter.getPackageId()));
        if (StringUtils.isNotBlank((String)roleFilter.getProcessDefId()) && !roleFilter.getProcessDefId().equals("null")) {
            subquery.add((Criterion)Restrictions.eq((String)"role.processDefId", (Object)roleFilter.getProcessDefId()));
        } else {
            subquery.add(Restrictions.isNull((String)"role.processDefId"));
        }
        subquery.add(Restrictions.in((String)"role.roleId", (Collection)roleFilter.getRoleIds()));
        subquery.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"role.packageId")).add((Projection)Projections.property((String)"role.processDefId")).add((Projection)Projections.property((String)"role.roleId")));
        subquery.add((Criterion)Restrictions.eqProperty((String)"user.objectId", (String)"User.objectId"));
        return subquery;
    }

    private void setDataChooserWindowFiltering(DetachedCriteria userDc) {
        if (this.filtres.isEmpty()) {
            return;
        }
        Disjunction or = Restrictions.disjunction();
        this.filtres.entrySet().stream().filter(entry -> UserFilterType.contains((String)entry.getKey())).forEach(entry -> or.add(this.getCustomMapping((String)entry.getKey(), (String)entry.getValue())));
        userDc.add((Criterion)or);
    }

    private void setDataChooserFiltering(DetachedCriteria userDc) {
        if (StringUtils.isEmpty((String)this.query)) {
            return;
        }
        Disjunction or = Restrictions.disjunction();
        if (this.isCutomFilter.booleanValue()) {
            Arrays.asList(this.customFilterFields).stream().filter(customFilter -> UserFilterType.contains(customFilter)).forEach(customFilter -> or.add(this.getCustomMapping((String)customFilter, this.query)));
        } else {
            this.mappings.stream().filter(mapping -> UserFilterType.contains(mapping.getId())).forEach(mapping -> or.add(this.getCustomMapping(mapping.getId(), this.query)));
        }
        userDc.add((Criterion)or);
    }

    private Criterion getCustomMapping(String customFilter, String filterValue) {
        switch (UserFilterType.getEnum(customFilter)) {
            case FULLNAME: {
                return this.createCriterionByFullNames(filterValue);
            }
            case OUS: {
                return this.createCriterionByOusName(filterValue);
            }
            case OUS_SYMBOLS: {
                return this.createCriterionByOusSymbol(filterValue);
            }
            case GROUPS: {
                return this.createCriterionByGroupsName(filterValue);
            }
            case POSITIONS: {
                return this.createCriterionByPostionsName(filterValue);
            }
            case POSITIONS_SYMBOLS: {
                return this.createCriterionByPositnionsSymbol(filterValue);
            }
            case SUPERIORS: {
                return this.createCriterionByOusSuperiors(filterValue);
            }
            case EMAIL: 
            case FIRSTNAME: 
            case LASTNAME: 
            case USERNAME: {
                return Restrictions.ilike((String)customFilter, (Object)("%" + filterValue + "%"));
            }
        }
        throw new IllegalArgumentException("Not supported filter: " + filterValue);
    }

    private Criterion createCriterionByFullNames(String filterValue) {
        String[] splitFullName = filterValue.trim().split(" ");
        if (splitFullName.length == 1) {
            return Restrictions.disjunction().add(Restrictions.ilike((String)"firstName", (Object)("%" + splitFullName[0] + "%"))).add(Restrictions.ilike((String)"lastName", (Object)("%" + splitFullName[0] + "%")));
        }
        Conjunction and = Restrictions.conjunction();
        Disjunction or = Restrictions.disjunction();
        and.add(Restrictions.ilike((String)"firstName", (Object)("%" + splitFullName[0] + "%")));
        for (int i = 1; i < splitFullName.length; ++i) {
            or.add(Restrictions.ilike((String)"lastName", (Object)("%" + splitFullName[i] + "%")));
        }
        and.add((Criterion)or);
        return and;
    }

    private Criterion createCriterionByOusSuperiors(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.createAlias("position.user", "posUser");
        subquery.createAlias("position.higherPosition", "higherPosition");
        subquery.createAlias("higherPosition.user", "higherPositionUser");
        subquery.add(Restrictions.ilike((String)"higherPositionUser.userName", (Object)("%" + filterValue + "%")));
        subquery.setProjection((Projection)Projections.property((String)"posUser.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private Criterion createCriterionByPositnionsSymbol(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.add(Restrictions.ilike((String)"symbol", (Object)("%" + filterValue + "%")));
        subquery.createAlias("position.user", "posUser");
        subquery.setProjection((Projection)Projections.property((String)"posUser.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private Criterion createCriterionByPostionsName(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.add(Restrictions.ilike((String)"name", (Object)("%" + filterValue + "%")));
        subquery.createAlias("position.user", "posUser");
        subquery.setProjection((Projection)Projections.property((String)"posUser.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private Criterion createCriterionByGroupsName(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(UserGroup.class, (String)"group");
        subquery.add(Restrictions.ilike((String)"name", (Object)("%" + filterValue + "%")));
        subquery.createAlias("group.users", "groupUsers");
        subquery.setProjection((Projection)Projections.property((String)"groupUsers.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private Criterion createCriterionByOusName(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.createAlias("position.organizationalUnit", "ou");
        subquery.createAlias("position.user", "posUser");
        subquery.add(Restrictions.ilike((String)"ou.name", (Object)("%" + filterValue + "%")));
        subquery.setProjection((Projection)Projections.property((String)"posUser.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private Criterion createCriterionByOusSymbol(String filterValue) {
        DetachedCriteria subquery = DetachedCriteria.forClass(Position.class, (String)"position");
        subquery.createAlias("position.organizationalUnit", "ou");
        subquery.createAlias("position.user", "posUser");
        subquery.add(Restrictions.ilike((String)"ou.symbol", (Object)("%" + filterValue + "%")));
        subquery.setProjection((Projection)Projections.property((String)"posUser.objectId"));
        return Subqueries.propertyIn((String)"User.objectId", (DetachedCriteria)subquery);
    }

    private static Map<String, String> $default$filtres() {
        return new HashMap<String, String>();
    }

    private static List<MappingDeclaration> $default$mappings() {
        return new ArrayList<MappingDeclaration>();
    }

    @ConstructorProperties(value={"uds", "translatorService", "usersFilterType", "users", "groupsFilterType", "groups", "ousFilterType", "ous", "rolesFilterType", "roles", "query", "filtres", "mappings", "customFilterFields", "isCutomFilter"})
    UserCriteriaCreator(UserDataService uds, TranslatorService translatorService, String usersFilterType, String[] users, String groupsFilterType, String[] groups, String ousFilterType, String[] ous, String rolesFilterType, String[] roles, String query, Map<String, String> filtres, List<MappingDeclaration> mappings, String[] customFilterFields, Boolean isCutomFilter) {
        this.uds = uds;
        this.translatorService = translatorService;
        this.usersFilterType = usersFilterType;
        this.users = users;
        this.groupsFilterType = groupsFilterType;
        this.groups = groups;
        this.ousFilterType = ousFilterType;
        this.ous = ous;
        this.rolesFilterType = rolesFilterType;
        this.roles = roles;
        this.query = query;
        this.filtres = filtres;
        this.mappings = mappings;
        this.customFilterFields = customFilterFields;
        this.isCutomFilter = isCutomFilter;
    }

    public static UserCriteriaCreatorBuilder builder() {
        return new UserCriteriaCreatorBuilder();
    }

    public static class UserCriteriaCreatorBuilder {
        private UserDataService uds;
        private TranslatorService translatorService;
        private String usersFilterType;
        private String[] users;
        private String groupsFilterType;
        private String[] groups;
        private String ousFilterType;
        private String[] ous;
        private String rolesFilterType;
        private String[] roles;
        private String query;
        private boolean filtres$set;
        private Map<String, String> filtres$value;
        private boolean mappings$set;
        private List<MappingDeclaration> mappings$value;
        private String[] customFilterFields;
        private Boolean isCutomFilter;

        UserCriteriaCreatorBuilder() {
        }

        public UserCriteriaCreatorBuilder uds(UserDataService uds) {
            this.uds = uds;
            return this;
        }

        public UserCriteriaCreatorBuilder translatorService(TranslatorService translatorService) {
            this.translatorService = translatorService;
            return this;
        }

        public UserCriteriaCreatorBuilder usersFilterType(String usersFilterType) {
            this.usersFilterType = usersFilterType;
            return this;
        }

        public UserCriteriaCreatorBuilder users(String[] users) {
            this.users = users;
            return this;
        }

        public UserCriteriaCreatorBuilder groupsFilterType(String groupsFilterType) {
            this.groupsFilterType = groupsFilterType;
            return this;
        }

        public UserCriteriaCreatorBuilder groups(String[] groups) {
            this.groups = groups;
            return this;
        }

        public UserCriteriaCreatorBuilder ousFilterType(String ousFilterType) {
            this.ousFilterType = ousFilterType;
            return this;
        }

        public UserCriteriaCreatorBuilder ous(String[] ous) {
            this.ous = ous;
            return this;
        }

        public UserCriteriaCreatorBuilder rolesFilterType(String rolesFilterType) {
            this.rolesFilterType = rolesFilterType;
            return this;
        }

        public UserCriteriaCreatorBuilder roles(String[] roles) {
            this.roles = roles;
            return this;
        }

        public UserCriteriaCreatorBuilder query(String query) {
            this.query = query;
            return this;
        }

        public UserCriteriaCreatorBuilder filtres(Map<String, String> filtres) {
            this.filtres$value = filtres;
            this.filtres$set = true;
            return this;
        }

        public UserCriteriaCreatorBuilder mappings(List<MappingDeclaration> mappings) {
            this.mappings$value = mappings;
            this.mappings$set = true;
            return this;
        }

        public UserCriteriaCreatorBuilder customFilterFields(String[] customFilterFields) {
            this.customFilterFields = customFilterFields;
            return this;
        }

        public UserCriteriaCreatorBuilder isCutomFilter(Boolean isCutomFilter) {
            this.isCutomFilter = isCutomFilter;
            return this;
        }

        public UserCriteriaCreator build() {
            Map<String, String> filtres$value = this.filtres$value;
            if (!this.filtres$set) {
                filtres$value = UserCriteriaCreator.$default$filtres();
            }
            List<MappingDeclaration> mappings$value = this.mappings$value;
            if (!this.mappings$set) {
                mappings$value = UserCriteriaCreator.$default$mappings();
            }
            return new UserCriteriaCreator(this.uds, this.translatorService, this.usersFilterType, this.users, this.groupsFilterType, this.groups, this.ousFilterType, this.ous, this.rolesFilterType, this.roles, this.query, filtres$value, mappings$value, this.customFilterFields, this.isCutomFilter);
        }

        public String toString() {
            return "UserCriteriaCreator.UserCriteriaCreatorBuilder(uds=" + String.valueOf(this.uds) + ", translatorService=" + String.valueOf(this.translatorService) + ", usersFilterType=" + this.usersFilterType + ", users=" + Arrays.deepToString(this.users) + ", groupsFilterType=" + this.groupsFilterType + ", groups=" + Arrays.deepToString(this.groups) + ", ousFilterType=" + this.ousFilterType + ", ous=" + Arrays.deepToString(this.ous) + ", rolesFilterType=" + this.rolesFilterType + ", roles=" + Arrays.deepToString(this.roles) + ", query=" + this.query + ", filtres$value=" + String.valueOf(this.filtres$value) + ", mappings$value=" + String.valueOf(this.mappings$value) + ", customFilterFields=" + Arrays.deepToString(this.customFilterFields) + ", isCutomFilter=" + this.isCutomFilter + ")";
        }
    }
}

