/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.servlets;

import com.suncode.cuf.common.general.service.DateFunctionsServiceImpl;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dateFunctions"})
public class DateFunctionsController {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    @Autowired
    private DateFunctionsServiceImpl dateFunctionsService;

    @ResponseBody
    @RequestMapping(value={"/calculateDaysDifference"}, method={RequestMethod.GET})
    public int calculateDaysDifference(@RequestParam String firstDate, @RequestParam String secondDate, @RequestParam Boolean includeFreeDays) {
        LocalDate first = LocalDate.parse((String)firstDate, (DateTimeFormatter)DATE_FORMATTER);
        LocalDate second = LocalDate.parse((String)secondDate, (DateTimeFormatter)DATE_FORMATTER);
        return this.dateFunctionsService.calculateDaysDifference(first, second, includeFreeDays);
    }

    @ResponseBody
    @RequestMapping(value={"/calculateTimeDifference"}, method={RequestMethod.GET})
    public int calculateTimeDifference(@RequestParam String firstDate, @RequestParam String secondDate, @RequestParam Boolean includeFreeDays, @RequestParam Boolean timeShift, @RequestParam String returnType) {
        LocalDateTime first = LocalDateTime.parse((String)firstDate, (DateTimeFormatter)DATETIME_FORMATTER);
        LocalDateTime second = LocalDateTime.parse((String)secondDate, (DateTimeFormatter)DATETIME_FORMATTER);
        return this.dateFunctionsService.calculateTimeDifference(first, second, includeFreeDays, timeShift, returnType);
    }

    @ResponseBody
    @RequestMapping(value={"/calcDateWorkingDays"}, method={RequestMethod.GET})
    public String calcDateWorkingDays(@RequestParam String date, @RequestParam int workingDays, @RequestParam(defaultValue="false") boolean isDateTime) {
        if (isDateTime) {
            LocalDateTime dateTime = LocalDateTime.parse((String)date, (DateTimeFormatter)DATETIME_FORMATTER);
            LocalDateTime result = this.dateFunctionsService.calcDateWorkingDays(dateTime, workingDays);
            return result.toString(DATETIME_FORMATTER);
        }
        LocalDate localDate = LocalDate.parse((String)date, (DateTimeFormatter)DATE_FORMATTER);
        LocalDate result = this.dateFunctionsService.calcDateWorkingDays(localDate, workingDays);
        return result.toString(DATE_FORMATTER);
    }

    @ResponseBody
    @RequestMapping(value={"/nextWorkingDay"}, method={RequestMethod.GET})
    public String nextWorkingDay(@RequestParam String date, @RequestParam(defaultValue="false") boolean isDateTime) {
        if (isDateTime) {
            LocalDateTime dateTime = LocalDateTime.parse((String)date, (DateTimeFormatter)DATETIME_FORMATTER);
            LocalDateTime result = this.dateFunctionsService.nextWorkingDay(dateTime);
            return result.toString(DATETIME_FORMATTER);
        }
        LocalDate localDate = LocalDate.parse((String)date, (DateTimeFormatter)DATE_FORMATTER);
        LocalDate result = this.dateFunctionsService.nextWorkingDay(localDate);
        return result.toString(DATE_FORMATTER);
    }

    @ResponseBody
    @RequestMapping(value={"/previousWorkingDay"}, method={RequestMethod.GET})
    public String previousWorkingDay(@RequestParam String date, @RequestParam(defaultValue="false") boolean isDateTime) {
        if (isDateTime) {
            LocalDateTime dateTime = LocalDateTime.parse((String)date, (DateTimeFormatter)DATETIME_FORMATTER);
            LocalDateTime result = this.dateFunctionsService.previousWorkingDay(dateTime);
            return result.toString(DATETIME_FORMATTER);
        }
        LocalDate localDate = LocalDate.parse((String)date, (DateTimeFormatter)DATE_FORMATTER);
        LocalDate result = this.dateFunctionsService.previousWorkingDay(localDate);
        return result.toString(DATE_FORMATTER);
    }
}

