/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.ObjectComparator;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@Functions
@FunctionsScript(value="/functions/array-functions.js")
public class ArrayFunctions {
    @Function
    public String[] filter(String[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<String> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new String[resultList.size()]);
    }

    @Function
    public Long[] filter(Long[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<Long> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new Long[resultList.size()]);
    }

    @Function
    public Double[] filter(Double[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<Double> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new Double[resultList.size()]);
    }

    @Function
    public LocalDate[] filter(LocalDate[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<LocalDate> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new LocalDate[resultList.size()]);
    }

    @Function
    public LocalDateTime[] filter(LocalDateTime[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<LocalDateTime> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new LocalDateTime[resultList.size()]);
    }

    @Function
    public Boolean[] filter(Boolean[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        List<Boolean> resultList = this.getFilteredList(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
        return resultList.toArray(new Boolean[resultList.size()]);
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public int getSelectedRowNo(String tableId) {
        return -1;
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public int getSelectedRowIndex(String tableId) {
        return -1;
    }

    private <T> List<T> getFilteredList(T[] array, Variable[] singleFilterColumns, String[] singleComparator, String[] singleValues, Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues) {
        boolean[] rowsToFilterOut = this.filterColumnWithSingleValue(singleFilterColumns, singleComparator, singleValues, array.length);
        rowsToFilterOut = this.filterColumnWithMultipleValues(multiFilterColumns, multiComparator, multipleValues, rowsToFilterOut);
        ArrayList<T> resultList = new ArrayList<T>();
        for (int i = 0; i < array.length; ++i) {
            if (rowsToFilterOut[i]) continue;
            resultList.add(array[i]);
        }
        return resultList;
    }

    private boolean[] filterColumnWithMultipleValues(Variable[] multiFilterColumns, String[] multiComparator, Variable[] multipleValues, boolean[] rowsToFilterOut) {
        if (multiFilterColumns == null) {
            return rowsToFilterOut;
        }
        for (int i = 0; i < multiFilterColumns.length; ++i) {
            if (multiFilterColumns[i].getType() != multipleValues[i].getType()) {
                throw new IllegalArgumentException("Columns in " + i + " row of function filter aren't the same type!");
            }
            for (int rowNumber = 0; rowNumber < rowsToFilterOut.length; ++rowNumber) {
                if (ObjectComparator.compareObjects(((Object[])multiFilterColumns[i].getValue())[rowNumber], multiComparator[i], ((Object[])multipleValues[i].getValue())[rowNumber], DataConverter.getSingleType(multiFilterColumns[i].getType()))) continue;
                rowsToFilterOut[rowNumber] = true;
            }
        }
        return rowsToFilterOut;
    }

    private boolean[] filterColumnWithSingleValue(Variable[] singleFilterColumns, String[] singleComparator, String[] singleValue, int length) {
        boolean[] rowsToFilterOut = new boolean[length];
        if (singleFilterColumns == null) {
            return rowsToFilterOut;
        }
        for (int i = 0; i < singleFilterColumns.length; ++i) {
            Type<?> valueType = DataConverter.getSingleType(singleFilterColumns[i].getType());
            Object singleFilterValue = DataConverter.stringToObject(singleValue[i], valueType);
            for (int rowNumber = 0; rowNumber < length; ++rowNumber) {
                Object valueFromVariable = ((Object[])singleFilterColumns[i].getValue())[rowNumber];
                if (ObjectComparator.compareObjects(valueFromVariable, singleComparator[i], singleFilterValue, valueType)) continue;
                rowsToFilterOut[rowNumber] = true;
            }
        }
        return rowsToFilterOut;
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public String[] combineArrays(String[] array1, String[] array2) {
        int maxLength = Math.max(array1.length, array2.length);
        String[] result = new String[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            result[i] = i < array1.length && i < array2.length ? array1[i] + array2[i] : (i < array1.length ? array1[i] : array2[i]);
        }
        return result;
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(String[] array, String value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(String[] array, String value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Long[] array, Long value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Long[] array, Long value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Double[] array, Double value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Double[] array, Double value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(LocalDate[] array, LocalDate value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(LocalDate[] array, LocalDate value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(LocalDateTime[] array, LocalDateTime value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(LocalDateTime[] array, LocalDateTime value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Boolean[] array, Boolean value) {
        return this.findIndexInArray(array, value, 0);
    }

    @Function(accessibility=Function.FunctionAccessibility.ALL)
    public int findIndex(Boolean[] array, Boolean value, int start) {
        return this.findIndexInArray(array, value, start);
    }

    private <T> int findIndexInArray(T[] array, T value, int start) {
        if (ArrayUtils.isEmpty((Object[])array) || start < 0 || start >= array.length) {
            return -1;
        }
        for (int i = start; i < array.length; ++i) {
            if (!Objects.equals(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public String getSelectedColumnId(String tableId) {
        return null;
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public String getSelectedCellValue(String tableId) {
        return null;
    }
}

