/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.general.ProcessService;
import com.suncode.cuf.common.general.enums.AddCommentType;
import com.suncode.cuf.common.general.schemas.Activity;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionCallbackWithoutResult;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.annotation.Deprecated;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.enhydra.shark.api.SharkTransaction;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

@Application
@Deprecated
public class UpdateProcesses {
    private static final Logger log = LoggerFactory.getLogger(UpdateProcesses.class);
    private static final String TRANSLATE_APP_PATH = "app.update-processes.";
    private static final String ARCHIVE_ACTIVITY_MODIFICATION_COMMENT_KEY = "archive-activity-modification-comment-template";
    private static final String ARCHIVE_ACTIVITIES_MODIFICATION_COMMENT_KEY = "archive-activities-modification-comment-template";
    @Autowired
    private TranslatorService translator;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private VariableFactory variableFactory;
    @Autowired
    private CUFCommonDocumentService documentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("update-processes")).name("app.update-processes.name")).description("app.update-processes.desc")).category(new Category[]{Categories.GENERAL})).icon((Icon)SilkIconPack.APPLICATION_EDIT)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}process-updates-application")).parameter().id("appType").name("app.update-processes.app-type.name").description("app.update-processes.app-type.desc").type((Type)Types.STRING).create()).parameter().id("processDefId").name("app.update-processes.process-id.name").description("app.update-processes.process-id.desc").type((Type)Types.STRING).create()).parameter().id("activityId").name("app.update-processes.activity-id.name").description("app.update-processes.activity-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("acceptButtonId").name("app.update-processes.accept-button-id.name").description("app.update-processes.accept-button-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("manyProcesses").name("app.update-processes.many-processes.name").description("app.update-processes.many-processes.desc").type((Type)Types.BOOLEAN).create()).parameter().id("updateVariables").name("app.update-processes.update-variables.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("variablesToFilter").name("app.update-processes.variables-to-filter.name").description("app.update-processes.variables-to-filter.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("valuesToFilter").name("app.update-processes.values-to-filter.name").description("app.update-processes.values-to-filter.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("variablesToSet").name("app.update-processes.variables-to-set.name").description("app.update-processes.variables-to-set.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("valuesToSet").name("app.update-processes.values-to-set.name").description("app.update-processes.values-to-set.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("addComment").name("app.update-processes.add-comment.name").description("app.update-processes.add-comment.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)Boolean.FALSE).create()).parameter().id("commentValue").name("app.update-processes.comment-value.name").description("app.update-processes.comment-value.desc").type((Type)Types.STRING).optional().create()).parameter().id("includeClosedActivities").name("app.update-processes.include-closed-activities.name").description("app.update-processes.include-closed-activities.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("commentType").name("app.update-processes.comment-type.name").description("app.update-processes.comment-type.desc").type((Type)Types.STRING).defaultValue((Object)AddCommentType.SINGULAR.name()).optional().create();
    }

    public void execute(final ApplicationContext context, final @Param String appType, final @Param String processDefId, final @Param(value="activityId") String activityDefId, final @Param String acceptButtonId, final @Param(value="manyProcesses") Boolean allowManyProcesses, final @Param Boolean updateVariables, final @Param String[] variablesToFilter, final @Param String[] valuesToFilter, final @Param String[] variablesToSet, final @Param String[] valuesToSet, final @Param Boolean addComment, final @Param String commentValue, final @Param Boolean includeClosedActivities, final @Param String commentType) throws Exception {
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        tx.execute((SharkTransactionCallback)new SharkTransactionCallbackWithoutResult(){

            public void doInSharkTransactionWithoutResult(SharkTransaction transaction, TransactionStatus status) throws Exception {
                log.info("Update process app ( processId: " + context.getProcessId() + " is running with following parameters: ");
                log.info("appType: " + appType);
                log.info("processDefId: " + processDefId);
                log.info("activityDefId: " + activityDefId);
                log.info("acceptButtonId: " + acceptButtonId);
                log.info("allowManyProcesses: " + allowManyProcesses);
                log.info("updateVariables: " + updateVariables);
                log.info("variablesToFilter: " + Arrays.toString(variablesToFilter));
                log.info("valuesToFilter: " + Arrays.toString(valuesToFilter));
                log.info("variablesToSet: " + Arrays.toString(variablesToSet));
                log.info("valuesToSet: " + Arrays.toString(valuesToSet));
                log.info("addComment: " + addComment);
                log.info("commentValue: " + commentValue);
                log.info("includeClosedActivities: " + includeClosedActivities);
                log.info("commentType: " + commentType);
                AddCommentType addCommentType = AddCommentType.valueOf(commentType);
                List<String> processesIds = UpdateProcesses.this.processService.getProcessesIds(processDefId, variablesToFilter, valuesToFilter);
                if (appType.equals("UPDATE_ALL_ACTIVITIES_WITH_PROCESS")) {
                    if (processesIds.size() > 1 && Boolean.TRUE.equals(allowManyProcesses == false)) {
                        throw new IllegalArgumentException(UpdateProcesses.this.translator.translate(UpdateProcesses.TRANSLATE_APP_PATH, "error.many-processes"));
                    }
                    List<ProcessIndex> variables = UpdateProcesses.this.processService.getProcessIndexes(processDefId);
                    for (String processId2 : processesIds) {
                        Map<String, Object> context2 = UpdateProcesses.this.processService.getProcessContext(processId2);
                        List<Activity> updatedActivities = UpdateProcesses.this.updateActivities(processId2, variablesToSet, valuesToSet, includeClosedActivities, addCommentType);
                        UpdateProcesses.this.updateContext(context2, variables, variablesToSet, valuesToSet);
                        UpdateProcesses.this.processService.setProcessContext(processId2, context2);
                        UpdateProcesses.this.updateDocuments(processId2, null);
                        if (!Boolean.TRUE.equals(addComment)) continue;
                        if (addCommentType.equals((Object)AddCommentType.SINGULAR)) {
                            updatedActivities.forEach(activity -> UpdateProcesses.this.addCommentToActivity(activity.getActivityId(), activity.getProcessId(), commentValue));
                            continue;
                        }
                        updatedActivities.stream().filter(Activity::isOpen).forEach(activity -> UpdateProcesses.this.addCommentToActivity(activity.getActivityId(), activity.getProcessId(), commentValue));
                        List closedActivities = updatedActivities.stream().filter(activity -> !activity.isOpen()).collect(Collectors.toList());
                        if (closedActivities.isEmpty()) continue;
                        Activity lastClosedActivity = (Activity)closedActivities.get(closedActivities.size() - 1);
                        UpdateProcesses.this.addCommentToActivity(lastClosedActivity.getActivityId(), lastClosedActivity.getProcessId(), commentValue);
                    }
                } else {
                    Map<String, List<Activity>> processActivitiesMap = UpdateProcesses.this.fetchActivities(processesIds, activityDefId, includeClosedActivities);
                    if (processActivitiesMap.size() > 1 && Boolean.TRUE.equals(allowManyProcesses == false)) {
                        throw new IllegalArgumentException(UpdateProcesses.this.translator.translate(UpdateProcesses.TRANSLATE_APP_PATH, "error.many-processes"));
                    }
                    processActivitiesMap.forEach((processId, activities) -> UpdateProcesses.this.updateActivitiesAndProcess((List<Activity>)activities, updateVariables, appType, variablesToSet, valuesToSet, acceptButtonId, addComment, commentValue, addCommentType));
                }
                log.info("Processes update complete");
            }
        });
    }

    private void updateActivitiesAndProcess(List<Activity> activities, Boolean updateVariables, String appType, String[] variablesToSet, String[] valuesToSet, String acceptButtonId, Boolean addComment, String commentValue, AddCommentType addCommentType) {
        if (activities.isEmpty()) {
            return;
        }
        ArrayList collectiveCommentActivities = new ArrayList();
        ArrayList<Activity> closedActivities = new ArrayList<Activity>();
        boolean updateProcessContext = true;
        boolean updateVariablesInProcess = Boolean.TRUE.equals(updateVariables);
        for (Activity activity2 : activities) {
            if (updateVariablesInProcess) {
                if (!activity2.isOpen()) {
                    closedActivities.add(activity2);
                    this.addArchiveDataModificationComment(addCommentType, activity2, collectiveCommentActivities::add);
                }
                if (!activity2.getContext().isEmpty()) {
                    Map<String, Object> updatedContext = this.getUpdatedContext(activity2, variablesToSet, valuesToSet);
                    this.activityService.setActivityContext(activity2.getProcessId(), activity2.getActivityId(), updatedContext);
                    this.updateDocuments(activity2.getProcessId(), activity2.getActivityId());
                }
            }
            if (appType.equals("ACCEPT_ACTIVITY")) {
                if (activity2.isOpen()) {
                    this.activityService.acceptActivity(new AcceptationDefinition(activity2.getProcessId(), activity2.getActivityId(), "admin", acceptButtonId, activity2.getContext(), true));
                    updateProcessContext = false;
                }
            } else if (appType.equals("CANCEL_PROCESS")) {
                this.activityService.abort(activity2.getProcessId(), activity2.getActivityId());
            } else if (!appType.equals("UPDATE_PROCESS")) {
                throw new IllegalArgumentException(this.translator.translate(TRANSLATE_APP_PATH, "error.incorrect-app-type") + " " + appType);
            }
            if (!Boolean.TRUE.equals(addComment) || !activity2.isOpen()) continue;
            this.addCommentToActivity(activity2.getActivityId(), activity2.getProcessId(), commentValue);
        }
        Activity lastActivity = activities.get(activities.size() - 1);
        if (updateProcessContext) {
            this.processService.setProcessContext(lastActivity.getProcessId(), lastActivity.getContext());
            this.updateDocuments(lastActivity.getProcessId(), null);
        }
        if (!collectiveCommentActivities.isEmpty()) {
            String comment = String.format(this.translator.translate(TRANSLATE_APP_PATH, ARCHIVE_ACTIVITIES_MODIFICATION_COMMENT_KEY), LocalDateTime.now(), collectiveCommentActivities);
            this.addCommentToActivity(lastActivity.getActivityId(), lastActivity.getProcessId(), comment);
        }
        if (Boolean.TRUE.equals(addComment)) {
            if (addCommentType.equals((Object)AddCommentType.SINGULAR)) {
                closedActivities.forEach(activity -> this.addCommentToActivity(activity.getActivityId(), activity.getProcessId(), commentValue));
            } else {
                Activity lastClosedActivity = (Activity)closedActivities.get(closedActivities.size() - 1);
                this.addCommentToActivity(lastClosedActivity.getActivityId(), lastClosedActivity.getProcessId(), commentValue);
            }
        }
    }

    private Map<String, List<Activity>> fetchActivities(List<String> processesIds, String activityDefId, boolean includeClosedActivities) {
        return processesIds.stream().map(processId -> {
            List activities = this.processService.getActivities((String)processId, includeClosedActivities).stream().filter(activity -> activity.getActivityDefId().equals(activityDefId)).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry((String)processId, activities);
        }).filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (activities, activities2) -> {
            LinkedList result = new LinkedList(activities);
            result.addAll(activities2);
            return result;
        }));
    }

    private List<Activity> updateActivities(String processId, String[] variablesToSet, String[] valuesToSet, Boolean includeClosedActivities, AddCommentType addCommentType) {
        List<Activity> processActivities = this.processService.getActivities(processId, includeClosedActivities);
        ArrayList collectiveCommentActivities = new ArrayList();
        ArrayList<Activity> updatedActivities = new ArrayList<Activity>();
        processActivities.forEach(processActivity -> {
            if (!processActivity.isOpen()) {
                this.addArchiveDataModificationComment(addCommentType, (Activity)processActivity, collectiveCommentActivities::add);
            }
            if (!processActivity.getContext().isEmpty()) {
                Map<String, Object> newActivityContext = this.getUpdatedContext((Activity)processActivity, variablesToSet, valuesToSet);
                this.activityService.setActivityContext(processActivity.getProcessId(), processActivity.getActivityId(), newActivityContext);
                this.updateDocuments(processId, processActivity.getActivityId());
                updatedActivities.add((Activity)processActivity);
            }
        });
        if (!collectiveCommentActivities.isEmpty()) {
            Activity lastActivity = processActivities.get(processActivities.size() - 1);
            String comment = String.format(this.translator.translate(TRANSLATE_APP_PATH, ARCHIVE_ACTIVITIES_MODIFICATION_COMMENT_KEY), LocalDateTime.now(), collectiveCommentActivities);
            this.addCommentToActivity(lastActivity.getActivityId(), lastActivity.getProcessId(), comment);
        }
        return updatedActivities;
    }

    private void updateDocuments(String processId, String activityId) {
        List<WfDocument> documents = this.documentService.getDocumentsFromProcess(processId);
        for (WfDocument document : documents) {
            this.documentClassActionService.executeProcessActions(document, DocumentEventTypes.CHANGE_PROCESS_DATA, processId, activityId);
        }
    }

    private Map<String, Object> updateContext(Map<String, Object> context, List<ProcessIndex> variables, String[] variablesToSet, String[] valuesToSet) throws ParseException {
        Map<String, Object> updatedContextValues = DataConverter.stringsToContextTypeValues(variables, variablesToSet, valuesToSet);
        context.putAll(updatedContextValues);
        return context;
    }

    private Map<String, Object> getUpdatedContext(Activity activity, String[] variablesToSet, String[] valuesToSet) {
        Map<String, Object> context = activity.getContext();
        Map variables = this.variableFactory.createVariables(activity.getProcessId(), activity.getActivityId(), activity.getContext(), true);
        for (int i = 0; i < variablesToSet.length; ++i) {
            Variable variable = (Variable)variables.get(variablesToSet[i]);
            Object value = DataConverter.stringToObject(valuesToSet[i], variable.getType());
            variable.setValue(value);
            Object basicValue = variable.getValueAsBasicType();
            context.put(variablesToSet[i], basicValue);
        }
        return context;
    }

    private void addCommentToActivity(String activityId, String processId, String commentValue) {
        String username = UserContext.isActive() ? UserContext.current().getUser().getUserName() : SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME");
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setUserId(username);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment(commentValue);
        this.commentService.createComment(comment);
    }

    private void addArchiveDataModificationComment(AddCommentType commentType, Activity activity, Consumer<String> addToList) {
        if (AddCommentType.SINGULAR.equals((Object)commentType)) {
            String comment = String.format(this.translator.translate(TRANSLATE_APP_PATH, ARCHIVE_ACTIVITY_MODIFICATION_COMMENT_KEY), LocalDateTime.now(), activity.getName(), activity.getActivityId());
            this.addCommentToActivity(activity.getActivityId(), activity.getProcessId(), comment);
        } else {
            addToList.accept(activity.getName());
        }
    }
}

