/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.applications;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.general.ProcessService;
import com.suncode.cuf.common.general.enums.AddCommentType;
import com.suncode.cuf.common.general.enums.CommentOwner;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionCallbackWithoutResult;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.xpdl.elements.Activity;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

@Application
@ComponentsFormScript(value="scripts/dynamic-pwe/update-process-app.js")
public class UpdateProcessApp {
    private static final Logger log = LoggerFactory.getLogger(UpdateProcessApp.class);
    private static final String COMPONENT_ID = "cuf.common.general.applications.UpdateProcessApp";
    private static final String ARCHIVE_MODIFICATION_COMMENT_TRANSLATION_KEY = ".archive-modification-comment";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final String ADMINISTRATOR_USERNAME = "admin";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ProcessService cufProcessService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VariableFactory variableFactory;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(COMPONENT_ID)).name("cuf.common.general.applications.UpdateProcessApp.name")).description("cuf.common.general.applications.UpdateProcessApp.desc")).category(new Category[]{Categories.GENERAL})).icon((Icon)DivanteIcon.CPU)).parameter().id("updateMode").name("cuf.common.general.applications.UpdateProcessApp.param.updateMode.name").type((Type)Types.STRING).description("cuf.common.general.applications.UpdateProcessApp.param.updateMode.desc").create()).parameter().id("processDefId").name("cuf.common.general.applications.UpdateProcessApp.param.processDefId.name").description("cuf.common.general.applications.UpdateProcessApp.param.processDefId.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("cuf.common.general.applications.UpdateProcessApp.param.activityDefId.name").description("cuf.common.general.applications.UpdateProcessApp.param.activityDefId.desc").type((Type)Types.STRING).optional().create()).parameter().id("allowMultipleProcesses").name("cuf.common.general.applications.UpdateProcessApp.param.allowMultipleProcesses.name").description("cuf.common.general.applications.UpdateProcessApp.param.allowMultipleProcesses.desc").type((Type)Types.BOOLEAN).create()).parameter().id("includeClosedActivities").name("cuf.common.general.applications.UpdateProcessApp.param.includeClosedActivities.name").description("cuf.common.general.applications.UpdateProcessApp.param.includeClosedActivities.desc").type((Type)Types.BOOLEAN).create()).parameter().id("variablesFilter").name("cuf.common.general.applications.UpdateProcessApp.param.variablesFilter.name").description("cuf.common.general.applications.UpdateProcessApp.param.variablesFilter.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("valuesFilter").name("cuf.common.general.applications.UpdateProcessApp.param.valuesFilter.name").description("cuf.common.general.applications.UpdateProcessApp.param.valuesFilter.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("variablesToSet").name("cuf.common.general.applications.UpdateProcessApp.param.variablesToSet.name").description("cuf.common.general.applications.UpdateProcessApp.param.variablesToSet.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("valuesToSet").name("cuf.common.general.applications.UpdateProcessApp.param.valuesToSet.name").description("cuf.common.general.applications.UpdateProcessApp.param.valuesToSet.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("acceptButtonId").name("cuf.common.general.applications.UpdateProcessApp.param.acceptButtonId.name").description("cuf.common.general.applications.UpdateProcessApp.param.acceptButtonId.desc").type((Type)Types.STRING).optional().create()).parameter().id("archivedDataModificationCommentType").name("cuf.common.general.applications.UpdateProcessApp.param.archivedDataModificationCommentType.name").description("cuf.common.general.applications.UpdateProcessApp.param.archivedDataModificationCommentType.desc").type((Type)Types.STRING).defaultValue((Object)AddCommentType.SINGULAR.name()).create()).parameter().id("customUserCommentType").name("cuf.common.general.applications.UpdateProcessApp.param.customUserCommentType.name").description("cuf.common.general.applications.UpdateProcessApp.param.customUserCommentType.desc").type((Type)Types.STRING).defaultValue((Object)AddCommentType.SINGULAR.name()).create()).parameter().id("customUserCommentValue").name("cuf.common.general.applications.UpdateProcessApp.param.customUserCommentValue.name").description("cuf.common.general.applications.UpdateProcessApp.param.customUserCommentValue.desc").type((Type)Types.STRING).optional().create()).parameter().id("commentOwner").name("cuf.common.general.applications.UpdateProcessApp.param.commentOwner.name").description("cuf.common.general.applications.UpdateProcessApp.param.commentOwner.desc").type((Type)Types.STRING).defaultValue((Object)CommentOwner.USER.name()).create();
    }

    public void execute(final ApplicationContext applicationContext, final @Param String updateMode, final @Param String processDefId, final @Param String activityDefId, final @Param boolean allowMultipleProcesses, final @Param String[] variablesFilter, final @Param String[] valuesFilter, final @Param String[] variablesToSet, final @Param String[] valuesToSet, final @Param boolean includeClosedActivities, final @Param String acceptButtonId, final @Param String archivedDataModificationCommentType, final @Param String customUserCommentType, final @Param String customUserCommentValue, final @Param String commentOwner) throws Exception {
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        tx.execute((SharkTransactionCallback)new SharkTransactionCallbackWithoutResult(){

            public void doInSharkTransactionWithoutResult(SharkTransaction transaction, TransactionStatus status) throws Exception {
                AddCommentType archivedDataCommentType = AddCommentType.valueOf(archivedDataModificationCommentType);
                AddCommentType customCommentType = AddCommentType.valueOf(customUserCommentType);
                CommentOwner commentAuthor = CommentOwner.valueOf(commentOwner);
                List<String> processIds = UpdateProcessApp.this.cufProcessService.getProcessesIds(processDefId, variablesFilter, valuesFilter);
                if (!allowMultipleProcesses && processIds.size() > 1) {
                    throw new IllegalArgumentException("Multiple processes not allowed. Aborting");
                }
                if (valuesToSet != null && variablesToSet != null && valuesToSet.length != variablesToSet.length) {
                    throw new IllegalArgumentException("Variables and values to set arrays must be equal in size");
                }
                UpdateMode mode = UpdateMode.valueOf(updateMode);
                switch (mode) {
                    case CANCEL_ACTIVITY: {
                        UpdateProcessApp.this.cancelActivity(applicationContext, processIds, includeClosedActivities, variablesToSet, valuesToSet, archivedDataCommentType, customCommentType, customUserCommentValue, commentAuthor, activityDefId);
                        break;
                    }
                    case ACCEPT_ACTIVITY: {
                        UpdateProcessApp.this.acceptActivity(applicationContext, processIds, includeClosedActivities, variablesToSet, valuesToSet, archivedDataCommentType, customCommentType, customUserCommentValue, commentAuthor, activityDefId, acceptButtonId);
                        break;
                    }
                    case UPDATE_ACTIVITY: {
                        UpdateProcessApp.this.updateActivity(applicationContext, processIds, includeClosedActivities, variablesToSet, valuesToSet, archivedDataCommentType, customCommentType, customUserCommentValue, commentAuthor, activityDefId);
                        break;
                    }
                    case UPDATE_PROCESS: {
                        UpdateProcessApp.this.updateProcess(applicationContext, processIds, includeClosedActivities, variablesToSet, valuesToSet, archivedDataCommentType, customCommentType, customUserCommentValue, commentAuthor, processDefId);
                    }
                }
            }
        });
    }

    private void cancelActivity(ApplicationContext applicationContext, List<String> processIds, boolean includeClosedActivities, String[] variablesToSet, String[] valuesToSet, AddCommentType archivedDataCommentType, AddCommentType customCommentType, String commentValue, CommentOwner commentOwner, String activityDefId) {
        Map<String, List<com.suncode.cuf.common.general.schemas.Activity>> processActivities = this.fetchActivities(processIds, activityDefId, includeClosedActivities);
        List<com.suncode.cuf.common.general.schemas.Activity> activities = processActivities.values().stream().flatMap(Collection::stream).toList();
        if (activities.isEmpty()) {
            return;
        }
        this.update(valuesToSet, variablesToSet, activities, archivedDataCommentType, applicationContext, commentOwner);
        this.addCustomUserComment(activities, customCommentType, commentValue, commentOwner);
        activities.forEach(activity -> this.activityService.abort(activity.getProcessId(), activity.getActivityId()));
    }

    private void update(String[] valuesToSet, String[] variablesToSet, List<com.suncode.cuf.common.general.schemas.Activity> activities, AddCommentType archivedDataCommentType, ApplicationContext applicationContext, CommentOwner commentOwner) {
        if (valuesToSet != null && variablesToSet != null) {
            this.updateActivitiesVariables(activities, variablesToSet, valuesToSet);
            this.addArchiveDataModificationComment(activities, archivedDataCommentType, applicationContext.getProcessId(), applicationContext.getActivityId(), commentOwner);
            com.suncode.cuf.common.general.schemas.Activity lastActivity = activities.get(activities.size() - 1);
            this.cufProcessService.setProcessContext(lastActivity.getProcessId(), lastActivity.getContext());
        }
    }

    private void acceptActivity(ApplicationContext applicationContext, List<String> processIds, boolean includeClosedActivities, String[] variablesToSet, String[] valuesToSet, AddCommentType archivedDataCommentType, AddCommentType customCommentType, String commentValue, CommentOwner commentOwner, String activityDefId, String acceptButtonId) {
        Map<String, List<com.suncode.cuf.common.general.schemas.Activity>> processActivities = this.fetchActivities(processIds, activityDefId, includeClosedActivities);
        List<com.suncode.cuf.common.general.schemas.Activity> activities = processActivities.values().stream().flatMap(Collection::stream).toList();
        if (activities.isEmpty()) {
            return;
        }
        this.update(valuesToSet, variablesToSet, activities, archivedDataCommentType, applicationContext, commentOwner);
        this.addCustomUserComment(activities, customCommentType, commentValue, commentOwner);
        activities.stream().filter(com.suncode.cuf.common.general.schemas.Activity::isOpen).forEach(activity -> {
            AcceptationDefinition acceptationDefinition = new AcceptationDefinition(activity.getProcessId(), activity.getActivityId(), ADMINISTRATOR_USERNAME, acceptButtonId, activity.getContext(), true);
            this.activityService.acceptActivity(acceptationDefinition);
        });
    }

    private void updateActivity(ApplicationContext applicationContext, List<String> processIds, boolean includeClosedActivities, String[] variablesToSet, String[] valuesToSet, AddCommentType archivedDataCommentType, AddCommentType customCommentType, String commentValue, CommentOwner commentOwner, String activityDefId) {
        Map<String, List<com.suncode.cuf.common.general.schemas.Activity>> processActivities = this.fetchActivities(processIds, activityDefId, includeClosedActivities);
        List<com.suncode.cuf.common.general.schemas.Activity> activities = processActivities.values().stream().flatMap(Collection::stream).toList();
        if (activities.isEmpty()) {
            return;
        }
        this.update(valuesToSet, variablesToSet, activities, archivedDataCommentType, applicationContext, commentOwner);
        this.addCustomUserComment(activities, customCommentType, commentValue, commentOwner);
    }

    private void updateProcess(ApplicationContext applicationContext, List<String> processIds, boolean includeClosedActivities, String[] variablesToSet, String[] valuesToSet, AddCommentType archivedDataCommentType, AddCommentType customCommentType, String commentValue, CommentOwner commentOwner, String processDefId) {
        for (String processId : processIds) {
            Map<String, List<com.suncode.cuf.common.general.schemas.Activity>> processActivities = this.fetchActivities(Collections.singletonList(processId), null, includeClosedActivities);
            List<com.suncode.cuf.common.general.schemas.Activity> activities = processActivities.values().stream().flatMap(Collection::stream).toList();
            if (activities.isEmpty()) continue;
            this.update(valuesToSet, variablesToSet, activities, archivedDataCommentType, applicationContext, commentOwner);
            this.addCustomUserComment(activities, customCommentType, commentValue, commentOwner);
        }
    }

    private void addCustomUserComment(List<com.suncode.cuf.common.general.schemas.Activity> activities, AddCommentType customCommentType, String commentValue, CommentOwner commentOwner) {
        if (StringUtils.isBlank((CharSequence)commentValue)) {
            return;
        }
        if (AddCommentType.SINGULAR.equals((Object)customCommentType)) {
            activities.forEach(activity -> this.addCommentToActivity(activity.getProcessId(), activity.getActivityId(), commentValue, commentOwner));
        } else {
            com.suncode.cuf.common.general.schemas.Activity lastActivity = activities.get(activities.size() - 1);
            this.addCommentToActivity(lastActivity.getProcessId(), lastActivity.getActivityId(), commentValue, commentOwner);
        }
    }

    private void addArchiveDataModificationComment(List<com.suncode.cuf.common.general.schemas.Activity> activities, AddCommentType addCommentType, String currentProcessId, String currentActivityId, CommentOwner commentOwner) {
        String datetime = LocalDateTime.now().toString(DATE_TIME_FORMATTER);
        if (AddCommentType.SINGULAR.equals((Object)addCommentType)) {
            activities.forEach(activity -> {
                if (!activity.isOpen()) {
                    String comment = String.format(this.translatorService.translate(COMPONENT_ID, ARCHIVE_MODIFICATION_COMMENT_TRANSLATION_KEY), datetime, activity.getActivityId(), currentProcessId, currentActivityId);
                    this.addCommentToActivity(activity.getProcessId(), activity.getActivityId(), comment, commentOwner);
                }
            });
        } else {
            List<com.suncode.cuf.common.general.schemas.Activity> closedActivities = activities.stream().filter(activity -> !activity.isOpen()).toList();
            if (!closedActivities.isEmpty()) {
                com.suncode.cuf.common.general.schemas.Activity lastActivity = activities.get(activities.size() - 1);
                String activityIds = closedActivities.stream().map(com.suncode.cuf.common.general.schemas.Activity::getActivityId).collect(Collectors.joining(", "));
                String comment = String.format(this.translatorService.translate(COMPONENT_ID, ARCHIVE_MODIFICATION_COMMENT_TRANSLATION_KEY), datetime, activityIds, currentProcessId, currentActivityId);
                this.addCommentToActivity(lastActivity.getProcessId(), lastActivity.getActivityId(), comment, commentOwner);
            }
        }
    }

    private void addCommentToActivity(String processId, String activityId, String commentValue, CommentOwner commentOwner) {
        if (this.isRouteActivity(processId, activityId)) {
            return;
        }
        String username = ADMINISTRATOR_USERNAME;
        if (UserContext.isActive() && CommentOwner.USER.equals((Object)commentOwner)) {
            username = UserContext.current().getUser().getUserName();
        }
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setUserId(username);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment(commentValue);
        this.commentService.createComment(comment);
    }

    private boolean isRouteActivity(String processId, String activityId) {
        Activity activityDefinition = SharkFunctions.getActivityDefinition((String)processId, (String)activityId);
        return activityDefinition.getActivityType() == 0;
    }

    private void updateActivitiesVariables(List<com.suncode.cuf.common.general.schemas.Activity> activities, String[] variablesToSet, String[] valuesToSet) {
        activities.forEach(activity -> {
            if (!activity.getContext().isEmpty()) {
                Map<String, Object> updatedContext = this.getUpdatedContext((com.suncode.cuf.common.general.schemas.Activity)activity, variablesToSet, valuesToSet);
                this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), updatedContext);
                this.updateDocuments(activity.getProcessId(), activity.getActivityId());
            }
        });
    }

    private Map<String, List<com.suncode.cuf.common.general.schemas.Activity>> fetchActivities(List<String> processesIds, String activityDefId, boolean includeClosedActivities) {
        return processesIds.stream().map(processId -> {
            List activities = this.cufProcessService.getActivities((String)processId, includeClosedActivities).stream().filter(activity -> activityDefId == null || activityDefId.equals(activity.getActivityDefId())).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry((String)processId, activities);
        }).filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (activities, activities2) -> {
            LinkedList result = new LinkedList(activities);
            result.addAll(activities2);
            return result;
        }));
    }

    private Map<String, Object> getUpdatedContext(com.suncode.cuf.common.general.schemas.Activity activity, String[] variablesToSet, String[] valuesToSet) {
        Map<String, Object> context = activity.getContext();
        Map variables = this.variableFactory.createVariables(activity.getProcessId(), activity.getActivityId(), activity.getContext(), true);
        for (int i = 0; i < variablesToSet.length; ++i) {
            Variable variable = (Variable)variables.get(variablesToSet[i]);
            Object value = DataConverter.stringToObject(valuesToSet[i], variable.getType());
            variable.setValue(value);
            Object basicValue = variable.getValueAsBasicType();
            context.put(variablesToSet[i], basicValue);
        }
        return context;
    }

    private void updateDocuments(String processId, String activityId) {
        List documents = this.documentFinder.getDocumentsFromProcess(processId, new String[0]);
        for (WfDocument document : documents) {
            this.documentClassActionService.executeProcessActions(document, DocumentEventTypes.CHANGE_PROCESS_DATA, processId, activityId);
        }
    }

    private static enum UpdateMode {
        ACCEPT_ACTIVITY,
        CANCEL_ACTIVITY,
        UPDATE_ACTIVITY,
        UPDATE_PROCESS;

    }
}

