/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general;

import com.suncode.cuf.common.db.schemas.ProcessDataDto;
import com.suncode.cuf.common.db.utils.builders.IndexFiltersBuilder;
import com.suncode.cuf.common.general.ProcessTypes;
import com.suncode.cuf.common.general.ProcessVariableDto;
import com.suncode.cuf.common.general.schemas.Activity;
import com.suncode.cuf.common.general.servlets.DuplicateCheckConfig;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.form.AcceptButton;
import com.suncode.pwfl.workflow.form.Form;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessState;
import com.suncode.pwfl.workflow.process.ProcessType;
import com.suncode.pwfl.workflow.process.search.IndexFilter;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cuf-process-service")
public class ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessService.class);
    @Autowired
    private com.suncode.pwfl.workflow.process.ProcessService processService;
    @Autowired
    private ProcessFinder processFinder;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private FormService formService;
    @Autowired
    private DocumentFinder documentFinder;

    public CountedResult<ProcessType> getProcessTypes(String query, Integer start, Integer limit) {
        List allProcessTypes = this.processService.getAllProcessTypes(false).stream().filter(processType -> processType.getName().toLowerCase().contains(query.toLowerCase()) || processType.getProcessDefId().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        List processTypesOnPage = allProcessTypes.subList(start, Math.min(allProcessTypes.size(), start + limit));
        return new CountedResult((long)allProcessTypes.size(), processTypesOnPage);
    }

    public CountedResult<ActivityType> getActivitiesTypes(String processDefId, String query, Integer start, Integer limit) {
        List allActivitiesTypes = this.processService.getActivityTypes(processDefId).stream().filter(activityType -> activityType.getName().toLowerCase().contains(query.toLowerCase()) || activityType.getActivityDefId().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        List processTypesOnPage = allActivitiesTypes.subList(start, Math.min(allActivitiesTypes.size(), start + limit));
        return new CountedResult((long)allActivitiesTypes.size(), processTypesOnPage);
    }

    public CountedResult<AcceptButton> getAcceptanceButtons(String activityDefId, String processDefId, String query) {
        Form form = this.formService.getForm(processDefId, activityDefId);
        List<AcceptButton> buttons = form.getButtons();
        if (!query.isEmpty()) {
            buttons = this.getButton(query, buttons);
        }
        if (buttons.size() == 1 && buttons.get(0).getActionName().equals("")) {
            buttons.get(0).setActionName("DEFAULT_ACCEPT_BUTTON");
        }
        return new CountedResult((long)buttons.size(), buttons);
    }

    private List<AcceptButton> getButton(String query, List<AcceptButton> buttons) {
        ArrayList<AcceptButton> acceptButtons = new ArrayList<AcceptButton>();
        for (AcceptButton button : buttons) {
            if (!button.getActionName().equals(query)) continue;
            acceptButtons.add(button);
        }
        return acceptButtons;
    }

    public List<ProcessIndex> getProcessIndexes(String processDefId) {
        return this.processService.getProcessIndexes(processDefId);
    }

    public CountedResult<ProcessVariableDto> getProcessVariables(String processDefId, String query, Integer start, Integer limit) {
        List allProcessVariables = this.processService.getProcessIndexes(processDefId).stream().filter(processIndex -> processIndex.getName().toLowerCase().contains(query.toLowerCase()) || processIndex.getId().toLowerCase().contains(query.toLowerCase())).map(processIndex -> new ProcessVariableDto(processIndex.getId(), processIndex.getName())).collect(Collectors.toList());
        List processVariablesOnPage = allProcessVariables.subList(start, Math.min(allProcessVariables.size(), start + limit));
        return new CountedResult((long)allProcessVariables.size(), processVariablesOnPage);
    }

    public List<Activity> getActivities(String processId) {
        return this.getActivities(processId, false);
    }

    public List<Activity> getActivities(String processId, boolean includeClosedActivities) {
        List processActivities = includeClosedActivities ? this.activityFinder.findByProcessId(processId, new String[0]) : this.activityFinder.findOpenedActivities(processId);
        log.info(processActivities.size() + " activities with given activityDefId and processId/processDefId has been found.");
        return processActivities.stream().map(activity -> Activity.builder().processId(activity.getProcessId()).activityId(activity.getActivityId()).activityDefId(activity.getActivityDefinitionId()).open(activity.isOpen()).lastPmIdxUpdateDate(activity.isOpen() ? activity.getCreatedTime() : activity.getLastStateTime()).name(activity.getName()).context(this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId())).build()).sorted(Comparator.comparing(Activity::getLastPmIdxUpdateDate)).collect(Collectors.toList());
    }

    public void setProcessContext(String processId, Map<String, Object> context) {
        this.processService.setProcessContext(processId, context);
    }

    public Map<String, Object> getProcessContext(String processId) {
        return this.processService.getProcessContext(processId);
    }

    public List<String> getProcessesIds(String processDefId, String[] variablesToFilter, String[] valuesToFilter) throws ParseException {
        List<ProcessIndex> processIndexes = this.getProcessIndexes(processDefId);
        Map<String, Object> filtersMap = DataConverter.stringsToContextTypeValues(processIndexes, variablesToFilter, valuesToFilter);
        List processes = filtersMap.size() > 0 ? this.processFinder.findByIndexes(processDefId, filtersMap, new String[]{"processDefinition"}) : this.processFinder.findByProcessDefinitionId(processDefId);
        return processes.stream().filter(process -> this.isCorrectProcessState(process.getState())).map(Process::getProcessId).collect(Collectors.toList());
    }

    private boolean isCorrectProcessState(ProcessState state) {
        return state == ProcessState.RUNNING || state == ProcessState.NOT_STARTED || state == ProcessState.COMPLETED;
    }

    private String getType(ProcessIndex pi) {
        return pi.isTabular() ? pi.getType().name() + "[]" : pi.getType().name();
    }

    public List<String> getProcessDuplicatesIds(DuplicateCheckConfig duplicateCheckConfig) {
        List<IndexFilter> filters = this.buildFilters(duplicateCheckConfig);
        List duplicatesIds = this.processFinder.findProcessId(duplicateCheckConfig.getProcessDefId(), filters, new String[0]);
        return duplicatesIds.stream().map(processId -> this.processService.getProcess(processId, new String[0])).filter(process -> this.isProcessOfType((Process)process, ProcessTypes.valueOf(duplicateCheckConfig.getProcessesType()))).map(Process::getProcessId).collect(Collectors.toList());
    }

    public List<Process> getProcessDuplicates(DuplicateCheckConfig duplicateCheckConfig) {
        List<IndexFilter> filters = this.buildFilters(duplicateCheckConfig);
        List duplicates = this.processFinder.findByIndexes(duplicateCheckConfig.getProcessDefId(), filters, new String[0]);
        return this.getProcessesOfType(duplicates, ProcessTypes.valueOf(duplicateCheckConfig.getProcessesType()));
    }

    public List<IndexFilter> buildFilters(DuplicateCheckConfig duplicateCheckConfig) {
        IndexFiltersBuilder ifb = IndexFiltersBuilder.getProperIndexFiltersBuilder();
        ifb.addFilter((IndexFilter)new SimpleIndexFilter("processId", (Object)duplicateCheckConfig.getProcessId(), FilterOperator.NOTEQ));
        ifb.addVariablesFilters(duplicateCheckConfig.getVariablesToCheck(), true, duplicateCheckConfig.getCaseSensitive());
        ifb.addVariablesFilters(duplicateCheckConfig.getVariablesExcludingDuplicates(), false, duplicateCheckConfig.getCaseSensitive());
        return ifb.getFilters();
    }

    private List<Process> getProcessesOfType(List<Process> duplicates, ProcessTypes processesType) {
        return duplicates.stream().filter(duplicate -> this.isProcessOfType((Process)duplicate, processesType)).collect(Collectors.toList());
    }

    private boolean isProcessOfType(Process duplicate, ProcessTypes processesType) throws IllegalArgumentException {
        boolean isOpen = ProcessState.isOpen((ProcessState)duplicate.getState());
        switch (processesType) {
            case ALL: {
                return true;
            }
            case OPENED: {
                return isOpen;
            }
            case CLOSED: {
                return !isOpen;
            }
        }
        throw new IllegalArgumentException("Z\u0142y typ procesu. Nale\u017cy wybra\u0107 z ALL/OPENED/CLOSED, a wybrano: " + String.valueOf((Object)processesType));
    }

    public CountedResult<Process> findProcessesWithFilters(ProcessDataDto dto) {
        List<IndexFilter> filters = this.buildFilters(dto);
        return this.processFinder.findByIndexes(dto.getProcessDefId(), filters, dto.getSorters(), dto.getStart(), dto.getLimit(), new String[0]);
    }

    public CountedResult<Map<String, Object>> getDataFromProcesses(CountedResult<Process> processes, String[] variablesIds) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (Process process : processes.getData()) {
            data.add(this.getDataFromProcess(process, variablesIds));
        }
        return new CountedResult(processes.getTotal(), data);
    }

    private List<IndexFilter> buildFilters(ProcessDataDto dto) {
        IndexFiltersBuilder ifb = IndexFiltersBuilder.getProperIndexFiltersBuilder();
        ifb.addFilter((IndexFilter)new SimpleIndexFilter("processId", (Object)dto.getProcessIds(), FilterOperator.IN));
        ifb.addFilters(dto.getFilters());
        return ifb.getFilters();
    }

    private Map<String, Object> getDataFromProcess(Process process, String[] variablesIds) {
        Map processContext = this.processService.getProcessContext(process.getProcessId());
        HashMap<String, Object> processData = new HashMap<String, Object>();
        for (String variableId : variablesIds) {
            Object value = processContext.get(variableId);
            if (value instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                value = dateFormat.format(value);
            }
            processData.put(variableId, value);
        }
        String documentsLinks = this.getDocumentsLinksFromProcess(process.getProcessId());
        processData.put("document_preview", documentsLinks);
        processData.put("process_name", process.getName());
        processData.put("link_to_process", this.getLinkToProcess(process.getProcessId()));
        return processData;
    }

    private String getDocumentsLinksFromProcess(String processId) {
        StringBuffer stringBuffer = new StringBuffer();
        List documents = this.documentFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
        stringBuffer.append("<div ");
        if (!documents.isEmpty()) {
            stringBuffer.append("onclick=\"onClickPreviewDoc(this)\" ");
        }
        stringBuffer.append("class=\"document-preview document-preview-multiple\" data-documents='[");
        for (int i = 0; i < documents.size(); ++i) {
            WfDocument doc = (WfDocument)documents.get(i);
            stringBuffer.append("{\"name\":\"");
            stringBuffer.append(doc.getFile().getFileName());
            stringBuffer.append("\",\"id\":");
            stringBuffer.append(doc.getFile().getId());
            stringBuffer.append(",\"description\":\"");
            stringBuffer.append(doc.getFile().getDescription());
            stringBuffer.append("\",\"date\":");
            stringBuffer.append(doc.getFile().getFileDate().getTime());
            stringBuffer.append(",\"documentClass\":\"");
            stringBuffer.append(doc.getFile().getDocumentClass().getName());
            stringBuffer.append("\",\"containsInformation\":false,\"url\":\"");
            stringBuffer.append("ShowFile.do?fileName=");
            String fileId = String.valueOf(((WfDocument)documents.get(i)).getFile().getId());
            String encodedFileId = new String(new Base64().encode(fileId.getBytes()));
            stringBuffer.append(encodedFileId);
            stringBuffer.append("&processId=");
            stringBuffer.append(processId);
            stringBuffer.append("\",\"urlInformation\":\"\"}");
            if (i >= documents.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]' id=\"ext-gen44\">");
        stringBuffer.append("<a class=\"silk-page-white-stack\" href=\"javascript://nop\" style=\"display: inline-block;width:16px;height:16px\"></a><span>(");
        stringBuffer.append(documents.size());
        stringBuffer.append(")</span></div>");
        return stringBuffer.toString();
    }

    public String getLinkToProcess(String processId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<a href=\"");
        stringBuilder.append("ShowProcessHistory.do?ProcessId=");
        stringBuilder.append(processId);
        stringBuilder.append("\" target=\"_blank\" name=\"details\" style=\"font-weight: bold; text-decoration: none;\">Szczeg\u00f3\u0142y</a>");
        return stringBuilder.toString();
    }

    public boolean hasDuplicateValues(DuplicateCheckConfig config) {
        List<IndexFilter> filters = this.buildFilters(config);
        return this.processFinder.exists(config.getProcessDefId(), filters, new String[0]);
    }
}

