/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.functions;

import com.suncode.cuf.common.documents.functions.PDFUtilsFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/functions/pdf"})
public class PDFUtilsFunctionsController {
    private static final Logger log = LoggerFactory.getLogger(PDFUtilsFunctionsController.class);
    @Autowired
    private PDFUtilsFunctions pdfUtilsFunctions;

    @PostMapping(value={"/pdf-to-text"})
    public ResponseEntity<String> pdfToText(@RequestBody Integer fileId) {
        log.debug("Extracting text from PDF file {} via REST", (Object)fileId);
        try {
            String result = this.pdfUtilsFunctions.PDF2TXT(fileId);
            log.debug("Text extracted from PDF file {} (length: {} characters)", (Object)fileId, (Object)result.length());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/plain;charset=UTF-8"})).body((Object)result);
        }
        catch (Exception e) {
            log.error("Error while extracting text from PDF file {} via REST", (Object)fileId, (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"");
        }
    }

    @PostMapping(value={"/is-text-pdf"})
    public ResponseEntity<Boolean> isTextPDF(@RequestBody Integer fileId) {
        log.debug("Checking if PDF file {} contains text via REST", (Object)fileId);
        try {
            Boolean result = this.pdfUtilsFunctions.isTextPDF(fileId);
            log.debug("PDF file {} {} text", (Object)fileId, (Object)(result != false ? "contains" : "does not contain"));
            return ResponseEntity.ok((Object)result);
        }
        catch (Exception e) {
            log.error("Error while checking PDF file {} via REST", (Object)fileId, (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)false);
        }
    }
}

