/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.duals;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.documents.services.PDFService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/pdf-splitter-dual-form.js")
public class PDFSplitterDual {
    private static final Logger log = LoggerFactory.getLogger(PDFSplitterDual.class);
    @Autowired
    private CUFCommonDocumentService documentsService;
    @Autowired
    private PDFService pdfService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("cuf-components.pdf.splitter.dual")).name("cuf-components.pdf.splitter.dual.name")).description("cuf-components.pdf.splitter.dual.desc")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)SilkIconPack.APPLICATION)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}split-pdf-documents-application")).parameter().id("fileId").name("pdf.splitter.fileId.name").description("pdf.splitter.fileId.desc").type((Type)Types.INTEGER).create()).parameter().id("documentClassName").name("pdf.splitter.documentClassName.name").description("pdf.splitter.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentDescription").name("pdf.splitter.documentDescription.name").description("pdf.splitter.documentDescription.desc").type((Type)Types.STRING).optional().create()).parameter().id("saveAsNewVersion").name("pdf.splitter.saveAsNewVersion.name").description("pdf.splitter.saveAsNewVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("attachToProcess").name("pdf.splitter.attachToProcess.name").description("pdf.splitter.attachToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("fromPages").name("pdf.splitter.fromPages.name").description("pdf.splitter.fromPages.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("toPages").name("pdf.splitter.toPages.name").description("pdf.splitter.toPages.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("indexesName").name("pdf.splitter.indexesName.name").description("pdf.splitter.indexesName.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("indexesValue").name("pdf.splitter.indexesValue.name").description("pdf.splitter.indexesValue.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("executeActions").name("pdf.splitter.executeActions.name").description("pdf.splitter.executeActions.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(ApplicationContext context, @Param Long fileId, @Param Boolean attachToProcess, @Param Integer[] fromPages, @Param Integer[] toPages, @Param String documentClassName, @Param String documentDescription, @Param Boolean saveAsNewVersion, @PairedParam(key="indexesName", value="indexesValue") Map<String, String> indexes, @Param Boolean executeActions, Translator translator) throws AcceptanceException {
        this.run(context.getProcessId(), fileId, attachToProcess, fromPages, toPages, documentClassName, documentDescription, saveAsNewVersion, indexes, executeActions, translator);
    }

    public void set(AcceptanceContext context, @Param Long fileId, @Param Boolean attachToProcess, @Param Integer[] fromPages, @Param Integer[] toPages, @Param String documentClassName, @Param String documentDescription, @Param Boolean saveAsNewVersion, @PairedParam(key="indexesName", value="indexesValue") Map<String, String> indexes, @Param Boolean executeActions, Translator translator) throws AcceptanceException {
        this.run(context.getProcessId(), fileId, attachToProcess, fromPages, toPages, documentClassName, documentDescription, saveAsNewVersion, indexes, executeActions, translator);
    }

    private void run(String processId, Long fileId, Boolean attachToProcess, Integer[] fromPages, Integer[] toPages, String documentClassName, String documentDescription, Boolean saveAsNewVersion, Map<String, String> indexes, Boolean executeActions, Translator translator) throws AcceptanceException {
        WfFile wfFile = this.fileService.getFile(fileId, new String[0]);
        Assert.notNull((Object)wfFile, (String)("File with id " + fileId + " does not exist in system archive."));
        Assert.isTrue((boolean)FilenameUtils.getExtension((String)wfFile.getFileName()).equalsIgnoreCase("PDF"), (String)("The file with id " + fileId + " does not have the pdf extension"));
        Assert.isTrue((fromPages.length == toPages.length ? 1 : 0) != 0, (String)"The number of page ranges is unequal in length");
        InputStream inputStream = this.fileService.getFileInputStream(fileId);
        try (PDDocument pdfDocument = PDDocument.load((InputStream)inputStream);){
            List<PDDocument> newDocuments = this.pdfService.splitIntoMultipleDocuments(fromPages, toPages, pdfDocument);
            IntStream.range(0, newDocuments.size()).forEach(idx -> {
                try (PDDocument document = (PDDocument)newDocuments.get(idx);){
                    String fileName = this.buildFileName(wfFile.getFileName(), idx + 1);
                    TempFile tempFile = new TempFile();
                    document.save(tempFile.getFile());
                    DocumentDefinition documentDefinition = this.getDocumentDefinition(processId, attachToProcess, documentClassName, indexes, fileName, tempFile, documentDescription, saveAsNewVersion);
                    AddDocumentResultMeta newWfDocument = this.documentsService.addDocumentWithMetaResult(documentDefinition);
                    if (executeActions.booleanValue()) {
                        log.info("Execute archive actions");
                        this.documentClassActionService.executeArchiveActions(newWfDocument.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                    }
                    log.info("Added new document. DocumentName: " + fileName + " docId: " + newWfDocument.getDocument().getId());
                    tempFile.delete();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new AcceptanceException(translator.getMessage("pdf.splitter.message.document_is_encrypted"));
        }
    }

    private DocumentDefinition getDocumentDefinition(String processId, Boolean attachToProcess, String documentClassName, Map<String, String> indexes, String fileName, TempFile tempFile, String documentDescription, Boolean saveAsNewVersion) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setInputStream(tempFile.getInputStream());
        documentDefinition.setUserName("admin");
        documentDefinition.setFileName(fileName);
        if (StringUtils.isNotBlank((CharSequence)documentDescription)) {
            documentDefinition.setDescription(documentDescription);
        }
        documentDefinition.setDocumentClassId(this.documentsService.getDocumentClassID(documentClassName));
        documentDefinition.setIndexes(this.documentsService.convertIndexes(indexes, documentClassName));
        if (attachToProcess.booleanValue()) {
            documentDefinition.setProcessId(processId);
        }
        documentDefinition.setSaveAsNewVersion(saveAsNewVersion.booleanValue());
        return documentDefinition;
    }

    private String buildFileName(String fileName, int idx) {
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        String baseName = FilenameUtils.getBaseName((String)fileName);
        return baseName + "_" + idx + "." + fileExtension;
    }
}

