/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.currency.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.currency.ExchangeService;
import com.suncode.cuf.currency.RateDto;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
@Application
@ComponentsFormScript(value="scripts/dynamic-pwe/pln-exchange-rate-form.js")
public class PLNExchangeRateDuals {
    @Autowired
    private ExchangeService exchangeService;

    @Define
    public void action(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("exchange-rate-duals")).name("duals.exchangerate.name")).description("duals.exchangerate.desc")).icon((Icon)SilkIconPack.APPLICATION_FORM)).category(new Category[]{Categories.CURRENCY})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}get-pln-exchange-rate-application")).parameter().id("currencies").name("duals.exchangerate.currencies.name").description("duals.exchangerate.currencies.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("dates").name("duals.exchangerate.dates.name").description("duals.exchangerate.dates.desc").type((Type)Types.DATE_ARRAY).create()).parameter().id("exchange").name("duals.exchangerate.exchange.name").description("duals.exchangerate.exchange.desc").type((Type)Types.VARIABLE).create()).parameter().id("tableNo").name("duals.exchangerate.param.tableNo.name").description("duals.exchangerate.param.tableNo.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("tableType").name("duals.exchangerate.param.tableType.name").description("duals.exchangerate.param.tableType.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("dateOffset").name("default.exchangerate.dateOffset.name").description("default.exchangerate.dateOffset.desc").type((Type)Types.INTEGER).defaultValue((Object)0L).create()).parameter().id("effectiveDate").name("default.exchangerate.effectiveDate.name").description("default.exchangerate.effectiveDate.desc").type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param String[] currencies, @Param org.joda.time.LocalDate[] dates, @Param Long dateOffset, @Param Variable exchange, @Param Variable tableNo, @Param Variable tableType, @Param Variable effectiveDate) throws Exception {
        this.run(currencies, dates, dateOffset, exchange, tableNo, tableType, effectiveDate);
    }

    public void set(@Param String[] currencies, @Param org.joda.time.LocalDate[] dates, @Param Long dateOffset, @Param Variable exchange, @Param Variable tableNo, @Param Variable tableType, @Param Variable effectiveDate) throws Exception {
        this.run(currencies, dates, dateOffset, exchange, tableNo, tableType, effectiveDate);
    }

    private void run(String[] currencies, org.joda.time.LocalDate[] dates, Long dateOffset, Variable exchange, Variable tableNo, Variable tableType, Variable effectiveDate) throws Exception {
        this.assertLength(currencies.length, dates.length);
        List<RateDto> rates = this.getRates(currencies, this.calcDateoffset(dates, dateOffset));
        this.setVariable(exchange, rates, RateDto::getMid, Double.class);
        this.setVariable(tableNo, rates, RateDto::getNo, String.class);
        this.setVariable(tableType, rates, RateDto::getTable, String.class);
        this.setVariable(effectiveDate, rates, rateDto -> org.joda.time.LocalDate.parse((String)rateDto.getEffectiveDate()), org.joda.time.LocalDate.class);
    }

    private void assertLength(int length, int length2) {
        if (length != length2) {
            throw new IllegalArgumentException("The parameters have different lengths. Currency: " + length + " , Date: " + length2);
        }
    }

    private <T> void setVariable(Variable variable, List<RateDto> rates, Function<RateDto, T> getValue, Class<T> clazz) {
        if (variable != null) {
            if (variable.isArray()) {
                Object[] values = rates.stream().map(getValue).collect(Collectors.toList()).toArray((Object[])Array.newInstance(clazz, rates.size()));
                variable.setValue((Object)values);
            } else if (!rates.isEmpty()) {
                variable.setValue(getValue.apply(rates.get(0)));
            }
        }
    }

    private List<RateDto> getRates(String[] currencies, org.joda.time.LocalDate[] dates) throws Exception {
        LinkedList<RateDto> rates = new LinkedList<RateDto>();
        for (int i = 0; i < currencies.length; ++i) {
            if (StringUtils.isBlank((CharSequence)currencies[i]) || dates[i] == null) {
                rates.add(new RateDto());
                continue;
            }
            if ("PLN".equals(currencies[i])) {
                RateDto rate = new RateDto();
                rate.setMid(Double.valueOf(1.0));
                rates.add(rate);
                continue;
            }
            LocalDate timeDate = LocalDate.of(dates[i].getYear(), dates[i].getMonthOfYear(), dates[i].getDayOfMonth());
            RateDto rate = this.exchangeService.getLastNbpExchangeWithTableSymbol(currencies[i], timeDate);
            if (rate == null) {
                throw new IllegalArgumentException("No exchange rate found for the given currency: " + currencies[i] + " and dates: " + String.valueOf(timeDate));
            }
            rates.add(rate);
        }
        return rates;
    }

    private org.joda.time.LocalDate[] calcDateoffset(org.joda.time.LocalDate[] dates, Long dateOffset) {
        return Arrays.stream(dates).map(date -> date.plusDays(dateOffset.intValue())).collect(Collectors.toList()).toArray(new org.joda.time.LocalDate[0]);
    }
}

