PW.EventActions.register("check-oauth-token-expired-eventaction", function (context, clientName, connectionName) {
    try {
        if (checkTokenExpired(clientName, connectionName)) {
            const currentDate = new Date();
            const oneDayMillis = 24 * 60 * 60 * 1000;
            currentDate.setTime(currentDate.getTime() + oneDayMillis);
            const expires = "expires=" + currentDate.toUTCString();

            document.cookie = "oauth_connection_name=" + connectionName + ";" + expires + ";path=/";
            document.cookie = "oauth_client_name=" + clientName + ";" + expires + ";path=/";
            document.cookie = "update=true" + ";" + expires + ";path=/";

            this.fireEvent("connectionInvalid", {
                "authUrl": getAuthUrl(clientName)
            });
        } else {
            this.fireEvent("connectionValid");
        }
    } catch (error) {
        console.log(error);
    }

});

function getAuthUrl(clientName) {
    let data;
    jQuery.ajax({
            url: PW.getAbsolutePath("api/oauth/auth/" + clientName),
            success: function (response) {
                data = response;
            },
            error: function (xhr, status, error) {
                throw new Error(error);
            },
            async: false
        }
    );

    return data;
}

function checkTokenExpired(clientName, connectionName) {
    let data = false;
    jQuery.ajax({
            dataType: "json",
            url: PW.getAbsolutePath("plugin/com.suncode-cuf-components/oauth/checkTokenExpired/" + clientName + "/" + connectionName),
            success: function (result) {
                data = (result === true);
            },
            error: function (xhr, status, error) {
                throw new Error(error);
            },
            async: false
        }
    );

    return data;
}