/**
 * User chooser dynamic form
 */
PWE.integrationComponent.registerDataChooser('user-datachooser', {

    buildForm: function (form, options) {
        var mapping = [
            { id: "firstname", display: CUFCommon.t('dc.userdatachooser.firstname'), description: "Mapping: firstname" },
            { id: "lastname", display: CUFCommon.t('dc.userdatachooser.lastname'), description: "Mapping: lastname" },
            { id: "email", display: CUFCommon.t('dc.userdatachooser.email'), description: "Mapping: email" },
            { id: "fullname", display: CUFCommon.t('dc.userdatachooser.fullname'), description: "Mapping: fullname" },
            { id: "number", display: CUFCommon.t('dc.userdatachooser.number'), description: "Mapping: number" },
            { id: "groupname", display: CUFCommon.t('dc.userdatachooser.groupname'), description: "Mapping: groupname" },
            { id: "positionname", display: CUFCommon.t('dc.userdatachooser.positionname'), description: "Mapping: positionname" },
            { id: "positionousymbol", display: CUFCommon.t('dc.userdatachooser.positionousymbol'), description: "Mapping: positionousymbol" },
            { id: "positionsymbol", display: CUFCommon.t('dc.userdatachooser.positionsymbol'), description: "Mapping: positionsymbol" }
        ];

        form.addField({
            id: "login"
        });
        form.addCombobox({
            id: "dataType",
            values: [
                { id: "groups", display: CUFCommon.t('dc.userdatachooser.groups'),description:'groups' },
                { id: "positions", display: CUFCommon.t('dc.userdatachooser.positions'),description:'positions' }
            ]
        });
        form.addCombobox({
            id: "filterBy",
            values: mapping
        });
        form.addCombobox({
            id: "sortBy",
            values: mapping

        });
        form.addCombobox({
            id: "sortDirection",
            values: [
                { id: "ASC", display: "ASC",description: CUFCommon.t('dc.userdatachooser.ASC')},
                { id: "DESC", display: "DESC",description: CUFCommon.t('dc.userdatachooser.DESC') }
            ]
        });


    }
});