PWE.integrationComponent.registerApplication('upload-document-from-disk.dual', {
    apiVersion: 2,
    buildForm: function(form) {
        buildUploadDocumentsFromDiskForm(form);
        buildAdditionalSettingsFieldSet(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('upload-document-from-disk.dual', {
    apiVersion: 2,
    buildForm: function(form) {
        buildUploadDocumentsFromDiskForm(form);
        buildAdditionalSettingsFieldSet(form);
    }
});

function buildUploadDocumentsFromDiskForm(form) {
    let basicParamFieldSet = form.addFieldSet({
        title: CUFCommon.t("dpwe.label.basic-parameters"),
        collapsible: true,
    });
    basicParamFieldSet.addCombobox({
        id : "pathType",
        values : [
            { id: "FILE", display: CUFCommon.t("cuf-components.upload-document-from-disk.dual.path-type.file.name") },
            { id: "DIRECTORY", display: CUFCommon.t("cuf-components.upload-document-from-disk.dual.path-type.directory.name") }
        ],
        listeners: {
            change: function() {
                toggleUploadDocumentsFromDiskFormFields(form);
            }
        }
    });
    basicParamFieldSet.addField("pathname");
    basicParamFieldSet.addField("directoryPath");
    basicParamFieldSet.addField("fileNameFilter");
    basicParamFieldSet.addField("searchSubdirectories");
    let me = this;
    CufComp.addComboboxClassList("docClassName", {
        change: function (value) {
            if (!form.hasVariableValue("docClassName") && !form.hasFunctionValue("docClassName")) {
                me.indexNameCombobox.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
            }
            me.indexTable.clear();
        }
    }, basicParamFieldSet);

    let indexFieldSet = form.addFieldSet({
        title: CUFCommon.t("dpwe.label.indexes"),
        collapsible: true,
    });
    this.indexTable = indexFieldSet.addTable();
    this.indexNameCombobox = CufComp.addComboboxClassIndexList("indexesName", form.getValue("docClassName"), null, this.indexTable);
    this.indexTable.addField("indexesValue");

    toggleUploadDocumentsFromDiskFormFields(form);
}

function toggleUploadDocumentsFromDiskFormFields(form) {
    if (form.getValue("pathType") === "FILE") {
        toggleFieldsWhenPathTypeIsFile(form);
    } else if (form.getValue("pathType") === "DIRECTORY") {
        toggleFieldsWhenPathTypeIsDirectory(form);
    } else if (form.hasVariableValue("pathType") || form.hasFunctionValue("pathType")) {
        toggleFieldsWhenPathTypeIsVariableOrFunction(form);
    } else {
        toggleFieldsWhenPathTypeIsUndefined(form);
    }
}

function toggleFieldsWhenPathTypeIsFile(form) {
    form.setNotEmpty("pathname", true);
    form.show("pathname");
    form.setNotEmpty("directoryPath", false);
    form.hide("directoryPath");
    form.hide("fileNameFilter");
    form.setNotEmpty("searchSubdirectories", false);
    form.hide("searchSubdirectories");
}

function toggleFieldsWhenPathTypeIsDirectory(form) {
    form.setNotEmpty("directoryPath", true);
    form.show("directoryPath");
    form.show("fileNameFilter");
    form.setNotEmpty("searchSubdirectories", true);
    form.show("searchSubdirectories");
    form.setNotEmpty("pathname", false);
    form.hide("pathname");
}

function toggleFieldsWhenPathTypeIsVariableOrFunction(form) {
    form.setNotEmpty("pathname", false);
    form.show("pathname");
    form.setNotEmpty("directoryPath", false);
    form.show("directoryPath");
    form.show("fileNameFilter");
    form.setNotEmpty("searchSubdirectories", false);
    form.show("searchSubdirectories");
}

function toggleFieldsWhenPathTypeIsUndefined(form) {
    form.setNotEmpty("pathname", false);
    form.hide("pathname");
    form.setNotEmpty("directoryPath", false);
    form.hide("directoryPath");
    form.hide("fileNameFilter");
    form.setNotEmpty("searchSubdirectories", false);
    form.hide("searchSubdirectories");
}

function buildAdditionalSettingsFieldSet(form) {
    let additionalParametersFieldSet = form.addFieldSet({
        title: CUFCommon.t("dpwe.label.additional-parameters"),
        collapsible: true,
        collapsed: true
    })
    additionalParametersFieldSet.addField("documentDescription");
    additionalParametersFieldSet.addField("saveAsNewVersion");
    additionalParametersFieldSet.addField("attachToProcess");
    additionalParametersFieldSet.addField("runDocClassAction");
}