PWE.integrationComponent.registerSystemFunction("TableStore.groupBy", [{
		type: 'string',
		id: 'aggregateFunctions',
		array: true
	}, {
		type: 'variable',
		id: 'rawColumns',
		array: true
	},
	{
		type: 'string',
		id: 'fieldId',
		array: true
	}, {
		type: 'string',
		id: 'concatSeparator',
		array: false
	}, {
		type: 'string',
		id: 'decimalPlaces',
		array: false
	}, {
		type: 'variable',
		id: 'groupByColumns',
		array: true
	}],
	{
		apiVersion: 2,
		buildForm: function(form) {
			var table = form.addTable({
				name: CUFCommon.t("function-groupBy-form-result-table")
			});
			table.addCombobox({
				id: "aggregateFunctions",
				name: CUFCommon.t("function-groupBy-form-aggregate-function-comboBox-name"),
				optional: false,
				listeners: {
					change: function(value,options) {
						setSeparatorVisibility(form);
						setDecimalPlacesVisibility(form);
						addGroupVarToGroupByColumn(options.rowIndex,form);
					}
				},
				values: [
					{ id: "CONCAT", display: "CONCAT" },
					{ id: "SUM", display: "SUM" },
					{ id: "MIN", display: "MIN" },
					{ id: "MAX", display: "MAX" },
					{ id: "AVG", display: "AVG" },
					{ id: "COUNT", display: "COUNT" },
					{ id: "GROUPINGVAL", display: CUFCommon.t("function-groupBy-form-aggregate-function-comboBox-groupingValue") }
				],
				template: [
					{
						label: CUFCommon.t("function-groupBy-form-aggregate-function-comboBox-label"),
						field: "aggregateFunction"
					}
				],
				valueField: "aggregateFunction",
				displayField: "aggregateFunction",
				sort: [{
					property: "aggregateFunction",
					direction: "ASC"
				}]
			});
			table.addField({ id: "rawColumns",
				name: CUFCommon.t("function-groupBy-form-raw-columns"),
				notEmpty: true,
				optional: true,
				listeners: {
					change: function(value,options ) {
						if(value.indexOf("$")==0){
							value=value.slice(1,value.length);
						}
						form.setFieldValueInArray("fieldId",options.rowIndex  ,value);
						addGroupVarToGroupByColumn(options.rowIndex,form);
					}
				}
			});
			table.addField({ id: "fieldId", name: CUFCommon.t("function-groupBy-form-fieldId-key"), notEmpty: true, optional: true });
			form.addField({ id: "concatSeparator", name: CUFCommon.t("function-groupBy-form-concat-separator"), value: ";", notEmpty: false, optional: true });
			form.addField({ id: "decimalPlaces", name: CUFCommon.t("function-groupBy-form-decimalPlaces"), value: "2", notEmpty: false, optional: true });
			form.addField({ id: "groupByColumns", name: CUFCommon.t("function-groupBy-form-groupBy-columns"), notEmpty: true, optional: false });
			setSeparatorVisibility(form);
			setDecimalPlacesVisibility(form);
		},
		validateForm: function(api) {
			var error = false;
			for (var i = 0; i < api.getArraySize("aggregateFunctions"); i++) {
				var aggregateFunction = api.getValue("aggregateFunctions")[i];
				var variableType = api.getVariableType("rawColumns", i);

				if (aggregateFunction == "GROUPINGVAL") {
					assertVariableIsGroupByVariable(i, api);
				}
				else if (aggregateFunction == "CONCAT") {
					assertVariableTypeIsStringArray(variableType, i, api)
					assertAggFunForGroupVarIsEmpty(i, api);
				}
				else if (aggregateFunction == "SUM" || aggregateFunction == "AVG") {
					assertVariableIsNumberType(variableType, i, api)
					assertAggFunForGroupVarIsEmpty(i, api);
					assertDecimalPlacesValueIsBetweenZeroAndEight(api);
				}
				else if (aggregateFunction == "MIN" || aggregateFunction == "MAX") {
					assertVariableIsNotStringOrBooleanType(variableType, i, api)
					assertAggFunForGroupVarIsEmpty(i, api);
				}
				else if (aggregateFunction == "COUNT") {
					assertVariableIsNotDateOrDatetimeType(variableType, i, api)
					assertAggFunForGroupVarIsEmpty(i, api);
				
				}
			}
			
			if (hasDuplicates(api.getValue("rawColumns"))) {
				api.showErrorMessage(CUFCommon.t("function-groupBy-form-duplicatedVars-err"));
				throw new Error();
			}
		},
	});
function assertVariableIsNotDateOrDatetimeType(variableType, i, api) {
	if (variableType === "date[]" || variableType === "date" || variableType === "datetime[]" || variableType === "datetime") {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-notIntOrFloatOrString-err"));
		throw new Error();
	}
}
function assertVariableIsNotStringOrBooleanType(variableType, i, api) {
	if (variableType === "string[]" || variableType === "string" || variableType === "boolean") {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-notIntOrFloatOrDate-err"));
		throw new Error();
	}
}
function assertVariableIsNumberType(variableType, i, api) {
	if (variableType != "integer[]" && variableType != "float[]") {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-notIntOrFloat-err"));
		throw new Error();
	}
}
function assertVariableIsGroupByVariable(i, api) {
	if (api.getValue("groupByColumns").indexOf(api.getValue("rawColumns")[i]) < 0) {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-invalidAgrForGroupVar-err"));
		throw new Error();
	}
}
function assertAggFunForGroupVarIsEmpty(i, api) {
	if ((api.getValue("groupByColumns").indexOf(api.getValue("rawColumns")[i]) > -1) && api.getValue("aggregateFunctions")[i] != "") {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-noAggFunForGroupVar-err"));
		throw new Error();
	}
}
function assertVariableTypeIsStringArray(variableType, i, api) {
	if (variableType != "string[]") {
		api.markError("rawColumns", i);
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-notString-err"));
		throw new Error();
	}
}
function assertDecimalPlacesValueIsBetweenZeroAndEight(api) {
	if (api.getValue("decimalPlaces") < 0) {
		api.markError("decimalPlaces");
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-decimalPlace-lower-than-zero-err"));
		throw new Error();
	}
	else if (api.getValue("decimalPlaces") > 8) {
		api.markError("decimalPlaces");
		api.showErrorMessage(CUFCommon.t("function-groupBy-form-decimalPlace-greater-than-eight-err"));
		throw new Error();
	}
}
function setSeparatorVisibility(form) {
	if (form.getValue("aggregateFunctions").indexOf('CONCAT') > -1) {
		form.show("concatSeparator");
	} else {
		form.hide("concatSeparator");
	}
}
function setDecimalPlacesVisibility(form) {
	if (form.getValue("aggregateFunctions").indexOf('AVG') > -1) {
		form.show("decimalPlaces");
		form.setNotEmpty("decimalPlaces", true);
	} else {
		form.hide("decimalPlaces");
		form.setNotEmpty("decimalPlaces", false);
	}
}
function hasDuplicates(array) {
	var valuesSoFar = Object.create(null);
	for (var i = 0; i < array.length; ++i) {
		var value = array[i];
		if (value in valuesSoFar) {
			return true;
		}
		valuesSoFar[value] = true;
	}
	return false;
}

function addGroupVarToGroupByColumn(rowIndex, form) {
	var aggregateFunction = form.getValue("aggregateFunctions")[rowIndex];
	if (aggregateFunction && aggregateFunction.indexOf("GROUPINGVAL") > -1) {
		var variable = form.getValue("rawColumns")[rowIndex];
		var groupByColumns = form.getValue("groupByColumns");
		if (variable && groupByColumns.indexOf(variable) < 0 ) {
			groupByColumns.push(variable);
			form.addFieldToArray("groupByColumns");
			form.setValue("groupByColumns", groupByColumns);
		}
	}
}