PWE.integrationComponent.registerFormAction('set-columns', {
	apiVersion: 2,
	buildForm: function(form, options) {
		var table = form.addTable({
			tableId: "colAndFun"
		});
		table.addField("columns");
		table.addField("functions");
		form.addField("condition");
		if (options.destination == "VARIABLESET") {
			form.addField("updatingVariables");
			form.addField("updatingColumns");
			form.addField("buttonName");
			form.addField("buttonId");
			form.addField("useSelectedRow");

			var execTypes = prepareExecuteTypes(form);
			form.addCombobox({
				id: "executeTypes",
				values: execTypes,
				listeners: {
					change: function() {
						handleParameters(form.getValue("executeTypes"), form);
					}
				}
			}, form.getFieldPosition("updatingVariables"));
			handleParameters(form.getValue("executeTypes"), form);
		}
	},

	validateForm: function(api) {
		var len = api.getArraySize("columns");
		var error = false;
		for (var i = 0; i < len; i++) {
			if (api.getVariableType("columns", i) != (api.getFunctionReturnType("functions", i) + "[]")) {
				api.markError("columns", i);
				api.markError("columns", i);
				error = true;
			}
		}
		if (error) {
			api.showErrorMessage(CUFCommon.t("default.incompatible-variable-function-types"));
			return false;
		}
	}

});

function handleParameters(fullValue, form) {
	if (fullValue.indexOf("UPDATING_VARIABLES") > -1) {
		form.show("updatingVariables");
	} else {
		form.resetArray("updatingVariables");
		form.hide("updatingVariables");
	}
	if (fullValue.indexOf("UPDATING_COLUMNS") > -1) {
		form.show("updatingColumns");
	} else {
		form.resetArray("updatingColumns");
		form.hide("updatingColumns");
	}
	if (fullValue.indexOf("TABLE_BUTTON") > -1) {
		form.show("buttonName");
		form.show("buttonId");
		form.show("useSelectedRow");
		if (!form.getValue("buttonId")) {
			form.setValue("buttonId", generateDefaultButtonId());
		}
	} else {
		if (form.getValue("buttonName") != "") {
			form.setValue("buttonName", "");
		}
		form.hide("buttonName");
		if (!form.getValue("buttonId")) {
			form.setValue("buttonId", generateDefaultButtonId());
		}
		form.hide("buttonId");
		if (form.getValue("useSelectedRow")) {
			form.setValue("useSelectedRow", false);
		}
		form.hide("useSelectedRow");
	}
	if (fullValue.indexOf("ADDING_ROWS_OPTIMIZED") > -1 && fullValue.length != 1) {
		form.resetArray("executeTypes");
		form.addFieldToArray("executeTypes");
		form.setFieldValueInArray("executeTypes", 0, "ADDING_ROWS_OPTIMIZED");
	}

}
function prepareExecuteTypes(form) {
	var execTypes = [
		{ id: "UPDATING_VARIABLES", display: CUFCommon.t('action.set-variables.execute-type.updating-variables') },
		{ id: "UPDATING_COLUMNS", display: CUFCommon.t('action.set-variables.execute-type.updating-columns') },
		{ id: "ADDING_ROWS", display: CUFCommon.t('action.set-variables.execute-type.adding-rows') },
		{ id: "ADDING_ROWS_OPTIMIZED", display: CUFCommon.t('action.set-variables.execute-type.adding-rows-optimized') },
		{ id: "DELETING_ROWS", display: CUFCommon.t('action.set-variables.execute-type.deleting-rows') },
		{ id: "CONDITIONAL_EXECUTE", display: CUFCommon.t('action.set-variables.execute-type.conditional-execute') }
	];
	if (form.getValue("buttonName") != "") {
		execTypes.push({ id: "TABLE_BUTTON", display: CUFCommon.t('action.set-variables.execute-type.table-button') });
	}
	return execTypes;
}
function generateDefaultButtonId() {
	return Ext.id();
}