PWE.integrationComponent.registerApplication('custom-table-data-saver', {
	apiVersion : 2,
	buildForm : function(form, options) {
		buildCustomForm(form);
	},
	validateForm : function(api) {
		return validateCustomForm(api);
	}
});

PWE.integrationComponent.registerVariablesSetter('custom-table-data-saver', {
	apiVersion : 2,
	buildForm : function(form, options) {
		buildCustomForm(form);
	},
	validateForm : function(api) {
		return validateCustomForm(api);
	}
});

function validateCustomForm(api) {
	if (api.getArraySize("keyCols") == 1) {
		console.log("Wartość:");
		console.log(api.getValue("keyCols", true));
		if (api.getValue("keyCols", true)[0] == "") {
			api.showErrorMessage(CUFCommon
					.t("save-process-data.empty-one-element-key-cols"));
			return false;
		}
	} else if (checkEmptyStringInArray(api.getValue("keyCols", true))) {
		api.showErrorMessage(CUFCommon.t("save-process-data.empty-key-cols"));
		return false;
	}
	
	var error = false;
	if (api.getArraySize("functionArray") > 0) {
		var functionTypes = api.getFunctionReturnType('functionArray');
		for (var index = 0; index < functionTypes.length; index++) {
			if (!functionTypes[index].includes('[]')) {
				error = true;
				api.markError("functionArray", index);
			}
		}
		if (error) {
			api.showErrorMessage(CUFCommon.t("save-process-data.no-array-func"));
		}
	}
	return !error;
};

function checkEmptyStringInArray(my_arr) {
	for (var i = 0; i < my_arr.length; i++) {
		if (my_arr[i] === "")
			return true;
	}
	return false;
}

function buildCustomForm(form) {
	form.addField("database");
	CufComp.obtainDataBaseAliases("database", form);
	form.addField("dbSchema");
	form.addField("formTable");
	form.addField("convertEmptyStringToNull");
	form.addField("formColIds");
	form.addField("formVariables");

	var formColIdsSize = form.getArraySize("formColIds");
	var formVariablesSize = form.getArraySize("formVariables");
	var formColIdsValues = form.getValue("formColIds");
	form.removeField("formColIds");
	form.removeField("formVariables");
	var variableTable = form.addTable({
		id : "variableTable"
	});
	var arraysTable = form.addTable({
		id : "arraysTable"
	});
	var constantsTable = form.addTable({
		id : "constantsTable"
	});
	//
	variableTable.addField({
		id : "formColIds",
		optional : false
	});
	variableTable.addField({
		id : "formVariables",
		optional : false
	});
	arraysTable.addField({
		id : "arrayColumnsIds",
		optional : false
	});
	arraysTable.addField({
		id : "functionArray",
		optional : false
	});
	constantsTable.addField({
		id : "constantsColumnsIds",
		optional : false
	});
	constantsTable.addField({
		id : "constants",
		optional : false
	});
	constantsTable.addCombobox({
		id : "constantsTypes",
		optional : false,
		values : [ {
			id : "string",
			display : CUFCommon.t("query-param-type.text")
		}, {
			id : "integer",
			display : CUFCommon.t("query-param-type.integer")
		}, {
			id : "float",
			display : CUFCommon.t("query-param-type.float")
		}, {
			id : "date",
			display : CUFCommon.t("query-param-type.date")
		}, {
			id : "datetime",
			display : CUFCommon.t("query-param-type.date-time")
		}, {
			id : "boolean",
			display : CUFCommon.t("query-param-type.boolean")
		} ]
	});
	if (formColIdsSize > formVariablesSize) {
		var j = 0;
		for (var i = formVariablesSize; i + j < formColIdsSize; j++) {
			form.setFieldValueInArray("constantsColumnsIds", j,
					formColIdsValues[i + j]);
			variableTable.removeRow(i);
		}
	}
	form.addField("differentColumnLength");
	form.addField({
		id : "keyCols"
	});
	form.addField({
		id : "commentError",
		hidden : true
	});
	form.addField({
		id : "errorMsg",
		hidden : true
	});
	if (form.getValue("commentError")) {
		form.show("commentError");
		form.show("errorMsg");
	}
}