PWE.integrationComponent.registerApplication('organizational-unit-data', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField("symbol");
        var table = form.addTable({
        	id: "oudatatable",
        	notEmpty: true
        });
        table.addCombobox({
            id: "data",
            values: [
                { id: "USERS", display: CUFCommon.t("organizational-unit-data.users") },
                { id: "NAME", display: CUFCommon.t("organizational-unit-data.name") },
                { id: "HIGHEROUSYMBOL", display: CUFCommon.t("organizational-unit-data.higherousymbol") },
                { id: "SUBOUSYMBOL", display: CUFCommon.t("organizational-unit-data.subousymbol") },
                { id: "SUBUSERS", display: CUFCommon.t("organizational-unit-data.subusers") },
                { id: "ALLUSERS", display: CUFCommon.t("organizational-unit-data.allusers") }
            ]
        });
        table.addField("variablesToSave");
    },
    
    validateForm: function(api){
        var error = false;
        for( var i = 0; i < api.getArraySize("data"); i++){
        	if ((api.getValue("data")[i] == "NAME" || api.getValue("data")[i] == "HIGHEROUSYMBOL") 
        		&& api.getVariableType("variablesToSave", i) != "string"){
        		api.markError("variablesToSave", i);
                error = true;
        	}
        	else if (api.getVariableType("variablesToSave", i) != "string[]" 
            	&& api.getVariableType("variablesToSave", i) != "string"){
                api.markError("variablesToSave", i);
                error = true;
            }
        }
        if (error){
            api.showErrorMessage(CUFCommon.t("default.wrong-variable-type"));
            return false;
        }
    }
});