PWE.integrationComponent.registerFormAction( 'filter-rows', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addCombobox({
        	id: "logicalOperator",
        	values: [{
                id: "AND",
                display: ("AND")
            },{
                id: "OR",
                display: ("OR")
        	}]
        });
        
        var valuesCompareTable = form.addTable({
            tableId : "valuesCompareTable",
            name : CUFCommon.t("filter-rows.valuesFilter"),
            description : CUFCommon.t("filter-rows.valuesFilter.desc")
        });
        var columnsCompareTable = form.addTable({
            tableId : "columnsCompareTable",
            name : CUFCommon.t("filter-rows.columnFilter"),
            description : CUFCommon.t("filter-rows.columnFilter.desc")
        });
        valuesCompareTable.addField("columns");
        valuesCompareTable.addCombobox({
            id: "operators",
            values: [
                { id: "==", display: "==" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" },
                { id: "regexp", display: "regexp" }
            ]
        });
        valuesCompareTable.addField("values");
        columnsCompareTable.addField("columnsToCompare");
        columnsCompareTable.addCombobox({
            id: "compareOperators",
            values: [
                { id: "==", display: "==" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" },
                { id: "regexp", display: "regexp" }
            ]
        });
        columnsCompareTable.addField("columnsToCompareWith");
    },
    validateForm: function(api){
        var len = api.getArraySize("columnsToCompare");
        var error = false;
        for( var i = 0; i < len; i++){
            if (api.getVariableType("columnsToCompare", i) != api.getVariableType("columnsToCompareWith", i)){
                api.markError("columnsToCompare", i);
                api.markError("columnsToCompareWith", i);
                error = true;
            }
        }
        if (error){
            api.showErrorMessage(CUFCommon.t("default.incompatible-variable-types"));
            return false;
        }
    }
});