PWE.integrationComponent.registerApplication('detach-documents-from-process', {
    apiVersion: 2,
    buildForm: buildDetachDocumentsForm,
    validateForm: validParameters
});

PWE.integrationComponent.registerVariablesSetter('detach-documents-from-process', {
    apiVersion: 2,
    buildForm: buildDetachDocumentsForm,
    validateForm: validParameters
});

function buildDetachDocumentsForm(form) {
    form.addCombobox({
        id: 'detachDocumentsBy',
        values: [
            {id: 'FILE_IDS', display: CUFCommon.t('detach-documents-from-process.fileIds.param.name')},
            {id: 'DOCUMENT_IDS', display: CUFCommon.t('detach-documents-from-process.documentIds.param.name')}
        ],
        listeners: {
            change: function ( value ) {
                if ( value == "FILE_IDS" ) {
                    form.show('fileIds');
                    form.resetValue('documentClassName');
                    form.resetArray('documentIds');
                    form.hide('documentClassName');
                    form.hide('documentIds');
                } else {
                    form.show('documentClassName');
                    form.show('documentIds');
                    form.resetArray('fileIds');
                    form.hide('fileIds');
                }
            }
        },
        notEmpty: true
    });

    form.addField('fileIds');
    CufComp.addComboboxClassList("documentClassName", null, form);
    form.addField('documentIds');
    form.addField('removeDetachedDocumentsFromArchive');

    if (form.getValue("detachDocumentsBy") == "FILE_IDS") {
        form.hide('documentClassName');
        form.hide('documentIds');
    }
    else if (form.getValue("detachDocumentsBy") == "DOCUMENT_IDS") {
        form.hide('fileIds');
    }
    else {
        form.hide('documentClassName');
        form.hide('documentIds');
        form.hide('fileIds');
    }
}

function validParameters(api) {
    const detachDocumentsBy = api.getValue('detachDocumentsBy');
    if (detachDocumentsBy === "FILE_IDS" && api.getArraySize('fileIds') === 0)
    {
        api.markError('fileIds');
        api.showErrorMessage(CUFCommon.t("default.validation.empty-parameter"));
        return false;
    }

    if (detachDocumentsBy === "DOCUMENT_IDS")
    {
        let valid = true;
        if (api.getValue('documentClassName', true) === "")
        {
            api.markError('documentClassName');
            api.showErrorMessage(CUFCommon.t("default.validation.empty-parameter"));
            valid = false;
        }
        if (api.getArraySize('documentIds') === 0)
        {
            api.markError('documentIds');
            api.showErrorMessage(CUFCommon.t("default.validation.empty-parameter"));
            valid = false;
        }
        return valid;
    }
    return true;
}