var remote = {
  url: "api/datasources",
  fields: [
    {
      name: "id",
      type: "string"
    },
    {
      name: "name",
      type: "string"
    }
  ],
  remoteSort: true
};

window.DataSource = {
  Operations: {
    CREATE: "create",
    READ: "read",
    UPDATE: "update",
    DELETE: "delete",
    ALL: ""
  },

  buildDataSourceSelectionCombobox: function(
    form,
    operation,
    datasourceParamId,
    datasourcesParamId
  ) {
    if (operation) {
      remote.url = remote.url.substring(0, 15) + "?operations=" + operation;
    }

    form.addCombobox({
      id: datasourceParamId,
      remote: remote,
      valueField: "id",
      displayField: "name",
      listeners: {
        change: function(value) {
          jQuery.ajax({
            url: Suncode.getAbsolutePath("api/datasources/" + value),
            error: function() {
              form.resetArray(datasourcesParamId);
              form.enable(datasourcesParamId);
              form.show(datasourcesParamId);
            },
            success: function() {
              form.hide(datasourcesParamId);
              form.resetArray(datasourcesParamId);
              form.addFieldToArray(datasourcesParamId);
              form.setValue(datasourcesParamId, value);
              form.disable(datasourcesParamId);
            }
          });
        }
      }
    });
  },

  buildParametersForDatachooser: function(form, params) {
    form.addCombobox({
      id: params.datasourcesParamId,
      remote: remote,
      valueField: "id",
      displayField: "name",
      listeners: {
        change: function() {
          form.hide("inputParameters");

          var datasources = form.getValue(params.datasourcesParamId);
          inputParameters = [];
          outputParameters = [];

          var promisesArray = getPromisesForDatachooser(
            form,
            datasources,
            params,
            inputParametersTable
          );

          jQuery.when.apply(jQuery, promisesArray).then(function () {
            if (arguments[1] == "success") {
              rebuildParameters(form, inputParametersTable, {
                params: inputParameters,
                paramsId: params.datasourceInputParametersId,
                paramsName: "datasourceInputParametersName"
              });

              renderParameters(form, inputParameters, outputParameters, true);
            }
          });
        }
      }
    });

    var inputParametersTable = addParametersTable(
      form,
      "inputParameters",
      params.datasourceInputParametersId,
      params.datasourceInputParametersValue
    );

    form.hide(params.datasourcesParamId);
    form.hide("inputParameters");

    fillParameters(
      form,
      true,
      params.datasourcesParamId,
      params.datasourceInputParametersId
    );

    if (form.hasVariableValue(params.datasourceParamId)) {
      form.show(params.datasourcesParamId);
    }

    form.setNotEmpty(params.datasourcesParamId, true);
  },

  buildParametersForNonDatachooser: function(form, params) {
    form.addCombobox({
      id: params.datasourcesParamId,
      remote: remote,
      valueField: "id",
      displayField: "name",
      listeners: {
        change: function() {
          form.hide("inputParameters");
          form.hide("outputParameters");

          inputParameters = [];
          outputParameters = [];
          var datasources = form.getValue(params.datasourcesParamId);

          var promisesArray = getPromisesForNonDatachooser(
            form,
            datasources,
            params,
            {
              inputParametersTable: inputParametersTable,
              outputParametersTable: outputParametersTable
            }
          );

          jQuery.when.apply(jQuery, promisesArray).then(function () {
            if (arguments[1] == "success") {
              rebuildParameters(form, inputParametersTable, {
                params: inputParameters,
                paramsId: params.datasourceInputParametersId,
                paramsName: "datasourceInputParametersName"
              });

              rebuildParameters(form, outputParametersTable, {
                params: outputParameters,
                paramsId: params.datasourceOutputParametersId,
                paramsName: "datasourceOutputParametersName"
              });

              renderParameters(form, inputParameters, outputParameters, false);
            }
          });
        }
      }
    });

    var inputParametersTable = addParametersTable(
      form,
      "inputParameters",
      params.datasourceInputParametersId,
      params.datasourceInputParametersValue
    );

    var outputParametersTable = addParametersTable(
      form,
      "outputParameters",
      params.datasourceOutputParametersId,
      params.datasourceOutputParametersValue
    );

    form.hide(params.datasourcesParamId);
    form.hide("inputParameters");
    form.hide("outputParameters");

    fillParameters(
      form,
      true,
      params.datasourcesParamId,
      params.datasourceInputParametersId,
      inputParametersTable
    );

    fillParameters(
      form,
      false,
      params.datasourcesParamId,
      params.datasourceOutputParametersId,
      outputParametersTable
    );

    if (form.hasVariableValue(params.datasourceParamId)) {
      form.show(params.datasourcesParamId);
    }

    form.setNotEmpty(params.datasourcesParamId, true);
  }
};

function getPromisesForDatachooser(
  form,
  datasources,
  params,
  inputParametersTable
) {
  var promisesArray = [];

  jQuery.each(datasources, function(_index, datasource) {
    var xhr = jQuery.ajax({
      url: Suncode.getAbsolutePath("api/datasources/" + datasource),
      success: function(data) {
        if (data.inputParameters.length > 0) {
          data.inputParameters.forEach(function(param) {
          	if (inputParameters.find(function(iparam) {
          	  return param.id === iparam.id;
          	}) === undefined) {          		
          	  inputParameters.push(param);
          	}
          });
        }
        
        if (data.outputParameters.length > 0) {
          data.outputParameters.forEach(function(param) {
          	if (outputParameters.find(function(oparam) {
          	  return param.id === oparam.id;
          	}) === undefined) {          		
          	  outputParameters.push(param);
          	}
          });
        }
      }
    });
    promisesArray.push(xhr);
  });

  return promisesArray;
}

function getPromisesForNonDatachooser(form, datasources, params, tables) {
  var promisesArray = [];

  jQuery.each(datasources, function(_index, datasource) {
    var xhr = jQuery.ajax({
      url: Suncode.getAbsolutePath("api/datasources/" + datasource),
      success: function(data) {
        if (data.inputParameters.length > 0) {
          data.inputParameters.forEach(function(param) {
          	if (inputParameters.find(function(iparam) {
          	  return param.id === iparam.id;
          	}) === undefined) {          		
          	  inputParameters.push(param);
          	}
          });
        }
        
        if (data.outputParameters.length > 0) {
          data.outputParameters.forEach(function(param) {
          	if (outputParameters.find(function(oparam) {
          	  return param.id === oparam.id;
          	}) === undefined) {
          	  outputParameters.push(param);
          	}
          });
        }
      }
    });
    promisesArray.push(xhr);
  });

  return promisesArray;
}

function rebuildParameters(form, table, ds) {
  if (ds.params && ds.params.length > 0) {
    let addedParameters = new Array();
    jQuery.each(ds.params, function (_index, parameter) {
      if (!addedParameters.includes(parameter.id)) {
        let parametersId = form.getValue(ds.paramsId);
        if (parametersId[_index] === undefined) {
          table.addRow([
            {
              id: ds.paramsId,
              value: parameter.id
            },
            {
              id: ds.paramsName,
              value: parameter.name
            }
          ]);
        } else {
          form.setFieldValueInArray(ds.paramsId, _index, parameter.id);
          form.setFieldValueInArray(ds.paramsName, _index, parameter.name);
        }
        addedParameters.push(parameter.id);
      }
    });
  }
  const paramSize = form.getValue(ds.paramsId).length - 1;
  for (let j = paramSize; j >= ds.params.length; j--) {
    table.removeRow(j);
  }
}

function renderParameters(form, inputParameters, outputParameters, isDatachooser) {
  if (inputParameters.length > 0) {
    form.show("inputParameters");
  } else {
    form.hide("inputParameters");
  }
  if (outputParameters.length > 0) {
    if (isDatachooser) {
      const actualDatachooserMapping = form.getAllDataChooserMappings();
      form.resetDataChooserMappings();
      for (let i = 0; i < outputParameters.length; i++) {
        form.addDataChooserMapping({
          id: outputParameters[i].id,
          name: outputParameters[i].name,
          variableId: actualDatachooserMapping[i] === undefined ? "" : actualDatachooserMapping[i].variableId,
          readOnly: "id"
        });
      }
    }
    form.show("outputParameters");
  } else {
    form.hide("outputParameters");
  }
}

function addParametersTable(form, tableId, parametersId, parametersValue) {
  var table = form.addTable({
    id: tableId,
    blocked: true
  });
  table.addField({ id: parametersId, readOnly: true, hidden: true });
  table.addField({
    id: "datasource" + capitalize(tableId) + "Name",
    name: CUFCommon.t("datasource." + tableId + "Name.name"),
    description: CUFCommon.t("datasource." + tableId + "Name.desc"),
    type: "string",
    readOnly: true
  });
  table.addField({
    id: parametersValue,
    optional: parametersValue === "datasourceOutputParametersValue"
  });
  return table;
}

function capitalize(s) {
  if (typeof s !== "string") return "";
  return s.charAt(0).toUpperCase() + s.slice(1);
}

function fillParameters(form, inputParams, datasourcesParamId, paramsId, parametersTable) {
  var hasParameters = false;
  var datasources = form.getValue(datasourcesParamId);
  if (datasources) {
    var promisesArray = [];
    jQuery.each(datasources, function(_index, datasource) {
      var xhr = jQuery.ajax({
        url: Suncode.getAbsolutePath("api/datasources/" + datasource),
        success: function(data) {
          if ((data.inputParameters && data.inputParameters.length > 0 && inputParams) || 
        		  (data.outputParameters && data.outputParameters.length > 0 && !inputParams)) {
            var ids = form.getValue(paramsId);
            var parameters = [];
            if (inputParams) {
              parameters = data.inputParameters;
            } else {
              parameters = data.outputParameters;
            }
            if (parameters.length > 0) {
              hasParameters = true;
            }
			var removedRowsCounter = 0;
			ids.forEach(function(id, index) {
	 		  if (parameters.filter(function(param) { return id === param.id }).length <= 0) {
                parametersTable._applyArrayFields({}, index - removedRowsCounter);
				parametersTable.removeRow(index - removedRowsCounter);
				removedRowsCounter++;
	          }
            });
			ids = form.getValue(paramsId);
            jQuery.each(parameters, function(_index, parameter) {
              var idIndex = ids.indexOf(parameter.id);
              if (idIndex < 0) {
	            parametersTable.addRow([{id: "datasource" + (inputParams ? "Input" : "Output") + "ParametersId", value: parameter.id}, { id: "datasource" + (inputParams ? "Input" : "Output") + "ParametersName", value: parameter.name }]);
              } else {
	            form.setFieldValueInArray("datasource" + (inputParams ? "Input" : "Output") + "ParametersName", idIndex, parameter.name);
              }
            }); 
          }
        }
      });
      promisesArray.push(xhr);
    });

    jQuery.when.apply(jQuery, promisesArray).then(function() {
      if (hasParameters) {
        if (inputParams) {
          form.show("inputParameters");
        } else {
          form.show("outputParameters");
        }
      }
    });
  }
}

function scrollToBottom() {
  var formDiv = jQuery(".x-window-body").last();
  formDiv.scrollTop(formDiv.height());
}
