PWE.integrationComponent.registerValidator("datasource-validator", {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField({id: "acceptResults", hidden: true});
        form.addCombobox({
            name: CUFCommon.t("datasource-validator.accept-result-combobox"),
            id: "acceptResultCombobox",
            value: form.getValue("acceptResults") ? "true" : "false",
            values: [
                {
                    id: "true",
                    display: CUFCommon.t("datasource-validator.accept-result-true.name"),
                    description: CUFCommon.t(
                        "datasource-validator.accept-result-true.desc"
                    )
                },
                {
                    id: "false",
                    display: CUFCommon.t("datasource-validator.accept-result-false.name"),
                    description: CUFCommon.t(
                        "datasource-validator.accept-result-false.desc"
                    )
                }
            ],
            listeners: {
                change: function (value) {
                    if (value == "true") {
                        form.setValue("acceptResults", true);
                    } else {
                        form.setValue("acceptResults", false);
                    }
                }
            }
        });

        DataSource.buildDataSourceSelectionCombobox(
            form,
            DataSource.Operations.READ,
            "datasource",
            "datasources"
        );

        DataSource.buildParametersForDatachooser(form, {
            datasourceParamId: "datasource",
            datasourcesParamId: "datasources",
            datasourceInputParametersId: "datasourceInputParametersId",
            datasourceInputParametersValue: "datasourceInputParametersValue"
        });

        form.addCombobox({
            id: 'messageType',
            values: [
                {
                    id: 'oldglobal',
                    display: CUFCommon.t('datasource-validator.messageType.value.oldGlobal.name'),
                    description: CUFCommon.t('datasource-validator.messageType.value.oldGlobal.desc'),
                },
                {
                    id: 'global',
                    display: CUFCommon.t('function-based-validator.global')
                },
                {
                    id: 'local',
                    display: CUFCommon.t('function-based-validator.local')
                },
                {
                    id: 'localandglobal',
                    display: CUFCommon.t('function-based-validator.localandglobal')
                }
            ],
            listeners: {
                change: function (value) {
                    if (value == 'global') {
                        handleGlobal();
                    } else if (value == 'local') {
                        handleLocal();
                    } else if (value == 'oldglobal') {
                        handleOldGlobal();
                    } else {
                        handleLocalAndGlobal();
                    }
                }
            }
        });

        form.addField({
            id: 'confirmation',
            hidden: true
        });

        form.addField({
            id: 'globalErrorMessage',
            hidden: true
        });

        let table = form.addTable({
            id: 'customTable',
            hidden: true
        });

        table.addField('errorVariables');
        table.addField('errorVariablesMessages');

        let msgType = form.getValue('messageType');
        if (msgType == 'local') {
            handleLocal();
        } else if (msgType == 'localandglobal') {
            handleLocalAndGlobal();
        } else if (msgType == 'global') {
            handleGlobal();
        } else {
            table.clear();
            form.hide('customTable');
            form.hide('globalErrorMessage');
            if (form.getValue('messageType').length != 0 && form.getValue('messageType') != 'oldglobal') {
                form.setValue('messageType', 'oldglobal');
            }
            form.setNotEmpty('errorVariables', false);
            form.setNotEmpty('errorVariablesMessages', false);
        }

        function handleGlobal() {
            table.clear();
            form.hide('customTable');
            form.show('globalErrorMessage');
            form.setNotEmpty('errorVariables', false);
            form.setNotEmpty('errorVariablesMessages', false);
            form.show("confirmation");
        }

        function handleLocalAndGlobal() {
            form.show('customTable');
            form.show('globalErrorMessage');
            form.setNotEmpty('errorVariables', true);
            form.setNotEmpty('errorVariablesMessages', true);
            form.hide("confirmation");
            form.setValue("confirmation", false);
        }

        function handleLocal() {
            form.show('customTable');
            form.hide('globalErrorMessage');
            form.setValue('globalErrorMessage', '');
            form.setNotEmpty('errorVariables', true);
            form.setNotEmpty('errorVariablesMessages', true);
            form.hide("confirmation");
            form.setValue("confirmation", false);
        }

        function handleOldGlobal() {
            table.clear();
            form.hide('customTable');
            form.hide('globalErrorMessage');
            form.setValue('globalErrorMessage', '');
            form.setNotEmpty('errorVariables', false);
            form.setNotEmpty('errorVariablesMessages', false);
            form.hide("confirmation");
            form.setValue("confirmation", false);
        }
    }
});
