PW.FormActions.create('style-variables', {
    formInit: function () {
        this.variables = this.get("variables");
    },
    variableInit: function (variable)
    {
        this.variables = variable;
    },
    enable: function () {
        this.setStyle();
    },
    disable: function () {
        if (this.get('restoreDefaultStyle')) {
            this.restoreDefaultStyle();
        }
    },
    restoreDefaultStyle: function () {
        PW.each(this.variables, function (variable) {
            if (this.get("styleDestination") === "LABEL") {
                variable.setDefaultLabelStyle();
            } else if (this.get("styleDestination") === "FIELD") {
                variable.setDefaultFieldStyle();
            } else {
                variable.setDefaultLabelStyle();
                variable.setDefaultFieldStyle();
            }
        }, this);
    },
    setStyle: function () {
        const style = this.prepareStyle();
        PW.each(this.variables, function (variable) {
            if (this.get("styleDestination") === "LABEL") {
                variable.setLabelStyle(style);
            } else if (this.get("styleDestination") === "FIELD") {
                variable.setFieldStyle(style);
            } else {
                variable.setLabelStyle(style);
                variable.setFieldStyle(style);
            }
        }, this);
    },
    prepareStyle: function () {
        if (this.get("stylingType") === "BASIC") {
            const style = {
                "color": this.get("fontColor"),
                "background-color": this.get("backgroundColor"),
                "font-size": this.get("fontSize") + "px",
                "font-weight": this.get("bold") ? "bold" : "normal",
                "font-style": this.get("italic") ? "italic" : "normal"
            };

            if (this.get("useSystemThemeFontColor")) {
                delete style["color"];
            }

            if (this.get("useSystemThemeBackgroundColor")) {
                delete style["background-color"];
            }

            return style;
        } else if (this.get("stylingType") === "ADVANCED") {
            const style = "{" + this.get("style") + "}";
            return JSON.parse(style);
        }
        Logger.error("Illegal argument 'stylingType' value: " + this.get("stylingType"));
        return {};
    }
});