/**
 * Implementation of ManageDocuments
 */
PW.FormActions.create('manage-documents', {
    
	init : function() {
		this.documentActions = this.get("documentActions");
		this.showIndexes = this.get("showIndexes");
		this.showAdvancedConfig = this.get("showAdvancedConfig");
		this.checkRights = this.get("checkRights");
		this.autoSelectFirst = this.get("autoSelectFirst");
		this.documentClassIdList =this.get("documentClassIdList") ? this.get("documentClassIdList") : undefined;
		this.documentClassNameList = this.get("documentClassNameList");
		this.callback = new Function("doc", this.get("callback"));
	},
	
	buttonInit : function(button) {
		this.button = button;
	},
	
	defaultActions : {
        button: function(button) {
			if (MobileService.isMobile()) {
				MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
				return;
			}

            this.manageDocuments();
        }
    },
    
    enable : function() {
    	if (!this.button) {
			if (MobileService.isMobile()) {
				MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
				return;
			}

			this.manageDocuments();
		}
    },
    manageDocuments : function() {
    	if (this.showAdvancedConfig) {
    		var cfg = {
    				checkRights : this.checkRights,
    				documentActions : this.documentActions,
    				documentActionsCfg:{
    					attach:{
    						showIndexes : this.showIndexes,
    						checkRights : this.checkRights,
    						autoSelectFirst : this.autoSelectFirst,
    						documentClassIdList : this.documentClassIdList,
    						documentClassNameList : this.documentClassNameList,
    						callback : this.callback
    					}
    				}
    		}
    		CUF.DocumentService.showProcessDocumentManagement(cfg);
    	} else {
    		CUF.DocumentService.showProcessDocumentManagement();
    	}
   }
});
