/**
 * Filter rows implementation. 
 */
PW.FormActions.create('filter-rows', {
    
	variableSetInit : function (table){
	    this.table = table;
	},
    
    enable: function(){
        this.filterRows();
    },
    
    disable: function(){
        this.unfilterRows();
    },

	filterRows: function() {
		var filters = this.get("logicalOperator") === "OR"
			? this.buildOrFilters()
			: this.buildAndFilters();

		this.filterId = this.table.filter( filters );
	},

	buildAndFilters: function() {
		var filters = {};
		PW.each( this.get("columns"), function( column, i ) {
			if( column ) {
				if( !filters[column.getId()] ) {
					filters[column.getId()] = [];
				}
				filters[column.getId()].push(this.buildFilter( column, i, false ));
			}
		}, this);
		PW.each( this.get("columnsToCompare"), function( column, i ) {
			if( column ) {
				if( !filters[column.getId()] ) {
					filters[column.getId()] = [];
				}
				filters[column.getId()].push(this.buildFilter( column, i, true ));
			}
		}, this);
		return [filters];
	},

	buildOrFilters: function() {
		var filters = [];
		PW.each( this.get( "columns" ), function( column, i ) {
			if( column ) {
				var filter = {};
				filter[column.getId()] = this.buildFilter( column, i, false );
				filters.push(filter);
			}
		}, this);
		PW.each( this.get("columnsToCompare"), function( column, i ) {
			if( column ) {
				var filter = {};
				filter[column.getId()] = this.buildFilter( column, i, true );
				filters.push(filter);
			}
		}, this);
		return filters;
	},

	buildFilter: function( column, i, columnCompare ) {
		var value = columnCompare
			? this.get("columnsToCompareWith")[i].getId()
			: this.getCastedValue(i, column.getType());
		return {
			value: value,
			type: columnCompare ? this.get("compareOperators")[i] : this.get("operators")[i],
			columnCompare: columnCompare
		}
	},

    getCastedValue: function(i, type) {
    	if (type.is("string[]")){
    		return this.get("values")[i];
    	}
    	else if (type.is("integer[]") || type.is("float[]")){
    		return Number(this.get("values")[i]);
    	}
    	else if (type.is("date[]")){
    		return new Date(this.get("values")[i])
    	}
    	Logger.error("Unsupported column type in filtering rows! Check if all variables are array type!");
    },
    
    unfilterRows: function() {
        if(this.filterId != undefined && this.filterId != null){
            this.table.clearFilters(this.filterId);
            this.filterId = null;
        }
    }
});