/**
 * Export to excel implementation.
 */
PW.FormActions.create('export-to-excel', {
	variableSetInit : function(table) {
		this.table = table;
		var me = this;
		this.buttonId = CUFCommon.generateDefaultButtonId();

		if (MobileService.isMobile()) {
			return;
		}

		ServiceFactory.getVariableSetService().addBottomToolbarButton(table.grid, {
			text : this.get("buttonName"),
			itemId : this.buttonId,
			iconCls : 'silk-page-white-excel',
			disabled : true,
			handler : function() {
				me.exportToExcel();
			}
		});
	},
	
	dtButtonInit: function (button) {
    	this.table = button.getVariableSet();
    },

	enable : function() {
		if (MobileService.isMobile()) {
			return;
		}

		if(this.target.type == 'VARIABLESET'){
			ServiceFactory.getVariableSetService().enableBottomToolbarButton(
					this.table.grid, this.buttonId);
		}
		
	},

	disable : function() {
		if (MobileService.isMobile()) {
			return;
		}

		if(this.target.type == 'VARIABLESET'){
			ServiceFactory.getVariableSetService().disableBottomToolbarButton(
					this.table.grid, this.buttonId);
		}
	},
	
	defaultActions: {
    	dtButton: function(button){
			if (MobileService.isMobile()) {
				MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
				return;
			}

    		this.exportToExcel();
        }
    },

	exportToExcel : function() {
		var cfg = this.getCfg(); 
		CUF.table.core.TableService.exportDataToExcel(this.table.grid, cfg);
	},

	getCfg : function() {
		return {
			filters: this.getFilteredData(),
			extension : "xlsx",
			includeHiddenColumns : this.get("exportColumnTypes") != "VISIBLE" || this.get("columnsToExport").length > 0,
			title : this.get("fileName"),
			columnsToExport : this.getColumnsToExport()
		};
	},
	
	getFilteredData : function(){
        var filters = [];
        var columns = this.get("columns");
        var filterValues = this.get("filterValues");
        var filterTypes = this.get("filterTypes"); 
        for(var i = 0; i < columns.length; i++){
            var filter = {
                colName: columns[i].getId(),
                value: filterValues[i],
                type: filterTypes[i]
            };
            filters.push(filter);
        }
        return filters;
    },

	getColumnsToExport : function() {
		var columns = [];
		PW.each(this.get("columnsToExport"), function(column) {
			columns.push(column.getId());
		}, this);
		return columns.length > 0 ? columns : null;
	}
});