PW.FormActions.create("execute-datasource-action", {
    init: function () {
        this.datasource = this.getRaw("datasource");
        this.datasourceInputParametersId = this.getRaw("datasourceInputParametersId");
        this.datasourceInputParametersValue = this.getRaw("datasourceInputParametersValue");
        this.datasourceOutputParametersId = this.getRaw("datasourceOutputParametersId");
        this.datasourceOutputParametersValue = this.getRaw("datasourceOutputParametersValue");
        this.manyValuesHandler = this.getRaw("manyValuesHandler");
        this.overwriteData = this.getRaw("overwriteData");
        this.datasourceShowMessage = this.getRaw("datasourceShowMessage");
        this.datasourceMessage = this.getRaw("datasourceMessage");
        this.wayOfAdding = this.getRaw("wayOfAdding");
    },

    defaultActions: {
        button: function (_button) {
            this.executeDatasource();
        },
        dtButton: function (button) {
            this.executeDatasource();
        },
    },

    enable: function () {
        if (this.target.type === "FORM") {
            this.executeDatasource();
        }
    },

    executeDatasource: function () {
        try {
            PW.ui.showLoading();
            this.executeWithInputParameters();
        } catch (err) {
            PW.ui.Message.error(CUFCommon.t("datasource.execution.error") + " " + err.message);
            console.error(err);
        }
    },

    executeWithInputParameters: function () {
        var datasource = this.datasource.get();
        var datasourceInputParametersId = this.datasourceInputParametersId.get();
        var datasourceInputParametersValue = this.datasourceInputParametersValue.value.map(function (param) {
            var value = param.evaluate();
            return Array.isArray(value) ? value.join(";") : value;
        });

        if (datasourceInputParametersId.length !== datasourceInputParametersValue.length) {
            throw new Error("Input parameters lists has different sizes!");
        }

        var url = PW.getAbsolutePath("plugin/com.suncode-cuf-components/datasources/execute");
        jQuery.ajax({
            data : JSON.stringify({
                datasourceId: datasource,
                datasourceInputParametersId: datasourceInputParametersId,
                datasourceInputParametersValue: datasourceInputParametersValue,
            }),
            dataType: 'json',
            headers : {
                'Accept' : 'application/json',
                'Content-Type' : 'application/json'
            },
            type: "POST",
            url: url,
            success: function (data) {
                try {
                    this.handleData(data);
                    if (this.datasourceShowMessage.get()) {
                        if (this.datasourceMessage.get()) {
                            PW.ui.Message.success(this.datasourceMessage.get());
                        } else {
                            PW.ui.Message.success(CUFCommon.t("datasource.executed"));
                        }
                    }
                } catch (err) {
                    PW.ui.Message.error(CUFCommon.t("datasource.execution.error") + " " + err.message);
                    console.error(err);
                }
                PW.ui.hideLoading();
            }.bind(this),
            error: function (jqXHR) {
                PW.ui.hideLoading();
                PW.ui.Message.error(CUFCommon.t("datasource.execution.error") + " " + url + " " + jqXHR.status);
            },
        });
    },

    handleData: function (data) {
        if (data.length <= 0) {
            if (this.wayOfAdding.get() == "OVERWRITE_ALL_COLUMNS_OR_CLEAR_IF_NO_RESULTS") {
                this.datasourceOutputParametersValue.get()[0].variableSet.clear();
            } else {
                console.info("Empty datasource execution result - nothing to set.");
                return;
            }
        } else {
            this.mapVariables(data);
        }

        if (this.get("saveFormAfterActionExecution")) {
            FormService.save();
        }
    },

    mapVariables: function (data) {
        var datasourceOutputParametersId = this.datasourceOutputParametersId.get();
        var datasourceOutputParametersValue = this.datasourceOutputParametersValue.get();
        var parametersList = this.getParametersList(data, datasourceOutputParametersId);
        var currentPositions = this.storeCurrentPositions(datasourceOutputParametersValue);
        var manyValuesHandler = this.manyValuesHandler.get();
        var overwriteData = this.overwriteData.get();
        let wayOfAdding = this.wayOfAdding.get();

        if( wayOfAdding === 'UNSET' ) {
            wayOfAdding = overwriteData ? 'OVERWRITE_ALL_COLUMNS' : 'ADD';
        }

        for (let i = 0; i < datasourceOutputParametersValue.length; i++) {
            if (datasourceOutputParametersValue[i].isStandaloneVariable) {
                if (parametersList[i].length === 1) {
                    this.handleFirst(datasourceOutputParametersValue[i], parametersList[i]);
                } else {
                    switch (manyValuesHandler) {
                        case "first":
                            this.handleFirst(datasourceOutputParametersValue[i], parametersList[i]);
                            break;
                        case "unique":
                            this.handleUnique(datasourceOutputParametersValue[i], parametersList[i]);
                            break;
                        case "block":
                            throw new Error(
                                "Datasource is returning more than one set of values. Cannot map it to variable that is not of an array type!"
                            );
                    }
                }
            } else {
                if ( ( wayOfAdding === 'OVERWRITE_ALL_COLUMNS' || wayOfAdding === 'OVERWRITE_ALL_COLUMNS_OR_CLEAR_IF_NO_RESULTS' ) && i === 0) {
                    datasourceOutputParametersValue[i].variableSet.clear();
                }

                if ( wayOfAdding === 'OVERWRITE_ALL_COLUMNS' || wayOfAdding === 'OVERWRITE_UPDATED_COLUMNS' || wayOfAdding === 'OVERWRITE_ALL_COLUMNS_OR_CLEAR_IF_NO_RESULTS' ) {
                    datasourceOutputParametersValue[i].setValue(parametersList[i]);
                }
                else {
                    datasourceOutputParametersValue[i].setValue(currentPositions[i].concat(parametersList[i]));
                }
            }
        }
    },

    getParametersList: function (data, ids) {
        var parametersList = this.prepareList(ids);
        for (var i = 0; i < ids.length; i++) {
            for (var j = 0; j < data.length; j++) {
                parametersList[i].push(data[j][ids[i]] ? data[j][ids[i]].toString() : "");
            }
        }
        return parametersList;
    },

    prepareList: function (ids) {
        var parametersList = [];
        for (var i = 0; i < ids.length; i++) {
            parametersList.push([]);
        }
        return parametersList;
    },

    storeCurrentPositions: function (values) {
        let currentPositions = [];
        for (let i = 0; i < values.length; i++) {
            if ('variableSet' in values[i]) {
                let variableSet = VariableSetService.get(values[i].variableSet.id)
                if (VariableSetService.getRowsCount(variableSet) === 0) {
                    currentPositions.push([]);
                } else {
                    let variableSetData = JSON.parse(VariableSetService.getVariableSetData(variableSet));
                    currentPositions.push(variableSetData.map(data => data[values[i].id]));
                }
            } else {
                currentPositions.push(values[i] ? values[i].getValue(i) : "");
            }
        }
        return currentPositions;
    },

    handleFirst: function (variable, value) {
        variable.setValue(value[0]);
    },

    handleUnique: function (variable, value) {
        var uniqueValues = value.filter(function (value, index, self) {
            return self.indexOf(value) === index;
        });
        variable.setValue(uniqueValues.join(";"));
    },
});