PW.FormActions.create('conditional-row-delete', {

	variableSetInit: function(table) {
		this.conditionFn = this.get("condition");
		this.table = table;
		if (!this.conditionFn || this.conditionFn.getReturnType() !== PW.BooleanType) {
			Logger.error('Action conditional-row-delete needs boolean function in condition parameter.');
			return;
		}
		let me = this;
		if (me.get("buttonId") && me.get("buttonName")) {
			this.buttonId = me.get("buttonId") ? me.get("buttonId") : "conditionalDeleteButton";
			VariableSetService.addBottomToolbarButton(table.grid, {
				text: me.get("buttonName"),
				itemId: me.buttonId,
				iconCls: 'silk-delete',
				handler: function() {
					me.conditionalDelete();
				}
			});
			VariableSetService.disableBottomToolbarButton(this.table.grid, this.buttonId);
		}
	},

	dtButtonInit: function(button) {
		this.table = button.getVariableSet();
	},

	defaultActions: {
		dtButton: function() {
			this.conditionalDelete();
		}
	},

	enable: function() {
		let me = this;
		if (me.get("buttonId")) {
			VariableSetService.enableBottomToolbarButton(this.table.grid, this.buttonId);
		}
		else {
			if (me.get("executeTypes").indexOf("CONDITIONAL_EXECUTE") > -1 && this.target.type !== "DT_BUTTON") {
				me.conditionalDelete();
				me.conditionFn.on('change', me.conditionalDelete, me);
			}
			if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
				PW.each(me.get("updatingVariables"), function(variable) {
					variable.on("change", me.conditionalDelete, me);
				});
			}
		}
	},

	disable: function() {
		let me = this;
		if (me.get("buttonId")) {
			VariableSetService.disableBottomToolbarButton(this.table.grid, this.buttonId);
		}
		if (me.get("executeTypes").indexOf("CONDITIONAL_EXECUTE") > -1) {
			me.conditionalDelete();
			me.conditionFn.off('change', me.conditionalDelete, me);
		}
		if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
			PW.each(me.get("updatingVariables"), function(variable) {
				variable.off("change", me.conditionalDelete, me);
			});
		}
	},

	conditionalDelete: function() {
		let rowsLength = VariableSetService.getRowsCount(this.table.grid);
		let store = this.table.grid.getStore();
		let recordsToDelete = [];
		for (let index = rowsLength - 1; index >= 0; index--) {
			this.setContextVariable("currentRow", index);
			if (this.get("condition").call()) {
				recordsToDelete.push(store.getAt(index));
			}
		}
		VariableSetService.deleteRecords(this.table.grid, recordsToDelete);

	}
});