var variableService = ServiceFactory.getVariableService(),
	variableSetService = ServiceFactory.getVariableSetService();

/**
 * After Change action implementation. 
 */
PW.FormActions.create('clear-variables-action', {
    
    enable: function(){
        if(this.target.type == 'FORM'){
            this.clearVariables();
        }
    },
    
    defaultActions: {
    	button: function(button){
    		this.clearVariables();
        },
    },
    
    clearVariables: function(){
    	var variables = this.get("variables");
    	if (devMode){
    		Logger.debug("Action clear-variables-action will now clear variables...");
    	}
    	PW.each(variables, function(variable){
			var varId = variable.getId();
			var type = variable.getType();
			if (type.isArray){
				var tableId = variable.getVariableSet().getId();
				this.clearTableVariable(varId, tableId);
			} 
			else{
				this.clearVariable(varId);
			}
		}, this);
    },
    
    clearVariable: function(varId){
    	variableService.setValue(varId, "");
    },
    
    clearTableVariable: function(varId, tableId){
    	var table = variableSetService.get(tableId);
    	variableSetService.setValue(table, null, varId, "");
    }
});