/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.variable.Variable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class PredefinedQueryUtils {
    public static String[] convertTypedParameter(String typedParam) {
        String[] parts = PredefinedQueryUtils.getParameterPartsForMark(typedParam, "'");
        if (parts.length > 0) {
            return parts;
        }
        parts = PredefinedQueryUtils.getParameterPartsForMark(typedParam, "\"");
        return parts.length > 0 ? parts : PredefinedQueryUtils.getParameterPartsForNoMarks(typedParam);
    }

    private static String[] getParameterPartsForNoMarks(String typedParam) {
        String type = PredefinedQueryUtils.getTypeFromLastLetters(typedParam);
        if (type == null) {
            return new String[]{typedParam, "string"};
        }
        return new String[]{typedParam.substring(0, typedParam.lastIndexOf(type) - 1), type};
    }

    private static String[] getParameterPartsForMark(String typedParam, String mark) {
        int firstIndexOfMark = typedParam.indexOf(mark);
        int lastIndexOfMark = typedParam.lastIndexOf(mark);
        if (firstIndexOfMark == 0 && firstIndexOfMark < lastIndexOfMark) {
            if (lastIndexOfMark == typedParam.length() - 1) {
                return new String[]{typedParam.substring(firstIndexOfMark + 1, lastIndexOfMark), "string"};
            }
            String type = PredefinedQueryUtils.getTypeFromLastLetters(typedParam);
            if (type == null) {
                return new String[]{typedParam, "string"};
            }
            return new String[]{typedParam.substring(firstIndexOfMark + 1, lastIndexOfMark), type};
        }
        return new String[0];
    }

    private static String getTypeFromLastLetters(String typedParam) {
        if (typedParam.endsWith(" float")) {
            return "float";
        }
        if (typedParam.endsWith(" integer")) {
            return "integer";
        }
        if (typedParam.endsWith(" string")) {
            return "string";
        }
        if (typedParam.endsWith(" date")) {
            return "date";
        }
        if (typedParam.endsWith(" datetime")) {
            return "datetime";
        }
        if (typedParam.endsWith(" boolean")) {
            return "boolean";
        }
        return null;
    }

    public static Object[] getParamsValuesFromActivityContext(ActivityContextMap activityContext, String[] queryParamsIds) {
        Object[] paramsValues = new Object[queryParamsIds.length];
        for (int i = 0; i < queryParamsIds.length; ++i) {
            String[] parts = PredefinedQueryUtils.convertTypedParameter(queryParamsIds[i]);
            String valueOrVariableId = parts[0];
            if (StringUtils.isNotEmpty((CharSequence)valueOrVariableId) && valueOrVariableId.charAt(0) == '@') {
                Variable variable = activityContext.getVariable(valueOrVariableId.substring(1));
                if (variable == null) {
                    throw new IllegalArgumentException("Variable with given id: '" + valueOrVariableId + "' was not found");
                }
                paramsValues[i] = variable.getValue();
                continue;
            }
            Assert.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Malformed typed parameter: " + queryParamsIds[i]));
            String type = parts[1];
            paramsValues[i] = DataConverter.stringToObject(valueOrVariableId, type);
        }
        return paramsValues;
    }
}

