/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.setters;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.user.UserDataService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@VariableSetter
public class UsernamesToFullnamesSetter {
    private static final Logger log = LoggerFactory.getLogger(UsernamesToFullnamesSetter.class);
    @Autowired
    private UserDataService userService;

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("usernames-fullnames-setter")).name("application.user.usernames-to-fullnames.name")).description("setter.user.usernames-to-fullnames.desc")).category(new Category[]{Categories.USER})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}replace-semicolon-delimited-usernames-with-full-names-application")).icon((Icon)SilkIconPack.USER_SUIT)).parameter().id("sourceVar").name("application.user.usernames-to-fullnames.source_param.name").description("application.user.usernames-to-fullnames.source_param.desc").type((Type)Types.VARIABLE).create()).parameter().id("targetVar").name("application.user.usernames-to-fullnames.target_param.name").description("application.user.usernames-to-fullnames.target_param.desc").type((Type)Types.VARIABLE).create();
    }

    public void set(final @Param Variable sourceVar, final @Param Variable targetVar) {
        if (sourceVar.isArray()) {
            TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    String[] sourceArray = (String[])sourceVar.getValue();
                    String[] arr = (String[])Arrays.stream(sourceArray).map(value -> UsernamesToFullnamesSetter.this.getFullNameOrEmpty((String)value)).toArray(String[]::new);
                    targetVar.setValue((Object)arr);
                }
            });
        } else {
            String sourceValue = (String)sourceVar.getValue();
            targetVar.setValue((Object)this.getFullNameOrEmpty(sourceValue));
        }
    }

    public String getFullNameOrEmpty(String userName) {
        try {
            return this.userService.getFullNames(userName);
        }
        catch (Exception e) {
            log.error("Cannot execute setter.", (Throwable)e);
            return null;
        }
    }
}

