/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.tablestore.TableStore;
import com.suncode.cuf.common.tablestore.utils.TableStoreUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.FormGrid;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.joda.time.LocalDate;

@Application
@VariableSetter
public class TableRemoveAllRecords {
    private final ActivityFinder activityFinder = FinderFactory.getActivityFinder();
    private final FormService formService = ServiceFactory.getFormService();

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("table-remove-all-records-app")).name("application.table-remove-all-records-app.name")).description("application.table-remove-all-records-app.desc")).category(new Category[]{Categories.TABLESTORE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}clear-tablestore-application")).icon((Icon)SilkIconPack.TABLE_ROW_DELETE)).parameter().id("tableId").name("application.table-remove-all-records-app.tableId.name").description("application.table-remove-all-records-app.tableId.desc").type((Type)Types.STRING).optional().create()).parameter().id("activityDefId").name("application.table-remove-all-records-app.activityDefId.name").description("application.table-remove-all-records-app.activityDefId.desc").type((Type)Types.STRING).optional().create()).parameter().id("tableStore").name("application.table-remove-all-records-app.tableStore.name").description("application.table-remove-all-records-app.tableStore.desc").type((Type)Types.STRING).create()).parameter().id("wipeData").name("application.table-remove-all-records-app.wipeData.name").description("application.table-remove-all-records-app.wipeData.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create();
    }

    public void execute(ActivityContextMap activityContextMap, @Param String tableId, @Param String activityDefId, @Param Variable tableStore, @Param boolean wipeData) {
        this.handle(activityContextMap, tableId, activityDefId, tableStore, wipeData);
    }

    public void set(ActivityContextMap activityContextMap, @Param String tableId, @Param String activityDefId, @Param Variable tableStore, @Param boolean wipeData) {
        this.handle(activityContextMap, tableId, activityDefId, tableStore, wipeData);
    }

    public void handle(ActivityContextMap activityContextMap, String tableId, String activityDefId, Variable tableStore, boolean wipeData) {
        tableStore.setValue((Object)new TableStore().toJson());
        if (wipeData) {
            this.clearTable(activityContextMap, tableId, activityDefId);
        }
    }

    private void clearTable(ActivityContextMap activityContextMap, String tableId, String activityDefId) {
        Activity tablesActivity = this.activityFinder.findByProcessId(activityContextMap.getProcessId(), new String[0]).stream().filter(activity -> activity.getActivityDefinitionId().equals(activityDefId)).findFirst().orElseThrow(() -> new RuntimeException("Activity with id: '" + activityDefId + "' not found in process!"));
        List formElements = this.formService.getForm(activityContextMap.getProcessId(), tablesActivity.getActivityId()).getElements();
        FormGrid grid = TableStoreUtils.getTableById(formElements, tableId, tablesActivity.getActivityDefinitionId());
        grid.getFields().stream().forEach(field -> {
            Variable variableToClear = (Variable)activityContextMap.getVariables().get(field.getVariableId());
            switch (variableToClear.getType().name()) {
                case "date[]": {
                    variableToClear.setValue((Object)new LocalDate[0]);
                    break;
                }
                case "float[]": {
                    variableToClear.setValue((Object)new Double[0]);
                    break;
                }
                case "integer[]": {
                    variableToClear.setValue((Object)new Integer[0]);
                    break;
                }
                case "string[]": {
                    variableToClear.setValue((Object)new String[0]);
                    break;
                }
                default: {
                    throw new RuntimeException("TableStore contains wrong type!");
                }
            }
        });
    }
}

