/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.tablestore.TableStore;
import com.suncode.cuf.common.tablestore.utils.TableStoreUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.FormGrid;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Application
@VariableSetter
public class TableGetRecords {
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private FormService formService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("table-get-records-app")).name("application.table-get-records-app.name")).description("application.table-get-records-app.desc")).category(new Category[]{Categories.TABLESTORE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}get-tablestore-application")).icon((Icon)SilkIconPack.APPLICATION_GET)).parameter().id("tableId").name("application.table-get-records-app.tableId.name").description("application.table-get-records-app.tableId.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("application.table-get-records-app.activityDefId.name").description("application.table-get-records-app.activityDefId.desc").type((Type)Types.STRING).create()).parameter().id("tableStore").name("application.table-get-records-app.tableStore.name").description("application.table-get-records-app.tableStore.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(ActivityContextMap activityContextMap, @Param String tableId, @Param String activityDefId, @Param Variable tableStore) {
        this.handle(activityContextMap, tableId, activityDefId, tableStore);
    }

    public void set(ActivityContextMap activityContextMap, @Param String tableId, @Param String activityDefId, @Param Variable tableStore) {
        this.handle(activityContextMap, tableId, activityDefId, tableStore);
    }

    @Transactional
    public void handle(ActivityContextMap activityContextMap, String tableId, String activityDefId, Variable tableStoreParam) {
        Activity tablesActivity = this.activityFinder.findByProcessId(activityContextMap.getProcessId(), new String[0]).stream().filter(activity -> activity.getActivityDefinitionId().equals(activityDefId)).findFirst().orElseThrow(() -> new RuntimeException("Activity with id: '" + activityDefId + "' not found in process!"));
        List formElements = this.formService.getForm(activityContextMap.getProcessId(), tablesActivity.getActivityId()).getElements();
        FormGrid grid = TableStoreUtils.getTableById(formElements, tableId, tablesActivity.getActivityDefinitionId());
        Map processVariables = activityContextMap.getVariables();
        List formFields = grid.getFields();
        Variable[] variables = (Variable[])formFields.stream().map(field -> (Variable)processVariables.get(field.getVariableId())).toArray(Variable[]::new);
        TableStore tableStore = new TableStore(variables);
        tableStoreParam.setValue((Object)tableStore.toJson());
    }
}

