/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.cuf.common.tablestore.TableStoreDataType;
import com.suncode.cuf.common.tablestore.TableStoreDeserializer;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.variable.Variable;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class TableStore {
    private static final Logger log = LoggerFactory.getLogger(TableStore.class);
    private static final transient Gson GSON = new GsonBuilder().registerTypeAdapter(TableStore.class, (Object)new TableStoreDeserializer()).serializeNulls().create();
    private final Map<String, String> variableType;
    private List<Map<String, Object>> data;

    public TableStore() {
        this.variableType = new HashMap<String, String>();
        this.data = new ArrayList<Map<String, Object>>();
    }

    public TableStore(Variable[] variables) {
        this.variableType = new HashMap<String, String>();
        this.data = new ArrayList<Map<String, Object>>();
        this.create(variables);
    }

    public TableStore(Variable[] variables, Map<String, String> keyMapping) {
        this.variableType = new HashMap<String, String>();
        this.data = new ArrayList<Map<String, Object>>();
        this.create(variables, keyMapping);
    }

    public static TableStore fromJson(String tableStoreStr) {
        return (TableStore)GSON.fromJson(tableStoreStr, TableStore.class);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    private void create(Variable[] variables) {
        Assert.isTrue((boolean)Arrays.stream(variables).allMatch(Variable::isArray), (String)"Variables passed into TableStore.create function must be arrays!");
        if (variables.length <= 0) {
            return;
        }
        for (Variable variable2 : variables) {
            String variableTypeName = variable2.getType().name();
            this.variableType.put(variable2.getId(), variableTypeName.endsWith("[]") ? variableTypeName.substring(0, variableTypeName.length() - 2) : variableTypeName);
        }
        if (Arrays.stream(variables).allMatch(variable -> CommonUtils.isEmptyArray((Object[])variable.getValue(), variable.getType()))) {
            return;
        }
        int colLength = this.getMaxDataLength(variables);
        for (int i = 0; i < colLength; ++i) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (Variable variable3 : variables) {
                Object value;
                String id = variable3.getId();
                Object[] valueList = (Object[])variable3.getValue();
                Object object = value = valueList.length > i ? valueList[i] : null;
                if (value == null) {
                    record.put(id, this.getDefaultValue(this.variableType.get(id)));
                    continue;
                }
                if (value instanceof LocalDate) {
                    record.put(id, value.toString());
                    continue;
                }
                record.put(id, value);
            }
            this.data.add(record);
        }
    }

    private void create(Variable[] variables, Map<String, String> keyMapping) {
        Assert.isTrue((boolean)Arrays.stream(variables).allMatch(Variable::isArray), (String)"Variables passed into TableStore.create function must be arrays!");
        if (variables.length <= 0) {
            return;
        }
        Variable[] variableArray = variables;
        int n = variableArray.length;
        for (int i = 0; i < n; ++i) {
            String variableTypeName;
            Variable variable2;
            this.variableType.put(keyMapping.get(variable2.getId()), (variableTypeName = (variable2 = variableArray[i]).getType().name()).endsWith("[]") ? variableTypeName.substring(0, variableTypeName.length() - 2) : variableTypeName);
        }
        if (Arrays.stream(variables).allMatch(variable -> CommonUtils.isEmptyArray((Object[])variable.getValue(), variable.getType()))) {
            return;
        }
        int colLength = this.getMaxDataLength(variables);
        for (int i = 0; i < colLength; ++i) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (Variable variable3 : variables) {
                Object value;
                String id = variable3.getId();
                Object[] valueList = (Object[])variable3.getValue();
                Object object = value = valueList.length > i ? valueList[i] : null;
                if (value == null) {
                    record.put(keyMapping.get(id), this.getDefaultValue(this.variableType.get(id)));
                    continue;
                }
                if (value instanceof LocalDate) {
                    record.put(keyMapping.get(id), value.toString());
                    continue;
                }
                record.put(keyMapping.get(id), value);
            }
            this.data.add(record);
        }
    }

    public int getLength() {
        return this.data.size();
    }

    public String[] getKeys() {
        if (this.data.size() <= 0) {
            return new String[0];
        }
        return this.variableType.keySet().toArray(new String[0]);
    }

    public String joinField(String fieldId, String separator) {
        if (this.data.size() <= 0) {
            return "";
        }
        List valuesToJoin = StreamSupport.stream(this.data.spliterator(), false).map(record -> record.get(fieldId) != null ? record.get(fieldId).toString() : "").collect(Collectors.toList());
        return String.join((CharSequence)separator, valuesToJoin);
    }

    public void addRecord(String[] fieldIds, String[] values) {
        Assert.isTrue((boolean)this.variableType.keySet().containsAll(Arrays.asList(fieldIds)), (String)("Keys of record to add (" + Arrays.asList(fieldIds) + ") are not applicable with TableStore keys (" + this.variableType.keySet() + ")!"));
        HashMap newRecord = new HashMap();
        this.variableType.keySet().stream().forEach(id -> this.addTypedPropertyToTheRecord(this.variableType, newRecord, (String)id, fieldIds, values));
        this.data.add(newRecord);
    }

    private int getMaxDataLength(Variable[] variables) {
        return Arrays.stream(variables).map(v -> ((Object[])v.getValue()).length).max(Integer::compare).orElse(0);
    }

    private void addTypedPropertyToTheRecord(Map<String, String> variableType, Map<String, Object> newRecord, String id, String[] fieldIds, String[] values) {
        int i = Arrays.asList(fieldIds).indexOf(id);
        switch (variableType.get(id)) {
            case "date": {
                newRecord.put(id, i > -1 && StringUtils.isNotBlank((CharSequence)values[i]) ? LocalDate.parse((String)values[i]).toString("yyyy-MM-dd") : null);
                break;
            }
            case "float": {
                newRecord.put(id, i > -1 && StringUtils.isNotBlank((CharSequence)values[i]) ? Double.parseDouble(values[i]) : 0.0);
                break;
            }
            case "integer": {
                newRecord.put(id, i > -1 && StringUtils.isNotBlank((CharSequence)values[i]) ? Long.parseLong(values[i]) : 0L);
                break;
            }
            case "string": {
                newRecord.put(id, i > -1 && StringUtils.isNotBlank((CharSequence)values[i]) ? values[i] : "");
                break;
            }
            default: {
                throw new RuntimeException("Field " + id + " is of wrong type!");
            }
        }
    }

    public void addRecords(TableStore tableStoreToAdd) {
        if (tableStoreToAdd.getVariableType().keySet().stream().anyMatch(id -> this.variableType.get(id) == null || !this.variableType.get(id).equals(tableStoreToAdd.getVariableType().get(id)))) {
            throw new IllegalArgumentException("TableStores variable types mismatch!");
        }
        tableStoreToAdd.getData().stream().forEach(recordToAdd -> {
            HashMap newRecord = new HashMap();
            this.variableType.keySet().stream().forEach(id -> newRecord.put(id, recordToAdd.get(id) != null ? recordToAdd.get(id) : this.getDefaultValue(this.variableType.get(id))));
            this.data.add(newRecord);
        });
    }

    private Object getDefaultValue(String type) {
        switch (type) {
            case "integer": 
            case "float": {
                return 0;
            }
            case "date": {
                return null;
            }
            case "string": {
                return "";
            }
        }
        throw new IllegalArgumentException("Incorrect type '" + type + "'!");
    }

    public void filter(String logicalOperator, String[] fieldIds, String[] operators, String[] values) {
        Assert.isTrue((fieldIds.length == operators.length && fieldIds.length == values.length ? 1 : 0) != 0, (String)"Field IDs, operators and values arrays are not equal in size!");
        Assert.isTrue((boolean)this.variableType.keySet().containsAll(Arrays.asList(fieldIds)), (String)("Keys of record to filter (" + Arrays.asList(fieldIds) + ") are not applicable with TableStore keys (" + this.variableType.keySet() + ")!"));
        List<Map<String, Object>> filteredTableStoreData = StreamSupport.stream(this.data.spliterator(), false).filter(record -> {
            ArrayList conditionalResults = new ArrayList();
            IntStream.range(0, fieldIds.length).forEach(i -> {
                String id = fieldIds[i];
                String value = values[i];
                switch (this.variableType.get(id)) {
                    case "date": {
                        String dateFromRecord = record.get(id).toString();
                        conditionalResults.add(this.compareDateValues(LocalDate.parse((String)dateFromRecord), LocalDate.parse((String)value), operators[i], i));
                        break;
                    }
                    case "float": {
                        conditionalResults.add(this.compareDoubleValues((Double)record.get(id), Double.parseDouble(value), operators[i], i));
                        break;
                    }
                    case "integer": {
                        conditionalResults.add(this.compareLongValues((Long)record.get(id), Long.parseLong(value), operators[i], i));
                        break;
                    }
                    case "string": {
                        conditionalResults.add(this.compareStringValues(record.get(id).toString(), value, operators[i], i));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Field " + id + " is of wrong type!");
                    }
                }
            });
            if (logicalOperator.equalsIgnoreCase("and")) {
                return conditionalResults.stream().allMatch(condition -> condition);
            }
            return conditionalResults.stream().anyMatch(condition -> condition);
        }).collect(Collectors.toList());
        this.setData(filteredTableStoreData);
    }

    private boolean compareDateValues(LocalDate obj1, LocalDate obj2, String operator, int i) {
        switch (operator) {
            case "=": {
                return obj1.equals((Object)obj2);
            }
            case "!=": {
                return !obj1.equals((Object)obj2);
            }
            case "<": {
                return obj1.isBefore((ReadablePartial)obj2);
            }
            case "<=": {
                return obj1.isBefore((ReadablePartial)obj2) || obj1 == obj2;
            }
            case ">": {
                return obj1.isAfter((ReadablePartial)obj2);
            }
            case ">=": {
                return obj1.isAfter((ReadablePartial)obj2) || obj1 == obj2;
            }
        }
        throw new IllegalArgumentException("Invalid operator in row: #" + i + ".");
    }

    private boolean compareDoubleValues(Double obj1, Double obj2, String operator, int i) {
        switch (operator) {
            case "=": {
                return obj1.doubleValue() == obj2.doubleValue();
            }
            case "!=": {
                return obj1.doubleValue() != obj2.doubleValue();
            }
            case "<": {
                return obj1 < obj2;
            }
            case "<=": {
                return obj1 <= obj2;
            }
            case ">": {
                return obj1 > obj2;
            }
            case ">=": {
                return obj1 >= obj2;
            }
        }
        throw new IllegalArgumentException("Invalid operator in row: #" + i + ".");
    }

    private boolean compareLongValues(Long obj1, Long obj2, String operator, int i) {
        switch (operator) {
            case "=": {
                return obj1.longValue() == obj2.longValue();
            }
            case "!=": {
                return obj1.longValue() != obj2.longValue();
            }
            case "<": {
                return obj1 < obj2;
            }
            case "<=": {
                return obj1 <= obj2;
            }
            case ">": {
                return obj1 > obj2;
            }
            case ">=": {
                return obj1 >= obj2;
            }
        }
        throw new IllegalArgumentException("Invalid operator in row: #" + i + ".");
    }

    private boolean compareStringValues(String obj1, String obj2, String operator, int i) {
        switch (operator) {
            case "=": {
                return obj1.equals(obj2);
            }
            case "!=": {
                return !obj1.equals(obj2);
            }
            case "regex": {
                Pattern pattern = Pattern.compile(obj2, 2);
                Matcher matcher = pattern.matcher(obj1);
                return matcher.find();
            }
        }
        throw new IllegalArgumentException("Invalid operator in row: #" + i + ".");
    }

    public Object getItem(String fieldId, int elementNr) {
        return this.data.get(elementNr).get(fieldId);
    }

    public void setItems(int elementNr, String[] fieldIds, String[] values) {
        Assert.isTrue((fieldIds.length == values.length ? 1 : 0) != 0, (String)"Field IDs and values arrays are not equal in size!");
        Map<String, Object> recordToChange = this.data.get(elementNr);
        if (recordToChange == null) {
            throw new RuntimeException("TableStore contains " + this.data.size() + " rows. Cannot modify #" + (elementNr + 1) + " row!");
        }
        IntStream.range(0, fieldIds.length).forEach(i -> {
            String id = fieldIds[i];
            if (!recordToChange.containsKey(id)) {
                throw new IllegalArgumentException("Invalid TableStore key: '" + id + "'!");
            }
            recordToChange.put(id, this.getProperTypedValue(this.variableType.get(id), values[i]));
        });
    }

    public void setItems(int recordNumber, Map<String, FunctionCall> fieldIdsAndValues) {
        Map<String, Object> recordToChange = this.data.get(recordNumber);
        fieldIdsAndValues.forEach((id, value) -> {
            if (!recordToChange.containsKey(id)) {
                throw new IllegalArgumentException("Invalid TableStore key: '" + id + "'!");
            }
            String newValue = (String)value.call();
            recordToChange.put((String)id, this.getProperTypedValue(this.variableType.get(id), newValue));
            log.debug("Column with id '" + id + "' was set with new value '" + newValue + "' in record index " + recordNumber + " in TableStore");
        });
    }

    private Object getProperTypedValue(String type, String value) {
        switch (type) {
            case "string": {
                return value;
            }
            case "date": {
                return LocalDate.parse((String)value).toString("yyyy-MM-dd");
            }
            case "integer": {
                return Long.parseLong(value);
            }
            case "float": {
                return Double.parseDouble(value);
            }
        }
        throw new IllegalArgumentException("Invalid type '" + type + "'!");
    }

    public void addColumn(String columnId, TableStoreDataType dataType) {
        this.appendVariableType(columnId, dataType);
        this.insertDefaultValuesToNewColumn(dataType, columnId);
    }

    public void addColumn(String columnId, TableStoreDataType dataType, Object[] initialValues) {
        this.appendVariableType(columnId, dataType);
        this.insertInitialValuesToNewColumn(initialValues, columnId);
    }

    public void deleteRecord(int rowNumber) {
        Assert.isTrue((this.getData().size() > rowNumber ? 1 : 0) != 0, (String)"Incorrect row number!");
        this.getData().remove(rowNumber);
    }

    private void appendVariableType(String columnId, TableStoreDataType dataType) {
        Assert.isTrue((!this.variableType.containsKey(columnId) ? 1 : 0) != 0, (String)("TableStore already contains column with id: '" + columnId + "'!"));
        this.variableType.put(columnId, dataType.toString());
    }

    private void insertInitialValuesToNewColumn(Object[] arrayOfInitialValues, String columnId) {
        Assert.isTrue((arrayOfInitialValues.length == this.data.size() ? 1 : 0) != 0, (String)"Array of initial values has different size than existing data in TableStore!");
        for (int i = 0; i < this.data.size(); ++i) {
            Object value = arrayOfInitialValues[i];
            if (value instanceof LocalDate) {
                this.data.get(i).put(columnId, ((LocalDate)value).toString("yyyy-MM-dd"));
                continue;
            }
            this.data.get(i).put(columnId, value);
        }
    }

    private void insertDefaultValuesToNewColumn(TableStoreDataType dataType, String columnId) {
        switch (dataType) {
            case DATE: {
                this.insertDefaultValue(columnId, Types.DATE.defaultValue());
                break;
            }
            case FLOAT: {
                this.insertDefaultValue(columnId, Types.FLOAT.defaultValue());
                break;
            }
            case INTEGER: {
                this.insertDefaultValue(columnId, Types.INTEGER.defaultValue());
                break;
            }
            case STRING: {
                this.insertDefaultValue(columnId, Types.STRING.defaultValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Added column has wrong type: '" + dataType + "'!");
            }
        }
    }

    private void insertDefaultValue(String columnId, Object value) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).put(columnId, value);
        }
    }

    public void sort(String columnId, String sortDirection) {
        Assert.isTrue((boolean)this.variableType.containsKey(columnId), (String)("Column id to sort (" + columnId + ") is not applicable with TableStore keys (" + this.variableType.keySet() + ")!"));
        this.data.sort((o1, o2) -> {
            switch (this.variableType.get(columnId)) {
                case "string": {
                    return this.compare(o1.get(columnId).toString(), o2.get(columnId).toString(), sortDirection);
                }
                case "integer": {
                    return this.compare((Long)o1.get(columnId), (Long)o2.get(columnId), sortDirection);
                }
                case "float": {
                    return this.compare((Double)o1.get(columnId), (Double)o2.get(columnId), sortDirection);
                }
                case "date": {
                    return this.compare(LocalDate.parse((String)o1.get(columnId).toString()), LocalDate.parse((String)o2.get(columnId).toString()), sortDirection);
                }
            }
            throw new RuntimeException("Field " + columnId + " is of wrong type!");
        });
    }

    private <T extends Comparable<T>> int compare(T object1, T object2, String sortDirection) {
        switch (sortDirection) {
            case "ASC": {
                return object1.compareTo(object2);
            }
            case "DESC": {
                return object2.compareTo(object1);
            }
        }
        throw new IllegalArgumentException("Invalid sort direction '" + sortDirection + "'!");
    }

    @ConstructorProperties(value={"variableType", "data"})
    public TableStore(Map<String, String> variableType, List<Map<String, Object>> data) {
        this.variableType = variableType;
        this.data = data;
    }

    public Map<String, String> getVariableType() {
        return this.variableType;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
    }
}

