/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.table.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.xpdl.table.Table;
import com.suncode.pwfl.xpdl.table.XpdlTableService;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class ClearTableApp {
    private static final Logger log = LoggerFactory.getLogger(ClearTableApp.class);
    @Autowired
    private XpdlTableService xpdlTableService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("clear-table-app")).name("application.clear-table-app.name")).description("application.clear-table-app.desc")).icon((Icon)DivanteIcon.TABLE)).category(new Category[]{Categories.TABLE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}clear-table-application")).parameter().id("tableId").name("application.clear-table-app.param.tableId.name").description("application.clear-table-app.param.tableId.desc").type((Type)Types.STRING).create();
    }

    public void execute(ActivityContextMap context, @Param String tableId) {
        this.clearTable(context, tableId);
    }

    public void set(ActivityContextMap context, @Param String tableId) {
        this.clearTable(context, tableId);
    }

    private void clearTable(ActivityContextMap activityContextMap, String tableId) {
        Table table = this.xpdlTableService.getGlobalTableByProcessId(tableId, activityContextMap.getProcessId());
        table.getColumns().forEach(column -> {
            Variable variableToClear = (Variable)activityContextMap.getVariables().get(column.getVarId());
            switch (variableToClear.getType().name()) {
                case "date[]": {
                    variableToClear.setValue((Object)new LocalDate[0]);
                    break;
                }
                case "float[]": {
                    variableToClear.setValue((Object)new Double[0]);
                    break;
                }
                case "integer[]": {
                    variableToClear.setValue((Object)new Integer[0]);
                    break;
                }
                case "string[]": {
                    variableToClear.setValue((Object)new String[0]);
                    break;
                }
                default: {
                    log.error("Table contains unexpected column type \"" + variableToClear.getType().name() + "\" for variable \"" + variableToClear.getName() + "\"");
                }
            }
        });
    }
}

