/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.storagedata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class StorageData {
    public static final String STORAGE_DATA_NAME = "StorageData";
    private final ObjectMapper mapper = new ObjectMapper();
    private Map<String, Object> data = new HashMap<String, Object>();

    public StorageData(Variable formalParameter) {
        String formalParameterValue = this.getStorageDataAsString(formalParameter);
        this.createData(formalParameterValue);
    }

    public StorageData(String formalParameterValue) {
        String modifiedFormalParameterValue = this.validateJson(formalParameterValue);
        this.createData(modifiedFormalParameterValue);
    }

    public void addParameter(String name, Object value) {
        if (!this.parameterNameExists(name)) {
            this.data.put(name, value);
        } else {
            this.data.replace(name, value);
        }
    }

    public boolean parameterNameExists(String paramName) {
        return this.data.keySet().stream().anyMatch(e -> e.equals(paramName));
    }

    public void removeParameters(String[] names) {
        this.data = this.data.entrySet().stream().filter(e -> Arrays.stream(names).noneMatch(i -> i.equals(e.getKey()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    public void removeAllParameters() {
        this.data.clear();
    }

    private void createData(String formalParameterValue) {
        this.data = this.convertJsonStringToMap(formalParameterValue);
    }

    private String getStorageDataAsString(Variable formalParameter) {
        String formalParameterValue = (String)formalParameter.getValueAsBasicType();
        return this.validateJson(formalParameterValue);
    }

    private String validateJson(String formalParameterValue) {
        String modifiedValue = formalParameterValue;
        if (!this.isVariableValidJsonObject(formalParameterValue)) {
            JsonObject jsonObject = new JsonObject();
            modifiedValue = jsonObject.toString();
        }
        return modifiedValue;
    }

    private boolean isVariableValidJsonObject(String formalParameterText) {
        try {
            new JsonParser().parse(formalParameterText).getAsJsonObject();
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            return false;
        }
        return true;
    }

    private Map<String, Object> convertJsonStringToMap(String formalParameterJson) {
        return (Map)this.mapper.readValue(formalParameterJson, HashMap.class);
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

