/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.general.validators.parameters.ValidateUsingFunctionParameters;
import com.suncode.cuf.common.utils.LogUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.Confirmation;
import com.suncode.pwfl.workflow.form.validator.error.ConfirmationMessageType;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Validator
public class ValidateUsingFunction {
    private static final Logger log = LoggerFactory.getLogger(ValidateUsingFunction.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("function-based-validator")).name("validator.function.name")).description("validator.function.desc")).category(new Category[]{Categories.GENERAL})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}validation-based-on-the-logical-result-returned-by-a-function")).icon((Icon)SilkIconPack.SCRIPT)).parameter().id("function").name("validator.function.function_param.name").description("validator.function.function_param.desc").type((Type)Types.FUNCTION).create()).parameter().id("messageType").name("validator.function.messageType.name").description("validator.function.messageType.desc").defaultValue((Object)"global").type((Type)Types.STRING).create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("alert").name("validator.function.alert_global.name").description("validator.alert_param.desc_default").type((Type)Types.STRING).optional().create()).parameter().id("tableOn").name("validator.function.tableOn.name").description("validator.function.tableOn.desc").type((Type)Types.STRING).defaultValue((Object)"noTable").optional().create()).parameter().id("everyRowAvailable").name("validator.function.everyRowAvailable.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("anyRowAvailable").name("validator.function.anyRowAvailable.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("tableLength").name("validator.function.tableLength.name").description("validator.function.tableLength.desc").type((Type)Types.INTEGER).optional().create()).parameter().id("variable").name("validator.function.variable.name").description("validator.function.variable.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("variableMessage").name("validator.function.variableMessange.name").description("validator.function.variableMessange.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("messageWindowTitle").name("validator.function.messageWindowTitle.name").description("validator.function.messageWindowTitle.desc").type((Type)Types.STRING).optional().create()).parameter().id("acceptButtonName").name("validator.function.acceptButtonName.name").description("validator.function.acceptButtonName.desc").type((Type)Types.STRING).optional().create()).parameter().id("cancelButtonName").name("validator.function.cancelButtonName.name").description("validator.function.cancelButtonName.desc").type((Type)Types.STRING).optional().create()).parameter().id("messageIconType").name("validator.function.messageIconType.name").description("validator.function.messageIconType.desc").type((Type)Types.STRING).optional().create()).contextVariable().id("everyRow").name("validator.function.everyRow.name").type((Type)Types.INTEGER).hidden().create().contextVariable().id("anyRow").name("validator.function.anyRow.name").type((Type)Types.INTEGER).hidden().create().contextVariable().id("rowId").name("validator.function.rowId.name").type((Type)Types.INTEGER).create();
    }

    public void validate(Parameters parameters, ContextVariables contextVariables, ValidationErrors errors, ValidationContext context, Translator translator) {
        ValidateUsingFunctionParameters validatorParameters = new ValidateUsingFunctionParameters(parameters);
        try {
            Type type = validatorParameters.getFunction().getReturnType();
            Assert.isTrue((type == Types.BOOLEAN ? 1 : 0) != 0, (String)"Wrong type of returned function value.");
            this.valid(validatorParameters, contextVariables, errors, translator, context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void valid(ValidateUsingFunctionParameters parameters, ContextVariables contextVariables, ValidationErrors errors, Translator translator, ValidationContext context) {
        ArrayList<Integer> rowNotValid = new ArrayList<Integer>();
        try {
            LogUtils logUtils = new LogUtils((WorkflowContext)context);
            if (parameters.getEveryRowAvailable().booleanValue() && !this.everyRowValidate(parameters.getTableLength(), parameters.getFunction(), contextVariables, rowNotValid, logUtils)) {
                this.chooseMsg(parameters, translator, errors, rowNotValid);
            } else if (parameters.getAnyRowAvailable().booleanValue() && !this.anyRowValidate(parameters.getTableLength(), parameters.getFunction(), contextVariables, rowNotValid, logUtils)) {
                this.chooseMsg(parameters, translator, errors, rowNotValid);
            } else if (!parameters.getEveryRowAvailable().booleanValue() && !parameters.getAnyRowAvailable().booleanValue() && Boolean.FALSE.equals(parameters.getFunction().call())) {
                this.chooseMsg(parameters, translator, errors, rowNotValid);
            }
        }
        catch (Exception e) {
            if (this.checkArrayIndexOutOfBoundsException(e)) {
                errors.add(translator.getMessage("validator.array_length_error") + " : " + parameters.getTableLength());
            }
            throw new RuntimeException(e);
        }
    }

    private boolean checkArrayIndexOutOfBoundsException(Throwable e) {
        while (e != null) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private boolean anyRowValidate(Integer tableLength, FunctionCall function, ContextVariables contextVariables, List<Integer> rowNotValid, LogUtils logUtils) {
        if (tableLength == null) {
            throw new IllegalArgumentException("Nie podano d\u0142ugo\u015bci tabeli");
        }
        if (tableLength <= 0) {
            return true;
        }
        boolean flag = false;
        for (int i = 0; i < tableLength; ++i) {
            contextVariables.set("rowId", (Object)i);
            contextVariables.set("anyRow", (Object)i);
            logUtils.disableLoggingIfLimitReached(i);
            logUtils.debug("anyRowValidate function call");
            if (Boolean.TRUE.equals(function.call())) {
                flag = true;
                continue;
            }
            rowNotValid.add(i);
        }
        return flag;
    }

    private boolean everyRowValidate(Integer tableLength, FunctionCall function, ContextVariables contextVariables, List<Integer> rowNotValid, LogUtils logUtils) {
        if (tableLength == null) {
            throw new IllegalArgumentException("Nie podano d\u0142ugo\u015bci tabeli");
        }
        if (tableLength <= 0) {
            return true;
        }
        boolean flag = true;
        for (int i = 0; i < tableLength; ++i) {
            contextVariables.set("rowId", (Object)i);
            contextVariables.set("everyRow", (Object)i);
            logUtils.disableLoggingIfLimitReached(i);
            logUtils.debug("everyRowValidate function call");
            if (!Boolean.FALSE.equals(function.call())) continue;
            flag = false;
            rowNotValid.add(i);
        }
        return flag;
    }

    private void globalMsg(Boolean confirmation, String alert, String messageWindowTitle, String acceptButtonName, String cancelButtonName, String messageIconType, ValidationErrors errors, Translator translator) {
        if (Boolean.TRUE.equals(confirmation)) {
            Confirmation confirmationWindow = new Confirmation(alert, StringUtils.isNotBlank((CharSequence)messageWindowTitle) ? messageWindowTitle : translator.getMessage("validator.title_default"));
            if (StringUtils.isNotBlank((CharSequence)acceptButtonName)) {
                confirmationWindow.setYesText(acceptButtonName);
            }
            if (StringUtils.isNotBlank((CharSequence)cancelButtonName)) {
                confirmationWindow.setNoText(cancelButtonName);
            }
            confirmationWindow.setMessageType(StringUtils.isNotBlank((CharSequence)messageIconType) ? ConfirmationMessageType.valueOf((String)messageIconType) : ConfirmationMessageType.QUESTION);
            errors.addConfirmation(confirmationWindow);
        } else {
            this.globalMsgWithoutConfirmation(alert, errors);
        }
    }

    private void globalMsgWithoutConfirmation(String alert, ValidationErrors errors) {
        errors.add(alert);
    }

    private void localMsg(ValidationErrors errors, Variable[] var, String[] msg, List<Integer> rowNotValid) {
        Assert.isTrue((var.length == msg.length ? 1 : 0) != 0, (String)"the table of variables and messages are not the same length");
        for (int i = 0; i < var.length; ++i) {
            if (StringUtils.isBlank((CharSequence)msg[i])) continue;
            if (var[i].isArray()) {
                if (rowNotValid.isEmpty()) {
                    errors.add("[" + var[i].getName() + "] " + msg[i]);
                    continue;
                }
                for (Integer rowIndex : rowNotValid) {
                    errors.add(msg[i], var[i].getId(), rowIndex.intValue());
                }
                continue;
            }
            errors.add(msg[i], var[i].getId());
        }
    }

    private void chooseMsg(ValidateUsingFunctionParameters parameters, Translator translator, ValidationErrors errors, List<Integer> rowNotValid) {
        switch (parameters.getMessageType().toLowerCase()) {
            case "global": {
                this.globalMsg(parameters.getConfirmation(), parameters.getAlert(), parameters.getMessageWindowTitle(), parameters.getAcceptButtonName(), parameters.getCancelButtonName(), parameters.getMessageIconType(), errors, translator);
                break;
            }
            case "local": {
                this.localMsg(errors, parameters.getVariable(), parameters.getVariableMessage(), rowNotValid);
                break;
            }
            case "localandglobal": {
                this.globalMsgWithoutConfirmation(parameters.getAlert(), errors);
                this.localMsg(errors, parameters.getVariable(), parameters.getVariableMessage(), rowNotValid);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect messageType parameter value: " + parameters.getMessageType());
            }
        }
    }
}

