/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.cuf.common.db.utils.builders.IndexFiltersBuilder;
import com.suncode.cuf.common.utils.AlertInterpreter;
import com.suncode.cuf.common.utils.handlers.ApplicationCommentHandler;
import com.suncode.cuf.common.utils.handlers.ErrorHandlersExecution;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.search.GroupIndexFilter;
import com.suncode.pwfl.workflow.process.search.IndexFilter;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.exception.SQLGrammarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CheckUniqueness {
    private static final Logger log = LoggerFactory.getLogger(CheckUniqueness.class);
    @Autowired
    private CommentService commentService;
    @Autowired
    private ProcessService processService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("uniqueness-app")).name("application.general.uniqueness.name")).description("application.general.uniqueness.desc")).category(new Category[]{Categories.GENERAL})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}determine-process-uniqueness-aplication")).icon((Icon)SilkIconPack.PACKAGE)).parameter().id("variables").name("application.general.uniqueness.variables_param.name").description("application.general.uniqueness.variables_param.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("targetVariable").name("application.general.uniqueness.target_param.name").description("application.general.uniqueness.target_param.desc").type((Type)Types.VARIABLE).create()).parameter().id("exclusionVariables").name("application.general.uniqueness.exclusionVariables.name").description("application.general.uniqueness.exclusionVariables.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("exclusionValues").name("application.general.uniqueness.exclusionValues.name").description("application.general.uniqueness.exclusionValues.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("trueValue").name("application.general.uniqueness.true_val_param.name").description("application.general.uniqueness.true_val_param.desc").type((Type)Types.STRING).create()).parameter().id("falseValue").name("application.general.uniqueness.false_val_param.name").description("application.general.uniqueness.false_val_param.name").type((Type)Types.STRING).create()).parameter().id("commentError").name("application.database.defaults.comment_error.name").description("application.database.defaults.comment_error.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(ApplicationContext context, @Param Variable[] variables, @Param Variable targetVariable, @Param Variable[] exclusionVariables, @Param String[] exclusionValues, @Param String trueValue, @Param String falseValue, @Param Boolean commentError, Translator translator) throws Exception {
        try {
            ProcessFinder processFinder = FinderFactory.getProcessFinder();
            String processDefId = this.getProcessDefId(context);
            List<IndexFilter> filters = this.buildFilters(variables, context.getProcessId(), exclusionVariables, exclusionValues);
            List duplicates = processFinder.findByIndexes(processDefId, filters, new String[0]);
            this.handleResult(duplicates, trueValue, falseValue, targetVariable);
        }
        catch (SQLGrammarException e) {
            this.handleResult(new ArrayList<Process>(), trueValue, falseValue, targetVariable);
        }
        catch (Exception e) {
            if (!commentError.booleanValue()) {
                throw e;
            }
            ApplicationCommentHandler handler = new ApplicationCommentHandler(this.commentService, context.getProcessId(), context.getActivityId(), e);
            ErrorHandlersExecution handlerExecution = new ErrorHandlersExecution(e, handler);
            handlerExecution.handle();
        }
    }

    private String getProcessDefId(ApplicationContext validationContext) {
        Process process = this.processService.getProcess(validationContext.getProcessId(), new String[]{"processDefinition"});
        return process.getProcessDefinition().getProcessDefinitionId();
    }

    private void handleResult(List<Process> duplicates, String trueValue, String falseValue, Variable targetVariable) {
        if (!duplicates.isEmpty()) {
            Map<String, Object> context = this.getDuplicateProcessContext(duplicates);
            String msg = AlertInterpreter.getInterpreted(trueValue, context);
            targetVariable.setValue((Object)msg);
        } else {
            targetVariable.setValue((Object)falseValue);
        }
    }

    private Map<String, Object> getDuplicateProcessContext(List<Process> duplicates) {
        if (duplicates.size() > 0) {
            return this.processService.getProcessContext(duplicates.get(0).getProcessId());
        }
        return new HashMap<String, Object>();
    }

    private List<IndexFilter> buildFilters(Variable[] variables, String processId, Variable[] exclusionVariables, String[] exclusionValues) {
        IndexFiltersBuilder ifb = IndexFiltersBuilder.getProperIndexFiltersBuilder();
        ifb.addFilter((IndexFilter)new SimpleIndexFilter("processId", (Object)processId, FilterOperator.NOTEQ));
        for (Variable variable : variables) {
            log.debug("Warto\u015b\u0107 sprawdzana: " + variable.getValueAsPmidxType());
            if (variable.getValueAsPmidxType() == null || this.isOracleString(variable)) {
                log.debug("Dodaje filtr dla nulla");
                ifb.addFilter((IndexFilter)new SimpleIndexFilter(variable.getId(), null, FilterOperator.ISNULL));
            } else if (this.isOracleBoolean(variable)) {
                int booleanAsNumber = Boolean.valueOf((String)variable.getValueAsPmidxType()) != false ? 1 : 0;
                ifb.addEqualFilter(variable.getId(), booleanAsNumber, (Type<?>)Types.INTEGER);
            } else {
                log.debug("Dodaje zwykly filtr");
                ifb.addEqualFilter(variable.getId(), variable.getValueAsPmidxType(), variable.getType());
            }
            if (exclusionVariables == null || exclusionValues == null || exclusionValues.length != exclusionVariables.length || exclusionValues.length <= 0) continue;
            IndexFiltersBuilder indexFiltersToJoinWithOr = IndexFiltersBuilder.getProperIndexFiltersBuilder();
            for (int i = 0; i < exclusionVariables.length; ++i) {
                Object value = exclusionVariables[i].getPmidxType().convert(exclusionValues[i]);
                log.debug("Warto\u015b\u0107 pomijana: " + value);
                if (value == null || this.isOracleString(exclusionVariables[i], value)) {
                    log.debug("Dodaje filtr dla nulla");
                    indexFiltersToJoinWithOr.addFilter((IndexFilter)new SimpleIndexFilter(exclusionVariables[i].getId(), null, FilterOperator.NOTNULL));
                    continue;
                }
                if (exclusionVariables[i].getType() == Types.STRING) {
                    log.debug("Dodaje filtr dla braku rozrozniania wielkosci znakow");
                    indexFiltersToJoinWithOr.addFilter((IndexFilter)new SimpleIndexFilter(exclusionVariables[i].getId(), value, FilterOperator.NOTILIKE));
                    continue;
                }
                if (this.isOracleBoolean(exclusionVariables[i])) {
                    int booleanAsNumber = Boolean.valueOf((String)value) != false ? 1 : 0;
                    indexFiltersToJoinWithOr.addEqualFilter(exclusionVariables[i].getId(), booleanAsNumber, (Type<?>)Types.INTEGER);
                    continue;
                }
                log.debug("Dodaje zwykly filtr");
                indexFiltersToJoinWithOr.addNotEqualFilter(exclusionVariables[i].getId(), value, exclusionVariables[i].getType());
            }
            GroupIndexFilter indexFiltersJoinedWithOr = new GroupIndexFilter(indexFiltersToJoinWithOr.getFilters(), LogicOperator.OR);
            ifb.addFilter((IndexFilter)indexFiltersJoinedWithOr);
        }
        return ifb.getFilters();
    }

    private boolean isOracleBoolean(Variable variable) {
        return variable.getType() == Types.BOOLEAN && MainDBInfo.getMainDBType() == MainDBInfo.DBType.ORACLE;
    }

    private boolean isOracleString(Variable variable, Object value) {
        return variable.getType() == Types.STRING && value.equals("") && MainDBInfo.getMainDBType() == MainDBInfo.DBType.ORACLE;
    }

    private boolean isOracleString(Variable variable) {
        return variable.getType() == Types.STRING && variable.getValueAsPmidxType().equals("") && MainDBInfo.getMainDBType() == MainDBInfo.DBType.ORACLE;
    }
}

