/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.libreoffice.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeArchivingException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeDecryptionException;
import com.suncode.cuf.common.documents.libreoffice.services.LibreOfficeService;
import com.suncode.cuf.common.utils.AutoCloseableTempFile;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileCipherService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="/scripts/dynamic-pwe/convert-document-to-pdf.js")
public class ConvertDocumentToPdf {
    private static final Logger log = LoggerFactory.getLogger(ConvertDocumentToPdf.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private FileCipherService fileCipherService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;
    @Autowired
    private LibreOfficeService libreOfficeService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf")).name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.name")).description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.desc")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)SilkIconPack.PAGE_WHITE_ACROBAT)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}convert-document-to-pdf-application")).parameter().id("sourceClassName").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.sourceClassName.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.sourceClassName.desc").type((Type)Types.STRING).create()).parameter().id("destinationClassName").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.destinationClassName.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.destinationClassName.desc").type((Type)Types.STRING).create()).parameter().id("newVersion").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.newVersion.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.newVersion.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("interrupt").name("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.interrupt.name").description("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf.param.interrupt.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void execute(@Param String sourceClassName, @Param Boolean newVersion, @Param String destinationClassName, @Param Boolean interrupt, ApplicationContext appContext, UserInfo userInfo) throws AcceptanceException, IOException {
        if (!this.libreOfficeService.checkLicence("com.suncode.plugin-libreoffice-integrator")) {
            throw new AcceptanceException("Invalid LibreOffice Integrator licence!");
        }
        String processId = appContext.getProcessId();
        List docsFromProcess = this.documentFinder.getDocumentsFromProcessAndClass(processId, sourceClassName, new String[0]).stream().filter(wfDocument -> this.libreOfficeService.checkFileType(wfDocument.getFile().getFullPath())).collect(Collectors.toList());
        if (docsFromProcess.isEmpty()) {
            return;
        }
        Map<WfDocument, CompletableFuture> futures = docsFromProcess.stream().collect(Collectors.toMap(wfDocument -> wfDocument, wfDocument -> this.requestConversion(wfDocument.getFile())));
        HashMap<WfDocument, String> successfulConversions = new HashMap<WfDocument, String>();
        HashMap<WfDocument, Throwable> failedConversions = new HashMap<WfDocument, Throwable>();
        for (Map.Entry<WfDocument, CompletableFuture> entry : futures.entrySet()) {
            WfDocument wfDocument2 = entry.getKey();
            CompletableFuture future = entry.getValue();
            try {
                String outputPath2 = (String)future.join();
                successfulConversions.put(wfDocument2, outputPath2);
            }
            catch (CompletionException e) {
                failedConversions.put(wfDocument2, e.getCause());
            }
        }
        if (!failedConversions.isEmpty()) {
            log.warn("Document(s) conversion error: ");
            failedConversions.forEach((doc, ex) -> log.warn(doc.getFile().getFileName() + ": " + ex.getMessage()));
            if (Boolean.TRUE.equals(interrupt)) {
                throw new AcceptanceException("Errors occurred and interrupt param was set");
            }
        }
        if (!successfulConversions.isEmpty()) {
            String username = userInfo != null ? userInfo.getUserName() : SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME");
            Long destinationClassId = this.documentClassService.getDocumentClass(Boolean.TRUE.equals(newVersion) ? sourceClassName : destinationClassName, new String[0]).getId();
            successfulConversions.forEach((wfDocument, outputPath) -> this.addToArchive(newVersion, processId, username, destinationClassId, (WfDocument)wfDocument, (String)outputPath));
        }
    }

    private void addToArchive(Boolean newVersion, String processId, String username, Long destinationClassId, WfDocument wfDocument, String outputPath) {
        try {
            this.addDocument(Paths.get(outputPath, new String[0]).toFile(), wfDocument, username, processId, destinationClassId, newVersion);
        }
        catch (LibreOfficeArchivingException e) {
            throw new AcceptanceException(e.getMessage());
        }
        finally {
            Files.deleteIfExists(Paths.get(outputPath, new String[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CompletableFuture<String> requestConversion(WfFile wfFile) {
        String outputPath = this.getTempPdfFilePath();
        if (!wfFile.isEncrypted()) return this.libreOfficeService.convertToPdfAsync(wfFile.getFullPath(), outputPath, SystemProperties.getString((String)"Installation.Path"));
        AutoCloseableTempFile tempFile = new AutoCloseableTempFile();
        try {
            this.decryptFile(wfFile, tempFile);
            CompletableFuture<String> completableFuture = this.libreOfficeService.convertToPdfAsync(tempFile.getFile().getAbsolutePath(), outputPath, SystemProperties.getString((String)"Installation.Path"));
            tempFile.close();
            return completableFuture;
        }
        catch (Throwable throwable) {
            try {
                try {
                    tempFile.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (LibreOfficeDecryptionException e) {
                CompletableFuture<String> failed = new CompletableFuture<String>();
                failed.completeExceptionally(e);
                return failed;
            }
        }
    }

    private void decryptFile(WfFile inputFile, TempFile tempFile) throws LibreOfficeDecryptionException {
        try (FileInputStream inputStream = new FileInputStream(inputFile.getFullPath());
             InputStream decryptedInputStream = this.fileCipherService.decryptFile((InputStream)inputStream, inputFile.getCipherAlgorithm(), inputFile.getCipherKey());){
            FileUtils.copyInputStreamToFile((InputStream)decryptedInputStream, (File)tempFile.getFile());
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("Error decrypting file: " + inputFile.getFileName());
            throw new LibreOfficeDecryptionException("Error decrypting file: " + inputFile.getFileName());
        }
    }

    private void addDocument(File newFile, WfDocument sourceDocument, String username, String processId, Long newClassId, Boolean newVersion) throws LibreOfficeArchivingException {
        try (FileInputStream is = new FileInputStream(newFile);){
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(newClassId);
            definition.setFileName(this.newFileName(sourceDocument.getFile().getFileName()));
            definition.setDescription(sourceDocument.getFile().getDescription());
            definition.setUserName(username);
            definition.setInputStream((InputStream)is);
            definition.setProcessId(processId);
            if (Boolean.TRUE.equals(newVersion)) {
                this.fileService.checkIn(definition, Long.valueOf(sourceDocument.getFile().getId()), "");
            } else {
                this.documentService.addDocument(definition).getId();
            }
        }
        catch (Exception e) {
            throw new LibreOfficeArchivingException(e.getMessage());
        }
    }

    private String newFileName(String filename) {
        CharSequence[] words = filename.split("\\.");
        if (words.length > 1) {
            words[words.length - 1] = "pdf";
        }
        return String.join((CharSequence)".", words);
    }

    private String getTempPdfFilePath() {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        String uniqueId = UUID.randomUUID().toString();
        return Paths.get(workingDirectory, "temp_" + uniqueId + ".pdf").toString();
    }
}

