/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/detach-documents-from-process.js")
public class DetachDocumentsFromProcess {
    private static final Logger log = LoggerFactory.getLogger(DetachDocumentsFromProcess.class);
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private CUFCommonDocumentService cufCommonDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("detach-documents-from-process")).name("application.detach-documents-from-process.name")).description("application.detach-documents-from-process.desc")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)DivanteIcon.DELETE)).parameter().id("detachDocumentsBy").name("application.detach-documents-from-process.detachDocumentsBy.name").description("application.detach-documents-from-process.detachDocumentsBy.desc").type((Type)Types.STRING).create()).parameter().id("fileIds").name("application.detach-documents-from-process.fileIds.name").description("application.detach-documents-from-process.fileIds.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("documentClassName").name("application.detach-documents-from-process.documentClassName.name").description("application.detach-documents-from-process.documentClassName.desc").type((Type)Types.STRING).optional().create()).parameter().id("documentIds").name("application.detach-documents-from-process.documentIds.name").description("application.detach-documents-from-process.documentIds.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("removeDetachedDocumentsFromArchive").name("application.detach-documents-from-process.removeDetachedDocumentsFromArchive.name").description("application.detach-documents-from-process.removeDetachedDocumentsFromArchive.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(ApplicationContext context, @Param String detachDocumentsBy, @Param Integer[] fileIds, @Param String documentClassName, @Param Integer[] documentIds, @Param Boolean removeDetachedDocumentsFromArchive) throws Exception {
        this.run(context.getProcessId(), detachDocumentsBy, fileIds, documentClassName, documentIds, removeDetachedDocumentsFromArchive);
    }

    public void set(AcceptanceContext context, @Param String detachDocumentsBy, @Param Integer[] fileIds, @Param String documentClassName, @Param Integer[] documentIds, @Param Boolean removeDetachedDocumentsFromArchive) throws Exception {
        this.run(context.getProcessId(), detachDocumentsBy, fileIds, documentClassName, documentIds, removeDetachedDocumentsFromArchive);
    }

    public void run(String processId, String detachDocumentsBy, Integer[] fileIds, String documentClassName, Integer[] documentIds, Boolean removeDetachedDocumentsFromArchive) throws Exception {
        block4: {
            try {
                Assert.hasText((String)detachDocumentsBy, (String)"Detach documents by cannot be empty.");
                if (detachDocumentsBy.equals("FILE_IDS")) {
                    List documentsInProcess = this.documentFinder.getDocumentsFromProcess(processId, new String[0]);
                    this.cufCommonDocumentService.detachDocumentsFromProcessByFileIds(processId, fileIds, documentsInProcess, removeDetachedDocumentsFromArchive);
                    break block4;
                }
                if (detachDocumentsBy.equals("DOCUMENT_IDS")) {
                    List documentsInProcess = this.documentFinder.getDocumentsFromProcessAndClass(processId, documentClassName, new String[0]);
                    this.cufCommonDocumentService.detachDocumentsFromProcessByDocumentIds(documentClassName, documentIds, documentsInProcess, processId, removeDetachedDocumentsFromArchive);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown document detachment mode: " + detachDocumentsBy);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AcceptanceException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

