/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.validators;

import com.google.common.collect.ListMultimap;
import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.db.utils.MainDBInfo;
import com.suncode.cuf.common.db.utils.converters.DBConverter;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.ValidatorUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
public class DBValidator {
    private static final Logger log = LoggerFactory.getLogger(DBValidator.class);
    @Autowired
    private DBService dbService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("db-validator")).name("validator.db-validator.name")).description("validator.db-validator.desc")).category(new Category[]{Categories.DATABASE})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}database-query-result-validator")).icon((Icon)SilkIconPack.SCRIPT)).parameter().id("acceptResults").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("dbName").name("validator.db-validator.db-name.name").description("validator.db-validator.db-name.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("queryName").name("validator.db-validator.query-name.name").description("validator.db-validator.query-name.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("variablesParams").name("validator.db-validator.variables-params.name").description("validator.db-validator.variables-params.desc").type((com.suncode.pwfl.core.type.Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("queryParams").name("validator.db-validator.query-params.name").description("validator.db-validator.query-params.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).optional().create()).parameter().id("queryParamsTypes").name("validator.db-validator.query-params-types.name").description("validator.db-validator.query-params-types.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).optional().create()).parameter().id("messageType").name("validator.db-validator.message-type.name").description("validator.db-validator.message-type.desc").defaultValue((Object)"global").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("confirmation").name("validator.db-validator.confirmation.name").description("validator.db-validator.confirmation.desc").type((com.suncode.pwfl.core.type.Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("alert").name("validator.db-validator.alert.name").type((com.suncode.pwfl.core.type.Type)Types.STRING).optional().create()).parameter().id("errorVariables").name("validator.db-validator.error-variables.name").description("validator.db-validator.error-variables.desc").type((com.suncode.pwfl.core.type.Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("errorVariablesMessages").name("validator.db-validator.error-variables-messages.name").description("validator.db-validator.error-variables-messages.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).optional().create();
    }

    public void validate(ValidationErrors errors, ValidationContext validationContext, @Param Boolean acceptResults, @Param String dbName, @Param String queryName, @Param Variable[] variablesParams, @Param String[] queryParams, @Param String[] queryParamsTypes, @Param String messageType, @Param Boolean confirmation, @Param String alert, @Param Variable[] errorVariables, @Param String[] errorVariablesMessages, Translator translator) {
        try {
            this.validateParams(variablesParams);
            List<DBQueryConfig> queriesConfigurations = this.getQueriesConfigurations(dbName, queryName, variablesParams, queryParams, queryParamsTypes);
            List<Map<String, Object>> queriesResult = this.dbService.mergeQueriesAndReturnValues(queriesConfigurations);
            List<Integer> notValidRows = this.getNotValidRows(queriesResult, acceptResults, queriesConfigurations.size());
            if (notValidRows.size() > 0) {
                ValidatorUtils.validationFailed(messageType, confirmation, alert, translator, errors, errorVariables, errorVariablesMessages, notValidRows);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private List<Integer> getNotValidRows(List<Map<String, Object>> queriesResult, Boolean acceptResults, int size) {
        ListMultimap<String, Object> result = DataConverter.convertMapListToMultimap(queriesResult);
        ArrayList<Integer> notValidRows = new ArrayList<Integer>();
        List rowsWithReturnedValue = result.get((Object)"RESULT");
        if (rowsWithReturnedValue.size() == 0) {
            rowsWithReturnedValue = result.get((Object)"result");
        }
        for (int i = 0; i < size; ++i) {
            if (rowsWithReturnedValue.size() == 0) {
                if (!acceptResults.booleanValue()) continue;
                notValidRows.add(new Integer(i));
                continue;
            }
            if (!this.validateRow(acceptResults, rowsWithReturnedValue, i)) continue;
            notValidRows.add(new Integer(i));
        }
        return notValidRows;
    }

    private boolean validateRow(Boolean acceptResults, List<Object> rowsWithReturnedValue, int i) {
        if (rowsWithReturnedValue.get(0) instanceof BigDecimal) {
            return acceptResults != false && !rowsWithReturnedValue.contains(new BigDecimal(i)) || acceptResults == false && rowsWithReturnedValue.contains(new BigDecimal(i));
        }
        if (rowsWithReturnedValue.get(0) instanceof Integer) {
            return acceptResults != false && !rowsWithReturnedValue.contains(new Integer(i)) || acceptResults == false && rowsWithReturnedValue.contains(new Integer(i));
        }
        return acceptResults != false && !rowsWithReturnedValue.contains(new Long(i)) || acceptResults == false && rowsWithReturnedValue.contains(new Long(i));
    }

    private void validateParams(Variable[] variablesParams) throws IllegalArgumentException {
        int length = -1;
        for (Variable variable : variablesParams) {
            if (!variable.isArray()) continue;
            if (length == -1) {
                length = ((Object[])variable.getValue()).length;
                continue;
            }
            if (length == ((Object[])variable.getValue()).length) continue;
            throw new IllegalArgumentException("Variable parameters do not belong to the same dynamic table/are not the same length!");
        }
    }

    private List<DBQueryConfig> getQueriesConfigurations(String dbName, String queryName, Variable[] variablesParams, String[] constantParamsAsStrings, String[] constantParamsTypes) {
        com.suncode.pwfl.core.type.Type<?>[] constantParametersTypes = DataConverter.convertStringsToTypes(constantParamsTypes);
        com.suncode.pwfl.core.type.Type<?>[] allParametersTypes = CommonUtils.concat(DataConverter.getTypesFromVariables(variablesParams), constantParametersTypes);
        DBConverter dbConverter = this.getDBConverter(dbName);
        Type[] allParametersTypesConverted = dbConverter.convertToHibernateTypes(allParametersTypes);
        Object[] constantParams = dbConverter.convertValuesToProperSingleDBTypes(constantParamsAsStrings, constantParametersTypes, false);
        int numberOfQueries = this.getVariableParamMaxLength(variablesParams);
        ArrayList<DBQueryConfig> queries = new ArrayList<DBQueryConfig>();
        for (int arrayParamIndex = 0; arrayParamIndex < numberOfQueries; ++arrayParamIndex) {
            Object[] params = ArrayUtils.addAll((Object[])dbConverter.getValidDBValuesFromVariables(variablesParams, arrayParamIndex, false), (Object[])constantParams);
            DBQueryConfig dbQuery = DBQueryConfig.builder().dbName(dbName).queryKey(queryName).queryParams(params).queryParamsTypes(allParametersTypesConverted).build();
            queries.add(dbQuery);
        }
        return queries;
    }

    private DBConverter getDBConverter(String dbName) {
        MainDBInfo.DBType dbType = this.dbService.getDBType(dbName);
        return DBConverter.getProperDBConverter(dbType);
    }

    private int getVariableParamMaxLength(Variable[] variablesParams) {
        for (Variable variable : variablesParams) {
            if (!variable.isArray()) continue;
            return ((Object[])variable.getValue()).length;
        }
        return 1;
    }
}

