/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.datachoosers.utils;

import com.suncode.cuf.common.db.datachoosers.utils.ConditionOperator;
import com.suncode.cuf.common.db.datachoosers.utils.ConstraintValidationException;
import org.springframework.util.StringUtils;

public class ConstraintValidation {
    public static void validateConstraints(String[] ... constraints) throws ConstraintValidationException {
        for (String[] constraintArray : constraints) {
            if (constraintArray == null) continue;
            for (String constraint : constraintArray) {
                if (ConstraintValidation.isConstraintValid(constraint)) continue;
                throw new ConstraintValidationException(constraint);
            }
        }
    }

    private static boolean isConstraintValid(String constraint) {
        boolean constraintValid = true;
        if (StringUtils.hasText((String)constraint)) {
            String[] constraintComponents = constraint.split(" ");
            if (constraintComponents.length != 3) {
                constraintValid = false;
            } else if (!ConstraintValidation.isOperatorValid(constraintComponents[1])) {
                constraintValid = false;
            }
        }
        return constraintValid;
    }

    private static boolean isOperatorValid(String operator) {
        boolean operatorValid = false;
        ConditionOperator condOperator = ConditionOperator.getOperator(operator);
        if (condOperator != null) {
            operatorValid = true;
        }
        return operatorValid;
    }
}

