/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db;

import com.google.common.collect.ListMultimap;
import com.suncode.cuf.common.db.DBQueryConfig;
import com.suncode.cuf.common.db.services.DBService;
import com.suncode.cuf.common.utils.CommonUtils;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.PredefinedQueryUtils;
import com.suncode.pwfl.core.type.StringType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.variable.Variable;
import jakarta.persistence.NoResultException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class PredefinedQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(PredefinedQueryExecutor.class);
    @Autowired
    DBService dbService;

    public void executeQueryAndSetVariables(ActivityContextMap activityContext, String database, String queryTable, String typeOfQuery, String queryName, String[] queryParams, Variable[] targetVariables, String multipleValuesHandlingMethod, Boolean overwrite) {
        Object[] paramsValues = PredefinedQueryUtils.getParamsValuesFromActivityContext(activityContext, queryParams);
        DBQueryConfig dbConfig = DBQueryConfig.builder().dbName(database).queryKey(queryName).queryTable(queryTable).queryParams(paramsValues).build();
        if ("update".equalsIgnoreCase(typeOfQuery)) {
            this.dbService.executeQuery(dbConfig);
        } else {
            List<Map<String, Object>> returnedDbData = this.dbService.getDataFromQuery(dbConfig);
            ListMultimap<String, Object> dbDataMultimap = DataConverter.convertMapListToMultimap(returnedDbData);
            log.debug("Data returned from DB: {}", dbDataMultimap);
            for (String key : dbDataMultimap.keySet()) {
                this.setValuesToProcessVariables(key, dbDataMultimap, targetVariables, multipleValuesHandlingMethod, overwrite);
            }
        }
    }

    public List<Map<String, Object>> executeQueryAndReturnData(String database, String queryTable, String queryName, String[] queryParams) {
        Object[] paramsValues = queryParams == null ? new Object[]{} : PredefinedQueryUtils.getParamsValuesFromActivityContext(null, queryParams);
        DBQueryConfig dbQueryCfg = DBQueryConfig.builder().dbName(database).queryKey(queryName).queryTable(queryTable).queryParams(paramsValues).build();
        log.debug("DBQueryConfig: " + dbQueryCfg.toString());
        return this.dbService.getDataFromQuery(dbQueryCfg);
    }

    private void setValuesToProcessVariables(String key, ListMultimap<String, Object> returnedDbData, Variable[] targetVariables, String multipleValuesHandlingMethod, Boolean overwrite) {
        List returnedValues = returnedDbData.get((Object)key);
        if (returnedValues == null) {
            throw new NoResultException("Nie znaleziono kolumny o kluczu: " + key + " w tabeli z zapytania!");
        }
        Variable respectiveVariable = this.getRespectiveVariable(targetVariables, key.toLowerCase());
        if (respectiveVariable.isArray()) {
            this.setArrayValues(returnedValues, respectiveVariable, overwrite);
        } else if (returnedValues.size() > 1) {
            this.handleMultipleValuesForNonArrayVariable(returnedValues, respectiveVariable, multipleValuesHandlingMethod);
        } else {
            this.setOrdinaryValue(returnedValues, respectiveVariable);
        }
    }

    private Variable getRespectiveVariable(Variable[] targetVariables, String key) {
        for (Variable variable : targetVariables) {
            if (!variable.getId().equals(key)) continue;
            return variable;
        }
        throw new NoResultException("Nie znaleziono zmiennej o id: " + key);
    }

    private void setOrdinaryValue(List<Object> returnedValues, Variable respectiveVariable) {
        log.debug("*** Attempting to set variable {}", (Object)respectiveVariable.getId());
        Object value = returnedValues.get(0) == null ? null : DataConverter.dbObjectToPWFLObject(returnedValues.get(0), respectiveVariable.getType());
        log.debug("with value: {}", value);
        respectiveVariable.setValue(value);
    }

    private void setArrayValues(List<Object> returnedValues, Variable respectiveVariable, Boolean overwrite) {
        respectiveVariable.setValue((Object)this.prepareArrayValueToSet(returnedValues, respectiveVariable, overwrite));
    }

    private Object[] prepareArrayValueToSet(List<Object> returnedValues, Variable variable, Boolean overwrite) {
        int i;
        Object[] data = DataConverter.dbArrayToPWFLArray(returnedValues.toArray(), variable.getType());
        if (overwrite.booleanValue()) {
            return data;
        }
        int currentColumnLength = CommonUtils.isColumnEmpty((Object[])variable.getValue()) ? 0 : ((Object[])variable.getValue()).length;
        Object[] result = CommonUtils.createTableOfType(currentColumnLength + data.length, variable.getType());
        for (i = 0; i < currentColumnLength; ++i) {
            result[i] = ((Object[])variable.getValue())[i];
        }
        for (i = 0; i < data.length; ++i) {
            result[currentColumnLength + i] = data[i];
        }
        return result;
    }

    private void handleMultipleValuesForNonArrayVariable(List<Object> returnedValues, Variable respectiveVariable, String multipleValuesHandlingMethod) {
        Type type = respectiveVariable.getType();
        log.debug("Multiple values handling method: {}", (Object)multipleValuesHandlingMethod);
        if (multipleValuesHandlingMethod.equalsIgnoreCase("block") || !StringUtils.hasText((String)multipleValuesHandlingMethod)) {
            throw new RuntimeException("Cannot add multiple values to a non-array variable with multiple value handling unspecified or set to BLOCK!");
        }
        if (multipleValuesHandlingMethod.equalsIgnoreCase("unique")) {
            Assert.isTrue((type == Types.STRING ? 1 : 0) != 0, (String)"Cannot add multiple values to a non-array variable which is also of a different type than string!");
            this.setMultipleValuesToStringVariable(respectiveVariable, returnedValues);
        } else if (multipleValuesHandlingMethod.equalsIgnoreCase("first")) {
            this.setOrdinaryValue(returnedValues, respectiveVariable);
        } else {
            throw new RuntimeException("Incorrect multiple values handling method specified!");
        }
    }

    private void setMultipleValuesToStringVariable(Variable respectiveVariable, List<Object> returnedValues) {
        StringType stringType = Types.STRING;
        StringBuilder sb = new StringBuilder();
        HashSet<String> valuesSet = new HashSet<String>();
        for (Object returnedValue : returnedValues) {
            String stringValue = (String)stringType.read(returnedValue);
            if (valuesSet.contains(stringValue)) continue;
            valuesSet.add(stringValue);
            sb.append(stringValue).append(";");
        }
        respectiveVariable.setValue((Object)sb.substring(0, sb.length() - 1));
    }
}

