/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.datasource.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.ValidatorUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.ValidatorMessage;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.Confirmation;
import com.suncode.pwfl.workflow.form.validator.error.DefinedConfirmation;
import com.suncode.pwfl.workflow.form.validator.error.DefinedError;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Validator
@ComponentsFormScript(value="scripts/dynamic-pwe/datasource-validator.js")
public class DataSourceValidator {
    private static final Logger log = LoggerFactory.getLogger(DataSourceValidator.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("datasource-validator")).name("validator.datasource-validator.name")).description("validator.datasource-validator.desc")).category(new Category[]{Categories.DATASOURCES})).icon((Icon)SilkIconPack.SCRIPT)).messageTypes(new ValidatorMessage[]{ValidatorMessage.CONFIRMATION, ValidatorMessage.ERROR}).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}validate-queries-to-datasources")).parameter().id("acceptResults").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("datasource").name("datasource.param.datasource.name").description("datasource.param.datasource.desc").type((Type)Types.STRING).create()).parameter().id("datasources").name("datasource.param.datasources.name").description("datasource.param.datasources.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("datasourceInputParametersId").name("datasource.datasourceInputParametersId.name").description("datasource.datasourceInputParametersId.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceInputParametersValue").name("datasource.datasourceInputParametersValue.name").description("datasource.datasourceInputParametersValue.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("messageType").name("datasource-validator.messageType.name").description("datasource-validator.messageType.desc").type((Type)Types.STRING).optional().create()).parameter().id("globalErrorMessage").name("datasource-validator.globalErrorMessage.name").type((Type)Types.STRING).optional().create()).parameter().id("errorVariables").name("datasource-validator.errorVariables.name").description("datasource-validator.errorVariables.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("errorVariablesMessages").name("datasource-validator.errorVariablesMessages.name").description("datasource-validator.errorVariablesMessages.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("confirmation").name("datasource-validator.confirmation.name").description("datasource-validator.confirmation.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create();
    }

    public void validate(@Param DataSourceInstance datasource, Parameters parameters, ValidationErrors errors, DefinedError error, DefinedConfirmation confirmation, Translator translator) {
        boolean hasDataSourceResults;
        Assert.notNull((Object)datasource, (String)"Chosen datasource does not exist!");
        String[] datasourceInputParametersId = (String[])parameters.get("datasourceInputParametersId", String[].class);
        Map<String, String> datasourceInputParameters = IntStream.range(0, datasourceInputParametersId.length).boxed().filter(i -> datasource.getInputParameters().stream().anyMatch(datasourceInputParameter -> datasourceInputParameter.getId().equals(datasourceInputParametersId[i]))).collect(Collectors.toMap(i -> datasourceInputParametersId[i], i -> DataConverter.argumentToStringArray(parameters.getRaw("datasourceInputParametersValue"))[i]));
        boolean acceptResults = (Boolean)parameters.get("acceptResults", Boolean.TYPE);
        CountedResult countedData = datasource.execute(datasourceInputParameters, null);
        boolean bl = hasDataSourceResults = countedData.getTotal() > 0L || !countedData.getData().isEmpty();
        if (acceptResults != hasDataSourceResults) {
            String datasourceValidationFailed = "Datasource validation failed!";
            if (confirmation.getTitle().isEmpty()) {
                log.debug(datasourceValidationFailed);
                log.debug(error.getMessage());
                String globalErrorMessage = (String)parameters.get("globalErrorMessage", String.class);
                Variable[] errorVariables = (Variable[])parameters.get("errorVariables", Variable[].class);
                String[] errorVariablesMessages = (String[])parameters.get("errorVariablesMessages", String[].class);
                errorVariablesMessages = this.convertMultipleMessage(errorVariablesMessages, countedData.getData());
                String messageType = (String)parameters.get("messageType", String.class);
                messageType = messageType == null ? "oldglobal" : messageType;
                String errorMessage = messageType.equals("oldglobal") ? error.getMessage() : globalErrorMessage;
                errorMessage = this.convertMessage(errorMessage, countedData.getData());
                messageType = messageType.equals("oldglobal") ? "global" : messageType;
                ValidatorUtils.validationFailed(messageType, (Boolean)parameters.get("confirmation", Boolean.class), errorMessage, translator, errors, errorVariables, errorVariablesMessages, new ArrayList<Integer>());
            } else {
                log.debug(datasourceValidationFailed);
                log.debug("Confirmation required...");
                errors.addConfirmation((Confirmation)confirmation);
            }
        }
    }

    private String[] convertMultipleMessage(String[] textArray, List<Map<String, Object>> dataList) {
        return (String[])Arrays.stream(textArray).map(text -> this.convertMessage((String)text, dataList)).toArray(String[]::new);
    }

    private String convertMessage(String text, List<Map<String, Object>> dataList) {
        Pattern pattern = Pattern.compile("\\{([^}]*)}");
        Matcher matcher = pattern.matcher(text);
        StringBuffer resultText = new StringBuffer();
        while (matcher.find()) {
            String extractedCurly = matcher.group(1);
            int squareBracketIndex = extractedCurly.indexOf(91);
            if (squareBracketIndex != -1) {
                String beforeSquare = extractedCurly.substring(0, squareBracketIndex);
                String insideSquare = extractedCurly.substring(squareBracketIndex + 1, extractedCurly.indexOf(93));
                String result = Optional.of(insideSquare).filter(NumberUtils::isDigits).map(Integer::valueOf).filter(i -> i < dataList.size()).map(i -> ((Map)dataList.get((int)i)).getOrDefault(beforeSquare, "").toString()).orElse("");
                matcher.appendReplacement(resultText, result);
                continue;
            }
            String result = dataList.stream().filter(map -> map.containsKey(extractedCurly)).map(map -> map.get(extractedCurly)).filter(String.class::isInstance).map(String.class::cast).collect(Collectors.joining(", "));
            matcher.appendReplacement(resultText, result);
        }
        matcher.appendTail(resultText);
        return resultText.toString();
    }
}

