/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.currency;

import com.suncode.cuf.currency.ExchangeService;
import com.suncode.cuf.currency.RateDto;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/exchangerate"})
public class PLNExchangeRateController {
    private static final Logger log = LoggerFactory.getLogger(PLNExchangeRateController.class);
    @Autowired
    ExchangeService exchangeService;

    @ResponseBody
    @RequestMapping(value={"/pln"}, method={RequestMethod.GET})
    public RateDto getExchangeRate(@RequestParam String currency, @RequestParam Date date, @RequestParam(required=false, defaultValue="false") Boolean nbptimezone, @RequestParam(required=false) String activityId) throws Exception {
        return this.processRequest(currency, date, nbptimezone, activityId);
    }

    @ResponseBody
    @RequestMapping(value={"/notimezone/pln"}, method={RequestMethod.GET})
    public RateDto getExchangeRateNoTimezone(@RequestParam String currency, @RequestParam String date, @RequestParam(required=false) String activityId) throws Exception {
        return this.processRequest(currency, date, null, activityId);
    }

    private RateDto processRequest(String currency, Object date, Boolean nbptimezone, String activityId) throws Exception {
        LocalDate parsedDate;
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            log.info("Activity ID: {}", (Object)activityId);
        }
        log.info("Requested currency: {}", (Object)currency);
        log.info("Requested date: {}", date);
        if (date == null || currency == null) {
            throw new IllegalArgumentException("Nieprawid\u0142owy parametr data lub waluta");
        }
        if ("PLN".equals(currency)) {
            RateDto rate = new RateDto();
            rate.setMid(Double.valueOf(1.0));
            return rate;
        }
        if (date instanceof String) {
            parsedDate = LocalDate.parse((String)date);
        } else if (date instanceof Date) {
            parsedDate = Boolean.TRUE.equals(nbptimezone) ? ((Date)date).toInstant().atZone(ZoneId.of("Europe/Warsaw")).toLocalDate() : ((Date)date).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        } else {
            throw new IllegalArgumentException("Requested date format not supported");
        }
        RateDto rate = this.exchangeService.getLastNbpExchangeWithTableSymbol(currency, parsedDate);
        log.info("Date sent to NBP service: {}", (Object)parsedDate);
        log.info("Received rate: {}", (Object)rate);
        if (rate == null) {
            throw new IllegalArgumentException("Nie znaleziono kursu dla podanej waluty: " + currency + " i daty: " + parsedDate);
        }
        return rate;
    }
}

